/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.plugin.deployment;

import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Collections;
import java.util.List;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.jboss.as.controller.client.ModelControllerClient;
import org.jboss.as.controller.client.helpers.standalone.DeploymentAction;
import org.jboss.as.controller.client.helpers.standalone.DeploymentPlan;
import org.jboss.as.controller.client.helpers.standalone.DeploymentPlanBuilder;
import org.jboss.as.controller.client.helpers.standalone.InitialDeploymentPlanBuilder;
import org.jboss.as.controller.client.helpers.standalone.ServerDeploymentActionResult;
import org.jboss.as.controller.client.helpers.standalone.ServerDeploymentManager;
import org.jboss.as.controller.client.helpers.standalone.ServerDeploymentPlanResult;
import org.jboss.as.controller.client.helpers.standalone.ServerUpdateActionResult;
import org.jboss.as.plugin.deployment.IgnoredPackageTypes;
import org.jboss.dmr.ModelNode;

abstract class AbstractDeployment
extends AbstractMojo {
    private static final String CHILD_TYPE = "child-type";
    private static final String FAILED = "failed";
    private static final String READ_CHILDREN_NAMES_OPERATION = "read-children-names";
    private static final String NO_NAME_MSG = "No name defined, using default deployment name.";
    private static final String NAME_DEFINED_MSG_FMT = "Using '%s' for the deployment name.";
    private volatile InetAddress address = null;
    private volatile ModelControllerClient client = null;
    private String name;
    private String hostname;
    private String packaging;
    private int port;
    private File targetDir;
    private String filename;
    private boolean force;

    AbstractDeployment() {
    }

    public final String name() {
        return this.name;
    }

    public final String hostname() {
        return this.hostname;
    }

    public final int port() {
        return this.port;
    }

    public final boolean force() {
        return this.force;
    }

    public final File targetDirectory() {
        return this.targetDir;
    }

    public final String filename() {
        return this.filename;
    }

    public final File file() {
        return new File(this.targetDir, this.filename);
    }

    public abstract DeploymentPlan createPlan(DeploymentPlanBuilder var1) throws IOException, MojoFailureException;

    public abstract String goal();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final InetAddress hostAddress() throws UnknownHostException {
        if (this.address == null) {
            AbstractDeployment abstractDeployment = this;
            synchronized (abstractDeployment) {
                if (this.address == null) {
                    this.address = InetAddress.getByName(this.hostname());
                }
            }
        }
        return this.address;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final ModelControllerClient client() throws UnknownHostException {
        if (this.client == null) {
            AbstractDeployment abstractDeployment = this;
            synchronized (abstractDeployment) {
                if (this.client == null) {
                    this.client = ModelControllerClient.Factory.create((InetAddress)this.hostAddress(), (int)this.port());
                }
            }
        }
        return this.client;
    }

    public final void execute() throws MojoExecutionException, MojoFailureException {
        try {
            if (IgnoredPackageTypes.isIgnored(this.packaging)) {
                this.getLog().debug((CharSequence)String.format("Ignoring packaging type %s.", this.packaging));
            } else {
                ServerDeploymentManager manager;
                InitialDeploymentPlanBuilder builder;
                DeploymentPlan plan;
                File file = new File(this.targetDirectory(), this.filename());
                InetAddress host = this.hostAddress();
                this.getLog().info((CharSequence)String.format("Executing goal %s for %s on server %s (%s) port %s.", this.goal(), file, host.getHostName(), host.getHostAddress(), this.port()));
                if (this.force()) {
                    this.getLog().debug((CharSequence)"force option is enabled");
                }
                if ((plan = this.createPlan((DeploymentPlanBuilder)(builder = (manager = ServerDeploymentManager.Factory.create((ModelControllerClient)this.client())).newDeploymentPlan()))).getDeploymentActions().size() > 0) {
                    ServerDeploymentPlanResult planResult = (ServerDeploymentPlanResult)manager.execute(plan).get();
                    for (DeploymentAction action : plan.getDeploymentActions()) {
                        ServerDeploymentActionResult actionResult = planResult.getDeploymentActionResult(action.getId());
                        ServerUpdateActionResult.Result result = actionResult.getResult();
                        switch (result) {
                            case FAILED: {
                                throw new MojoExecutionException("Deployment failed.", actionResult.getDeploymentException());
                            }
                            case NOT_EXECUTED: {
                                throw new MojoExecutionException("Deployment not executed.", actionResult.getDeploymentException());
                            }
                            case ROLLED_BACK: {
                                throw new MojoExecutionException("Deployment failed and was rolled back.", actionResult.getDeploymentException());
                            }
                            case CONFIGURATION_MODIFIED_REQUIRES_RESTART: {
                                this.getLog().warn((CharSequence)"Action was executed, but the server requires a restart.");
                                break;
                            }
                        }
                        this.getLog().debug((CharSequence)String.format("Deployment Plan Id : %s", planResult.getDeploymentPlanId()));
                    }
                } else {
                    this.getLog().warn((CharSequence)String.format("Goal %s failed on file %s. No deployment actions exist. Plan: %s", this.goal(), this.filename(), plan));
                }
            }
        }
        catch (Exception e) {
            throw new MojoExecutionException(String.format("Could not execute goal %s on %s. Reason: %s", this.goal(), this.filename(), e.getMessage()), e);
        }
    }

    protected final boolean deploymentExists() throws IOException {
        String deploymentName;
        ModelNode op = new ModelNode();
        op.get("operation").set(READ_CHILDREN_NAMES_OPERATION);
        op.get(CHILD_TYPE).set("deployment");
        ModelNode result = this.client().execute(op);
        String string = deploymentName = this.name() == null ? this.filename() : this.name();
        if (result.hasDefined("outcome")) {
            if (result.get("outcome").asString().equals("success")) {
                List deployments = result.hasDefined("result") ? result.get("result").asList() : Collections.emptyList();
                for (ModelNode n : deployments) {
                    if (!n.asString().equals(deploymentName)) continue;
                    return true;
                }
            } else if (result.get("outcome").asString().equals(FAILED)) {
                this.getLog().warn((CharSequence)String.format("A failure occurred when checking existing deployments. Error: %s", result.hasDefined("failure-description") ? result.get("failure-description").asString() : "Unknown"));
            }
        } else {
            this.getLog().warn((CharSequence)String.format("An unexpected response was found checking the deployment. Result: %s", result));
        }
        return false;
    }

    protected String nameNotDefinedMessage() {
        return NO_NAME_MSG;
    }

    protected String nameDefinedMessage() {
        return String.format(NAME_DEFINED_MSG_FMT, this.name());
    }
}

