/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.plugin.cli;

import java.io.IOException;
import java.util.Set;
import org.apache.maven.plugins.annotations.Parameter;
import org.jboss.as.cli.CliInitializationException;
import org.jboss.as.cli.CommandContext;
import org.jboss.as.cli.CommandContextFactory;
import org.jboss.as.cli.CommandFormatException;
import org.jboss.as.controller.client.ModelControllerClient;
import org.jboss.as.plugin.common.Operations;
import org.jboss.dmr.ModelNode;

public class Commands {
    @Parameter
    private boolean batch;
    @Parameter
    private Set<String> commands;

    public boolean isBatch() {
        return this.batch;
    }

    public boolean hasCommands() {
        return this.commands != null && !this.commands.isEmpty();
    }

    public Set<String> getCommands() {
        return this.commands;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void execute(ModelControllerClient client) throws IOException {
        block12: {
            if (this.hasCommands()) {
                CommandContext ctx = Commands.create();
                try {
                    if (this.isBatch()) {
                        Operations.CompositeOperationBuilder builder = Operations.CompositeOperationBuilder.create();
                        for (String cmd : this.getCommands()) {
                            try {
                                builder.addStep(ctx.buildRequest(cmd));
                            }
                            catch (CommandFormatException e) {
                                throw new IllegalArgumentException(String.format("Command '%s' is invalid", cmd), e);
                            }
                        }
                        ModelNode result = client.execute(builder.build());
                        if (!Operations.successful(result)) {
                            throw new IllegalArgumentException(Operations.getFailureDescription(result));
                        }
                        break block12;
                    }
                    for (String cmd : this.getCommands()) {
                        ModelNode result;
                        try {
                            result = client.execute(ctx.buildRequest(cmd));
                        }
                        catch (CommandFormatException e) {
                            throw new IllegalArgumentException(String.format("Command '%s' is invalid", cmd), e);
                        }
                        if (Operations.successful(result)) continue;
                        throw new IllegalArgumentException(String.format("Command '%s' was unsuccessful. Reason: %s", cmd, Operations.getFailureDescription(result)));
                    }
                }
                finally {
                    ctx.terminateSession();
                }
            }
        }
    }

    public static CommandContext create() {
        CommandContext commandContext;
        try {
            commandContext = CommandContextFactory.getInstance().newCommandContext();
        }
        catch (CliInitializationException e) {
            throw new IllegalStateException("Failed to initialize CLI context", e);
        }
        return commandContext;
    }
}

