/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.plugin.server;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.List;
import javax.security.auth.callback.CallbackHandler;
import org.jboss.as.controller.client.ModelControllerClient;
import org.jboss.as.plugin.common.Files;
import org.jboss.as.plugin.common.IoUtils;
import org.jboss.as.plugin.common.ServerOperations;
import org.jboss.as.plugin.server.Server;
import org.jboss.as.plugin.server.ServerConfig;
import org.jboss.dmr.ModelNode;

final class StandaloneServer
extends Server {
    private static final String STARTING = "starting";
    private static final String STOPPING = "stopping";
    private final ServerConfig serverConfig;
    private boolean isRunning;
    private ModelControllerClient client;

    public StandaloneServer(ServerConfig serverConfig) {
        super(serverConfig, "JBAS015950");
        this.serverConfig = serverConfig;
        this.isRunning = false;
    }

    @Override
    protected void init() throws IOException {
        this.client = ModelControllerClient.Factory.create((InetAddress)this.serverConfig.getConnectionInfo().getHostAddress(), (int)this.serverConfig.getConnectionInfo().getPort(), (CallbackHandler)this.serverConfig.getConnectionInfo().getCallbackHandler());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void stopServer() {
        block10: {
            try {
                if (this.client == null) break block10;
                try {
                    this.client.execute(ServerOperations.createOperation((String)"shutdown"));
                }
                catch (IOException e) {
                }
                finally {
                    IoUtils.safeClose((Closeable)this.client);
                    this.client = null;
                }
                try {
                    this.getConsole().awaitShutdown(5L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            finally {
                this.isRunning = false;
            }
        }
    }

    @Override
    public synchronized boolean isRunning() {
        if (this.isRunning) {
            return true;
        }
        this.checkServerState();
        return this.isRunning;
    }

    @Override
    public synchronized ModelControllerClient getClient() {
        return this.client;
    }

    @Override
    protected List<String> createLaunchCommand() {
        File jbossHome = this.serverConfig.getJbossHome();
        String javaHome = this.serverConfig.getJavaHome();
        File modulesJar = new File(Files.createPath(jbossHome.getAbsolutePath(), "jboss-modules.jar"));
        if (!modulesJar.exists()) {
            throw new IllegalStateException("Cannot find: " + modulesJar);
        }
        String javaExec = Files.createPath(javaHome, "bin", "java");
        if (javaHome.contains(" ")) {
            javaExec = "\"" + javaExec + "\"";
        }
        ArrayList<String> cmd = new ArrayList<String>();
        cmd.add(javaExec);
        cmd.addAll(this.serverConfig.getJvmArgs());
        cmd.add("-Djboss.home.dir=" + jbossHome);
        cmd.add("-Dorg.jboss.boot.log.file=" + Files.createPath(this.serverConfig.getLogDir(), "boot.log"));
        cmd.add("-Dlogging.configuration=file:" + Files.createPath(this.serverConfig.getConfigDir(), "logging.properties"));
        cmd.add("-Djboss.bundles.dir=" + this.serverConfig.getBundlesDir());
        cmd.add("-jar");
        cmd.add(modulesJar.getAbsolutePath());
        cmd.add("-mp");
        cmd.add(this.serverConfig.getModulesDir());
        cmd.add("-jaxpmodule");
        cmd.add("javax.xml.jaxp-provider");
        cmd.add("org.jboss.as.standalone");
        if (this.serverConfig.getServerConfig() != null) {
            cmd.add("-server-config");
            cmd.add(this.serverConfig.getServerConfig());
        }
        if (this.serverConfig.getPropertiesFile() != null) {
            cmd.add("-P");
            cmd.add(this.serverConfig.getPropertiesFile());
        }
        cmd.addAll(this.serverConfig.getServerArgs());
        return cmd;
    }

    @Override
    protected void checkServerState() {
        if (this.client == null) {
            this.isRunning = false;
        } else {
            try {
                ModelNode result = this.client.execute(ServerOperations.createReadAttributeOperation("server-state"));
                System.out.println(result.asString());
                this.isRunning = ServerOperations.isSuccessfulOutcome((ModelNode)result) && !STARTING.equalsIgnoreCase(ServerOperations.readResultAsString(result)) && !STOPPING.equalsIgnoreCase(ServerOperations.readResultAsString(result));
            }
            catch (Throwable ignore) {
                this.isRunning = false;
            }
        }
    }
}

