/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.byteman.contrib.bmunit;

import com.sun.tools.attach.AgentInitializationException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import org.jboss.byteman.agent.install.Install;
import org.jboss.byteman.agent.install.VMInfo;
import org.jboss.byteman.agent.submit.ScriptText;
import org.jboss.byteman.agent.submit.Submit;

public class BMUnit {
    public static final String LOAD_DIRECTORY = "org.jboss.byteman.contrib.bmunit.script.directory";
    public static final String AGENT_PORT = "org.jboss.byteman.contrib.bmunit.agent.port";
    public static final String AGENT_HOST = "org.jboss.byteman.contrib.bmunit.agent.host";
    public static final String AGENT_POLICY = "org.jboss.byteman.contrib.bmunit.agent.policy";
    public static final String AGENT_INHIBIT = "org.jboss.byteman.contrib.bmunit.agent.inhibit";
    public static final String VERBOSE = "org.jboss.byteman.contrib.bmunit.verbose";
    private static final boolean verbose = System.getProperty("org.jboss.byteman.contrib.bmunit.verbose") != null;
    private static String defaultLoadDirectory = BMUnit.initDefaultLoadDirectory();
    private static HashMap<String, String> fileTable = new HashMap();
    private static String host = BMUnit.initHost();
    private static int port = BMUnit.initPort();
    private static boolean policy = BMUnit.initPolicy();

    private static String initHost() {
        return System.getProperty(AGENT_HOST);
    }

    private static int initPort() {
        String portString = System.getProperty(AGENT_PORT);
        return portString == null ? 0 : Integer.valueOf(portString);
    }

    private static boolean initPolicy() {
        String policyString = System.getProperty(AGENT_PORT);
        return policyString == null ? false : Boolean.valueOf(policyString);
    }

    public static String getHost() {
        return host;
    }

    public static int getPort() {
        return port;
    }

    public static boolean getPolicy() {
        return policy;
    }

    private static String initDefaultLoadDirectory() {
        String dir = System.getProperty(LOAD_DIRECTORY);
        if (dir == null || dir.length() == 0) {
            dir = ".";
        }
        return dir;
    }

    private static synchronized void loadAgent() throws Exception {
        String[] properties = new String[]{};
        String id = null;
        int pid = BMUnit.getPid();
        if (pid > 0) {
            id = Integer.toString(pid);
        } else {
            String prop = "org.jboss.byteman.contrib.bmunit.agent.unique";
            String unique = Long.toHexString(System.currentTimeMillis());
            System.setProperty(prop, unique);
            VMInfo[] vmInfo = Install.availableVMs();
            for (int i = 0; i < vmInfo.length; ++i) {
                String nextId = vmInfo[i].getId();
                String value = Install.getSystemProperty((String)nextId, (String)prop);
                if (!unique.equals(value)) continue;
                id = nextId;
                break;
            }
            if (id == null) {
                throw new Exception("BMUnit : Unable to identify test JVM process during agent load");
            }
        }
        try {
            if (verbose) {
                System.out.println("BMUNit : loading agent id = " + id);
            }
            Install.install((String)id, (boolean)true, (boolean)BMUnit.getPolicy(), (String)BMUnit.getHost(), (int)BMUnit.getPort(), (String[])properties);
        }
        catch (AgentInitializationException agentInitializationException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int getPid() {
        File file = new File("/proc/self/stat");
        if (!file.exists() || !file.canRead()) {
            return 0;
        }
        FileInputStream fis = null;
        int pid = 0;
        try {
            char c;
            fis = new FileInputStream(file);
            byte[] bytes = new byte[10];
            StringBuilder builder = new StringBuilder();
            fis.read(bytes);
            for (int i = 0; i < 10 && Character.isDigit(c = (char)bytes[i]); ++i) {
                builder.append(c);
            }
            pid = Integer.valueOf(builder.toString());
        }
        catch (Exception e) {
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException e1) {}
            }
        }
        return pid;
    }

    public static void loadScriptFile(Class<?> clazz, String dir) throws Exception {
        BMUnit.loadScriptFile(clazz, null, dir);
    }

    public static void loadScriptFile(Class<?> clazz, String testName, String dir) throws Exception {
        String loadDirectory = dir;
        if (loadDirectory == null) {
            loadDirectory = defaultLoadDirectory;
        }
        String className = clazz.getName();
        if (testName == null) {
            testName = "";
        }
        String key = className + "#" + testName;
        int index = (className = className.replace('.', File.separatorChar)).lastIndexOf(File.separatorChar);
        String bareClassName = index < 0 ? null : className.substring(index + 1);
        String filename = null;
        File file = null;
        filename = BMUnit.findScript(loadDirectory, testName, className + "-" + testName, className, bareClassName);
        if (filename != null) {
            file = new File(filename);
        }
        if (file == null || !file.exists()) {
            throw new FileNotFoundException("Rule file not found for Byteman test case " + key);
        }
        if (!file.canRead()) {
            throw new IOException("Cannot read Byteman rule file " + filename);
        }
        Submit submit = new Submit(BMUnit.getHost(), BMUnit.getPort());
        ArrayList<String> files = new ArrayList<String>();
        files.add(filename);
        if (verbose) {
            System.out.println("BMUNit : loading file script = " + filename);
        }
        submit.addRulesFromFiles(files);
        fileTable.put(key, filename);
    }

    public static void unloadScriptFile(Class<?> clazz, String testName) throws Exception {
        String key;
        String filename;
        String className = clazz.getName();
        if (testName == null) {
            testName = "";
        }
        if ((filename = fileTable.remove(key = className + "#" + testName)) == null) {
            throw new FileNotFoundException("Rule file not found for Byteman test case " + key);
        }
        Submit submit = new Submit(BMUnit.getHost(), BMUnit.getPort());
        ArrayList<String> files = new ArrayList<String>();
        files.add(filename);
        if (verbose) {
            System.out.println("BMUNit : unloading file script = " + filename);
        }
        submit.deleteRulesFromFiles(files);
    }

    public static void loadScriptText(Class<?> clazz, String testname, String scriptText) throws Exception {
        String className = clazz.getName();
        if (testname == null) {
            testname = "";
        }
        String key = className + "+" + testname;
        fileTable.put(key, scriptText);
        Submit submit = new Submit(BMUnit.getHost(), BMUnit.getPort());
        if (verbose) {
            System.out.println("BMUNit : loading text script = " + key);
        }
        ArrayList<ScriptText> scripts = new ArrayList<ScriptText>();
        ScriptText script = new ScriptText(key, scriptText);
        scripts.add(script);
        submit.addScripts(scripts);
    }

    public static void unloadScriptText(Class<?> clazz, String testName) throws Exception {
        String key;
        String scriptText;
        String className = clazz.getName();
        if (testName == null) {
            testName = "";
        }
        if ((scriptText = fileTable.remove(key = className + "+" + testName)) == null) {
            throw new Exception("Rule script not found " + key);
        }
        Submit submit = new Submit(BMUnit.getHost(), BMUnit.getPort());
        if (verbose) {
            System.out.println("BMUNit : unloading text script = " + key);
        }
        ArrayList<ScriptText> scripts = new ArrayList<ScriptText>();
        ScriptText script = new ScriptText(key, scriptText);
        scripts.add(script);
        submit.deleteScripts(scripts);
    }

    protected static String findScript(String dir, String name) {
        String filename = name;
        String resourceName = name;
        if (filename == null) {
            return null;
        }
        if (dir != null && dir.length() > 0) {
            filename = dir + File.separator + filename;
            resourceName = dir + "/" + resourceName;
        }
        String[] filenames = new String[]{filename, filename + ".btm", filename + ".txt"};
        String[] resourceNames = new String[]{resourceName, resourceName + ".btm", resourceName + ".txt"};
        for (String fname : filenames) {
            File file = new File(fname);
            if (!file.exists() || !file.isFile()) continue;
            return fname;
        }
        for (String rname : resourceNames) {
            File file;
            URL resource;
            ClassLoader loader = Thread.currentThread().getContextClassLoader();
            if (loader == null) {
                loader = ClassLoader.getSystemClassLoader();
            }
            if ((resource = loader.getResource(rname)) == null || !(file = new File(resource.getFile())).exists() || !file.isFile()) continue;
            return resource.getFile();
        }
        return null;
    }

    protected static String findScript(String dir, String ... names) {
        for (String name : names) {
            String filename = BMUnit.findScript(dir, name);
            if (filename == null) continue;
            return filename;
        }
        return null;
    }

    static {
        if (System.getProperty(AGENT_INHIBIT) == null) {
            try {
                BMUnit.loadAgent();
            }
            catch (Exception e) {
                System.out.println(e);
            }
        }
    }
}

