/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.classloader.spi.base;

import java.io.IOException;
import java.net.URL;
import java.util.Set;
import org.jboss.classloader.spi.ClassLoaderPolicy;
import org.jboss.classloader.spi.ClassLoaderPolicyFactory;
import org.jboss.classloader.spi.Loader;
import org.jboss.classloader.spi.base.BaseClassLoader;
import org.jboss.classloader.spi.base.BaseClassLoaderPolicy;
import org.jboss.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BaseDelegateLoader
implements Loader {
    private static final Logger log = Logger.getLogger(BaseDelegateLoader.class);
    private volatile BaseClassLoaderPolicy delegate;
    private ClassLoaderPolicyFactory factory;

    public BaseDelegateLoader(BaseClassLoaderPolicy delegate) {
        if (delegate == null) {
            throw new IllegalArgumentException("Null delegate");
        }
        this.delegate = delegate;
    }

    public BaseDelegateLoader(ClassLoaderPolicyFactory factory) {
        if (factory == null) {
            throw new IllegalArgumentException("Null factory");
        }
        this.factory = factory;
    }

    BaseClassLoaderPolicy getPolicy() {
        BaseClassLoaderPolicy delegate = this.delegate;
        if (delegate == null) {
            try {
                delegate = this.factory.createClassLoaderPolicy();
                if (delegate == null) {
                    log.trace((Object)("Factory did not create a delegate: " + this.factory));
                } else {
                    ClassLoaderPolicy policy = (ClassLoaderPolicy)delegate;
                    this.initialise(policy);
                    this.delegate = delegate;
                }
            }
            catch (Throwable t) {
                log.warn((Object)("Unexpected error creating policy from factory: " + this.factory), t);
            }
        }
        return delegate;
    }

    protected void initialise(ClassLoaderPolicy policy) {
    }

    BaseClassLoader getBaseClassLoader(String context) {
        BaseClassLoader result = null;
        try {
            BaseClassLoaderPolicy policy = this.getPolicy();
            if (policy != null) {
                result = policy.getClassLoader();
            }
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        if (result == null) {
            log.warn((Object)("Not " + context + " from policy that has no classLoader: " + this.toLongString()));
        }
        return result;
    }

    @Override
    public Class<?> loadClass(String className) {
        BaseClassLoader classLoader = this.getBaseClassLoader("loading class " + className);
        if (classLoader != null) {
            return classLoader.loadClassLocally(className);
        }
        return null;
    }

    @Override
    public URL getResource(String name) {
        BaseClassLoader classLoader = this.getBaseClassLoader("getting resource " + name);
        if (classLoader != null) {
            return classLoader.getResourceLocally(name);
        }
        return null;
    }

    @Override
    public void getResources(String name, Set<URL> urls) throws IOException {
        BaseClassLoader classLoader = this.getBaseClassLoader("getting resources " + name);
        if (classLoader != null) {
            classLoader.getResourcesLocally(name, urls);
        }
    }

    @Override
    public Package getPackage(String name) {
        BaseClassLoader classLoader = this.getBaseClassLoader("getting package " + name);
        if (classLoader != null) {
            return classLoader.getPackageLocally(name);
        }
        return null;
    }

    @Override
    public void getPackages(Set<Package> packages) {
        BaseClassLoader classLoader;
        try {
            classLoader = this.delegate.getClassLoader();
        }
        catch (IllegalStateException e) {
            log.warn((Object)("Not getting packages from policy that has no classLoader: " + this.toLongString()));
            return;
        }
        classLoader.getPackagesLocally(packages);
    }

    public String toLongString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.getClass().getSimpleName());
        builder.append("@").append(Integer.toHexString(System.identityHashCode(this)));
        if (this.delegate != null) {
            builder.append("{delegate=").append(this.delegate.toLongString());
        } else {
            builder.append("{factory=").append(this.factory);
        }
        this.toLongString(builder);
        builder.append('}');
        return builder.toString();
    }

    protected void toLongString(StringBuilder builder) {
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.getClass().getSimpleName());
        builder.append("@").append(Integer.toHexString(System.identityHashCode(this)));
        if (this.delegate != null) {
            builder.append("{delegate=").append(this.delegate);
        } else {
            builder.append("{factory=").append(this.factory);
        }
        builder.append('}');
        return builder.toString();
    }
}

