/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.classloader.test.support;

import java.security.AccessController;
import java.security.PrivilegedAction;
import org.jboss.classloader.plugins.system.DefaultClassLoaderSystem;
import org.jboss.classloader.spi.ClassLoaderDomain;
import org.jboss.classloader.spi.ClassLoaderPolicy;
import org.jboss.classloader.spi.ClassLoaderSystem;
import org.jboss.classloader.spi.Loader;
import org.jboss.classloader.spi.ParentPolicy;
import org.jboss.classloader.test.support.MockClassLoaderPolicy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MockClassLoaderHelper {
    public static ClassLoaderSystem createMockClassLoaderSystem() {
        return new DefaultClassLoaderSystem();
    }

    public static MockClassLoaderPolicy createMockClassLoaderPolicy(final String name) {
        return AccessController.doPrivileged(new PrivilegedAction<MockClassLoaderPolicy>(){

            @Override
            public MockClassLoaderPolicy run() {
                return new MockClassLoaderPolicy(name);
            }
        });
    }

    public static ClassLoader createAndRegisterMockClassLoader(final ClassLoaderSystem system, final ClassLoaderDomain domain, final String name) {
        return AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

            @Override
            public ClassLoader run() {
                MockClassLoaderPolicy policy = new MockClassLoaderPolicy(name);
                if (domain == null) {
                    return system.registerClassLoaderPolicy(policy);
                }
                return system.registerClassLoaderPolicy(domain, (ClassLoaderPolicy)policy);
            }
        });
    }

    public static ClassLoader createAndRegisterMockClassLoader(final ClassLoaderSystem system, final String domainName, final String name) {
        return AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

            @Override
            public ClassLoader run() {
                MockClassLoaderPolicy policy = new MockClassLoaderPolicy(name);
                return system.registerClassLoaderPolicy(domainName, (ClassLoaderPolicy)policy);
            }
        });
    }

    public static ClassLoader createAndRegisterMockClassLoader(final ClassLoaderSystem system, final String domainName, final ParentPolicy parentPolicy, final String name) {
        return AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

            @Override
            public ClassLoader run() {
                MockClassLoaderPolicy policy = new MockClassLoaderPolicy(name);
                return system.registerClassLoaderPolicy(domainName, parentPolicy, policy);
            }
        });
    }

    public static ClassLoader createAndRegisterMockClassLoader(final ClassLoaderSystem system, final String domainName, final ParentPolicy parentPolicy, final String parentDomainName, final String name) {
        return AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

            @Override
            public ClassLoader run() {
                MockClassLoaderPolicy policy = new MockClassLoaderPolicy(name);
                return system.registerClassLoaderPolicy(domainName, parentPolicy, parentDomainName, (ClassLoaderPolicy)policy);
            }
        });
    }

    public static ClassLoader createAndRegisterMockClassLoader(final ClassLoaderSystem system, final String domainName, final ParentPolicy parentPolicy, final Loader parent, final String name) {
        return AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

            @Override
            public ClassLoader run() {
                MockClassLoaderPolicy policy = new MockClassLoaderPolicy(name);
                return system.registerClassLoaderPolicy(domainName, parentPolicy, parent, (ClassLoaderPolicy)policy);
            }
        });
    }

    public static ClassLoader registerMockClassLoader(final ClassLoaderSystem system, final ClassLoaderDomain domain, final MockClassLoaderPolicy policy) {
        return AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

            @Override
            public ClassLoader run() {
                if (domain == null) {
                    return system.registerClassLoaderPolicy(policy);
                }
                return system.registerClassLoaderPolicy(domain, (ClassLoaderPolicy)policy);
            }
        });
    }

    public static boolean isExpectedClassLoader(final Class<?> clazz, ClassLoader expected) {
        ClassLoader classLoader = AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

            @Override
            public ClassLoader run() {
                return clazz.getClassLoader();
            }
        });
        if (classLoader == null) {
            return expected == null;
        }
        return classLoader.equals(expected);
    }
}

