/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.classloader.spi;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.ProtectionDomain;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.jboss.classloader.spi.ClassFoundEvent;
import org.jboss.classloader.spi.ClassFoundHandler;
import org.jboss.classloader.spi.ClassLoaderDomain;
import org.jboss.classloader.spi.ClassNotFoundEvent;
import org.jboss.classloader.spi.ClassNotFoundHandler;
import org.jboss.classloader.spi.DelegateLoader;
import org.jboss.classloader.spi.NativeLibraryProvider;
import org.jboss.classloader.spi.PackageInformation;
import org.jboss.classloader.spi.ShutdownPolicy;
import org.jboss.classloader.spi.base.BaseClassLoaderPolicy;
import org.jboss.classloader.spi.filter.ClassFilter;
import org.jboss.classloader.spi.filter.FilteredDelegateLoader;
import org.jboss.classloader.spi.filter.PackageClassFilter;
import org.jboss.classloader.spi.jdk.JDKChecker;
import org.jboss.classloader.spi.jdk.JDKCheckerFactory;
import org.jboss.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ClassLoaderPolicy
extends BaseClassLoaderPolicy
implements ClassNotFoundHandler,
ClassFoundHandler {
    private static final Logger log = Logger.getLogger(ClassLoaderPolicy.class);
    private ShutdownPolicy shutdownPolicy;
    private List<ClassNotFoundHandler> classNotFoundHandlers;
    private List<ClassFoundHandler> classFoundHandlers;
    private volatile List<NativeLibraryProvider> nativeLibraries;

    public void addNativeLibrary(NativeLibraryProvider provider) {
        if (this.nativeLibraries == null) {
            this.nativeLibraries = new CopyOnWriteArrayList<NativeLibraryProvider>();
        }
        this.nativeLibraries.add(provider);
    }

    public String findLibrary(String libname) {
        File libfile;
        List<NativeLibraryProvider> list = this.nativeLibraries;
        if (list == null) {
            return null;
        }
        NativeLibraryProvider libProvider = null;
        for (NativeLibraryProvider aux : list) {
            if (!libname.equals(aux.getLibraryName())) continue;
            libProvider = aux;
            break;
        }
        if (libProvider == null) {
            return null;
        }
        try {
            libfile = libProvider.getLibraryLocation();
        }
        catch (IOException ex) {
            log.error((Object)("Cannot privide native library location for: " + libname), (Throwable)ex);
            return null;
        }
        return libfile.getAbsolutePath();
    }

    @Override
    public DelegateLoader getExported() {
        String[] packageNames = this.getPackageNames();
        if (packageNames == null) {
            return null;
        }
        return new FilteredDelegateLoader(this, (ClassFilter)PackageClassFilter.createPackageClassFilter(packageNames));
    }

    @Override
    public String[] getPackageNames() {
        return null;
    }

    @Override
    protected List<? extends DelegateLoader> getDelegates() {
        return Collections.emptyList();
    }

    @Override
    protected boolean isImportAll() {
        return false;
    }

    @Override
    protected boolean isCacheable() {
        return true;
    }

    @Override
    protected boolean isBlackListable() {
        return true;
    }

    public abstract URL getResource(String var1);

    public InputStream getResourceAsStream(String path) {
        URL url = this.getResource(path);
        if (url != null) {
            try {
                return url.openStream();
            }
            catch (IOException e) {
                log.debug((Object)("Unable to open URL: " + url + " for path " + path + " from " + this.toLongString()));
            }
        }
        return null;
    }

    public abstract void getResources(String var1, Set<URL> var2) throws IOException;

    @Override
    public ShutdownPolicy getShutdownPolicy() {
        return this.shutdownPolicy;
    }

    public void setShutdownPolicy(ShutdownPolicy shutdownPolicy) {
        this.shutdownPolicy = shutdownPolicy;
    }

    @Override
    protected ProtectionDomain getProtectionDomain(String className, String path) {
        return null;
    }

    public PackageInformation getPackageInformation(String packageName) {
        return null;
    }

    public PackageInformation getClassPackageInformation(String className, String packageName) {
        return this.getPackageInformation(packageName);
    }

    @Override
    protected ClassLoader isJDKRequest(String name) {
        JDKChecker checker = JDKCheckerFactory.getChecker();
        if (checker.isJDKRequest(name)) {
            return this.getSystemClassLoader();
        }
        return null;
    }

    public void addClassNotFoundHandler(ClassNotFoundHandler handler) {
        if (handler == null) {
            throw new IllegalArgumentException("Null handler");
        }
        if (this.classNotFoundHandlers == null) {
            this.classNotFoundHandlers = new CopyOnWriteArrayList<ClassNotFoundHandler>();
        }
        this.classNotFoundHandlers.add(handler);
    }

    public void removeClassNotFoundHandler(ClassNotFoundHandler handler) {
        if (handler == null) {
            throw new IllegalArgumentException("Null handler");
        }
        if (this.classNotFoundHandlers == null) {
            return;
        }
        this.classNotFoundHandlers.remove(handler);
    }

    @Override
    public boolean classNotFound(ClassNotFoundEvent event) {
        ClassLoaderDomain domain;
        if (this.classNotFoundHandlers != null && !this.classNotFoundHandlers.isEmpty()) {
            for (ClassNotFoundHandler handler : this.classNotFoundHandlers) {
                try {
                    if (!handler.classNotFound(event)) continue;
                    return true;
                }
                catch (Throwable t) {
                    log.warn((Object)("Error invoking classNotFoundHandler: " + handler), t);
                }
            }
        }
        return (domain = this.getDomain()) != null && domain.classNotFound(event);
    }

    public void addClassFoundHandler(ClassFoundHandler handler) {
        if (handler == null) {
            throw new IllegalArgumentException("Null handler");
        }
        if (this.classFoundHandlers == null) {
            this.classFoundHandlers = new CopyOnWriteArrayList<ClassFoundHandler>();
        }
        this.classFoundHandlers.add(handler);
    }

    public void removeClassFoundHandler(ClassFoundHandler handler) {
        if (handler == null) {
            throw new IllegalArgumentException("Null handler");
        }
        if (this.classFoundHandlers == null) {
            return;
        }
        this.classFoundHandlers.remove(handler);
    }

    @Override
    public void classFound(ClassFoundEvent event) {
        ClassLoaderDomain domain;
        if (this.classFoundHandlers != null && !this.classFoundHandlers.isEmpty()) {
            for (ClassFoundHandler handler : this.classFoundHandlers) {
                try {
                    handler.classFound(event);
                }
                catch (Throwable t) {
                    log.warn((Object)("Error invoking classFoundHandler: " + handler), t);
                }
            }
        }
        if ((domain = this.getDomain()) != null) {
            domain.classFound(event);
        }
    }

    @Override
    public ObjectName getObjectName() {
        try {
            String name = this.getName();
            if (name != null && name.trim().length() > 0) {
                return ObjectName.getInstance("jboss.classloader", "id", "\"" + name + "\"");
            }
            return ObjectName.getInstance("jboss.classloader", "id", "" + System.identityHashCode(this));
        }
        catch (MalformedObjectNameException e) {
            throw new Error("Error creating object name", e);
        }
    }

    @Override
    protected void toLongString(StringBuilder builder) {
        boolean importAll;
        builder.append(" delegates=").append(this.getDelegates());
        String[] packageNames = this.getPackageNames();
        if (packageNames != null) {
            builder.append(" exported=").append(Arrays.asList(packageNames));
        }
        if (importAll = this.isImportAll()) {
            builder.append(" <IMPORT-ALL>");
        }
    }

    private ClassLoader getSystemClassLoader() {
        SecurityManager sm = System.getSecurityManager();
        if (sm == null) {
            return ClassLoader.getSystemClassLoader();
        }
        return AccessController.doPrivileged(GetSystemClassLoader.INSTANCE, this.getAccessControlContext());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class GetSystemClassLoader
    implements PrivilegedAction<ClassLoader> {
        private static GetSystemClassLoader INSTANCE = new GetSystemClassLoader();

        private GetSystemClassLoader() {
        }

        @Override
        public ClassLoader run() {
            return ClassLoader.getSystemClassLoader();
        }
    }
}

