/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.classloader.spi.base;

import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Formattable;
import java.util.Formatter;
import java.util.List;
import javax.management.ObjectName;
import org.jboss.classloader.spi.ClassLoaderDomain;
import org.jboss.classloader.spi.DelegateLoader;
import org.jboss.classloader.spi.ShutdownPolicy;
import org.jboss.classloader.spi.base.BaseClassLoader;
import org.jboss.classloader.spi.base.BaseClassLoaderDomain;
import org.jboss.classloader.spi.base.ClassLoaderInformation;
import org.jboss.classloader.spi.base.ClassLoadingTask;
import org.jboss.classloader.spi.translator.TranslatorUtils;
import org.jboss.logging.Logger;
import org.jboss.util.loading.Translator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BaseClassLoaderPolicy
implements Formattable {
    private static final Logger log = Logger.getLogger(BaseClassLoaderPolicy.class);
    private volatile BaseClassLoader classLoader;
    private volatile BaseClassLoaderDomain domain;
    private volatile ClassLoaderInformation information;
    private AccessControlContext access;
    private List<Translator> translators;

    public BaseClassLoaderPolicy() {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkCreateClassLoader();
        }
        this.access = AccessController.getContext();
    }

    ClassLoaderInformation getInformation() {
        return this.information;
    }

    void setInformation(ClassLoaderInformation information) {
        this.information = information;
    }

    protected AccessControlContext getAccessControlContext() {
        return this.access;
    }

    protected abstract DelegateLoader getExported();

    protected String getName() {
        return "";
    }

    public abstract String[] getPackageNames();

    protected abstract List<? extends DelegateLoader> getDelegates();

    protected abstract boolean isImportAll();

    protected abstract ProtectionDomain getProtectionDomain(String var1, String var2);

    protected byte[] transform(String className, byte[] byteCode, ProtectionDomain protectionDomain) throws Exception {
        BaseClassLoader classLoader;
        byte[] result = byteCode;
        BaseClassLoaderDomain domain = this.getClassLoaderDomain();
        if (domain != null) {
            result = domain.transform(this.getClassLoader(), className, result, protectionDomain);
        }
        if ((classLoader = this.getClassLoaderUnchecked()) != null) {
            result = TranslatorUtils.applyTranslatorsOnTransform(this.getTranslators(), classLoader, className, result, protectionDomain);
        }
        return result;
    }

    protected abstract boolean isCacheable();

    protected abstract boolean isBlackListable();

    public abstract ObjectName getObjectName();

    protected abstract ClassLoader isJDKRequest(String var1);

    protected abstract ShutdownPolicy getShutdownPolicy();

    ShutdownPolicy determineShutdownPolicy() {
        BaseClassLoaderDomain domain = this.getClassLoaderDomain();
        if (domain == null) {
            ShutdownPolicy result = this.getShutdownPolicy();
            return result != null ? result : ShutdownPolicy.UNREGISTER;
        }
        return domain.determineShutdownPolicy(this);
    }

    public String toLongString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.getClass().getSimpleName());
        builder.append("@").append(Integer.toHexString(System.identityHashCode(this)));
        builder.append("{");
        String name = this.getName();
        if (name != null) {
            builder.append("name=").append(name).append(" ");
        }
        builder.append("domain=");
        if (this.domain == null) {
            builder.append("null");
        } else {
            builder.append(this.domain.toLongString());
        }
        this.toLongString(builder);
        builder.append('}');
        return builder.toString();
    }

    protected void toLongString(StringBuilder builder) {
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.getClass().getSimpleName());
        builder.append("@").append(Integer.toHexString(System.identityHashCode(this)));
        builder.append("{").append(this.getName()).append("}");
        return builder.toString();
    }

    @Override
    public void formatTo(Formatter formatter, int flags, int width, int precision) {
        formatter.format(this.toLongString(), new Object[0]);
    }

    public String getDomainName() {
        if (this.domain == null) {
            return null;
        }
        return ((ClassLoaderDomain)this.domain).getName();
    }

    protected ClassLoaderDomain getDomain() {
        return (ClassLoaderDomain)this.getClassLoaderDomain();
    }

    BaseClassLoaderDomain getClassLoaderDomain() {
        return this.domain;
    }

    void setClassLoaderDomain(BaseClassLoaderDomain domain) {
        if (this.domain != null) {
            throw new IllegalStateException("Policy already has a domain " + this);
        }
        this.domain = domain;
    }

    void unsetClassLoaderDomain(BaseClassLoaderDomain domain) {
        if (this.domain != domain) {
            throw new IllegalStateException("Policy is not a part of the domain " + this + " domain=" + domain);
        }
        this.shutdownPolicy();
        this.domain = null;
    }

    protected synchronized BaseClassLoader getClassLoader(ClassLoadingTask task) {
        return this.getClassLoader();
    }

    synchronized BaseClassLoader getClassLoader() {
        if (this.classLoader == null) {
            throw new IllegalStateException("No classloader associated with policy therefore it is no longer registered " + this.toLongString());
        }
        return this.classLoader;
    }

    synchronized BaseClassLoader getClassLoaderUnchecked() {
        return this.classLoader;
    }

    synchronized void setClassLoader(BaseClassLoader classLoader) {
        if (this.classLoader != null) {
            throw new IllegalStateException("Policy already has a classloader previous=" + classLoader);
        }
        this.classLoader = classLoader;
    }

    protected synchronized void shutdownPolicy() {
        log.debug((Object)(this.toString() + " shutdown!"));
        BaseClassLoader classLoader = this.classLoader;
        this.classLoader = null;
        TranslatorUtils.applyTranslatorsAtUnregister(this.translators, classLoader);
        classLoader.shutdownClassLoader();
    }

    protected void clearBlackList(String name) {
        if (this.domain != null) {
            this.domain.clearBlackList(name);
        }
    }

    public synchronized List<Translator> getTranslators() {
        if (this.translators == null || this.translators.isEmpty()) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(this.translators);
    }

    public synchronized void setTranslators(List<Translator> translators) {
        this.translators = translators;
    }

    public synchronized void addTranslator(Translator translator) {
        if (translator == null) {
            throw new IllegalArgumentException("Null translator");
        }
        if (this.translators == null) {
            this.translators = new ArrayList<Translator>();
        }
        this.translators.add(translator);
    }

    public synchronized void removeTranslator(Translator translator) {
        if (translator == null) {
            throw new IllegalArgumentException("Null translator");
        }
        if (this.translators != null) {
            this.translators.remove(translator);
        }
    }
}

