/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.deployers.spi.deployer.helpers;

import java.util.HashSet;
import java.util.Set;
import org.jboss.deployers.spi.attachments.LocalAttachments;
import org.jboss.deployers.spi.deployer.Deployer;
import org.jboss.deployers.spi.deployer.DeploymentStage;
import org.jboss.deployers.spi.deployer.DeploymentStages;
import org.jboss.deployers.structure.spi.DeploymentUnit;
import org.jboss.deployers.structure.spi.DeploymentUnitExt;
import org.jboss.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractDeployer
implements Deployer {
    protected Logger log = Logger.getLogger(this.getClass());
    private int relativeOrder = Integer.MAX_VALUE;
    private DeploymentStage stage = DeploymentStages.REAL;
    private boolean topLevelOnly;
    private boolean componentsOnly;
    private boolean wantComponents;
    private boolean allInputs;
    private Class<?> input;
    private Class<?> output;
    private Set<String> inputs;
    private Set<String> requiredInputs;
    private Set<String> outputs;
    private boolean parentFirst = true;
    private boolean forceHierarchyLookup;

    public int getRelativeOrder() {
        return this.relativeOrder;
    }

    public void setRelativeOrder(int relativeOrder) {
        this.relativeOrder = relativeOrder;
    }

    @Override
    public DeploymentStage getStage() {
        return this.stage;
    }

    public void setStage(DeploymentStage stage) {
        if (stage == null) {
            throw new IllegalArgumentException("Null stage");
        }
        this.stage = stage;
    }

    @Override
    public boolean isAllInputs() {
        return this.allInputs;
    }

    public void setAllInputs(boolean allInputs) {
        this.allInputs = allInputs;
    }

    @Override
    public boolean isComponentsOnly() {
        return this.componentsOnly;
    }

    public void setComponentsOnly(boolean componentsOnly) {
        this.componentsOnly = componentsOnly;
        this.setWantComponents(true);
    }

    @Override
    public boolean isWantComponents() {
        return this.wantComponents;
    }

    public void setWantComponents(boolean wantComponents) {
        this.wantComponents = wantComponents;
    }

    @Override
    public boolean isTopLevelOnly() {
        return this.topLevelOnly;
    }

    public void setTopLevelOnly(boolean topLevelOnly) {
        this.topLevelOnly = topLevelOnly;
    }

    @Override
    public Class<?> getInput() {
        return this.input;
    }

    public void setInput(Class<?> input) {
        this.addInput(input);
        this.input = input;
    }

    @Override
    public Class<?> getOutput() {
        return this.output;
    }

    public void setOutput(Class<?> output) {
        this.addOutput(output);
        this.output = output;
    }

    @Override
    public Set<String> getInputs() {
        return this.inputs;
    }

    public void setInputs(Set<String> inputs) {
        this.inputs = inputs;
    }

    @Override
    public Set<String> getRequiredInputs() {
        return this.requiredInputs;
    }

    public void setRequiredInputs(Set<String> requiredInputs) {
        if (requiredInputs != null) {
            for (String requiredInput : requiredInputs) {
                this.addRequiredInput(requiredInput);
            }
        } else {
            this.requiredInputs = null;
        }
    }

    public void setInputs(String ... inputs) {
        if (inputs == null) {
            this.setInputs((Set<String>)null);
            return;
        }
        HashSet<String> temp = new HashSet<String>(inputs.length);
        for (String input : inputs) {
            if (input == null) {
                throw new IllegalArgumentException("Null input");
            }
            temp.add(input);
        }
        this.setInputs(temp);
    }

    public void setInputs(Class<?> ... inputs) {
        if (inputs == null) {
            this.setInputs((Set<String>)null);
            return;
        }
        HashSet<String> temp = new HashSet<String>(inputs.length);
        for (Class<?> input : inputs) {
            if (input == null) {
                throw new IllegalArgumentException("Null input");
            }
            temp.add(input.getName());
        }
        this.setInputs(temp);
    }

    public void addInput(String input) {
        if (input == null) {
            throw new IllegalArgumentException("Null input");
        }
        if (this.inputs == null) {
            this.inputs = new HashSet<String>();
        }
        this.inputs.add(input);
    }

    public void addInput(Class<?> input) {
        if (input == null) {
            throw new IllegalArgumentException("Null input");
        }
        this.addInput(input.getName());
    }

    public void addRequiredInput(String requiredInput) {
        this.addInput(requiredInput);
        if (this.requiredInputs == null) {
            this.requiredInputs = new HashSet<String>();
        }
        this.requiredInputs.add(requiredInput);
    }

    public void addRequiredInput(Class<?> requiredInput) {
        if (requiredInput == null) {
            throw new IllegalArgumentException("Null required input");
        }
        this.addRequiredInput(requiredInput.getName());
    }

    @Override
    public Set<String> getOutputs() {
        return this.outputs;
    }

    public void setOutputs(Set<String> outputs) {
        this.outputs = outputs;
    }

    public void setOutputs(String ... outputs) {
        if (outputs == null) {
            this.setOutputs((Set<String>)null);
            return;
        }
        HashSet<String> temp = new HashSet<String>(outputs.length);
        for (String output : outputs) {
            if (output == null) {
                throw new IllegalArgumentException("Null output");
            }
            temp.add(output);
        }
        this.setOutputs(temp);
    }

    public void setOutputs(Class<?> ... outputs) {
        if (outputs == null) {
            this.setOutputs((Set<String>)null);
            return;
        }
        HashSet<String> temp = new HashSet<String>(outputs.length);
        for (Class<?> output : outputs) {
            if (output == null) {
                throw new IllegalArgumentException("Null output");
            }
            temp.add(output.getName());
        }
        this.setOutputs(temp);
    }

    public void addOutput(String output) {
        if (output == null) {
            throw new IllegalArgumentException("Null output");
        }
        if (this.outputs == null) {
            this.outputs = new HashSet<String>();
        }
        this.outputs.add(output);
    }

    public void addOutput(Class<?> output) {
        if (output == null) {
            throw new IllegalArgumentException("Null output");
        }
        this.addOutput(output.getName());
    }

    @Override
    public boolean isParentFirst() {
        return this.parentFirst;
    }

    public void setParentFirst(boolean parentFirst) {
        this.parentFirst = parentFirst;
    }

    public void setForceHierarchyLookup(boolean forceHierarchyLookup) {
        this.forceHierarchyLookup = forceHierarchyLookup;
    }

    @Override
    public void undeploy(DeploymentUnit unit) {
    }

    protected static void changeRelativeOrder(DeploymentUnit unit, int relativeOrder) {
        if (unit instanceof DeploymentUnitExt) {
            DeploymentUnitExt ext = (DeploymentUnitExt)unit;
            ext.changeRelativeOrder(relativeOrder);
        }
    }

    protected <T> T getAttachment(DeploymentUnit unit, Class<T> type) {
        if (!this.forceHierarchyLookup && this.isComponentsOnly() && unit instanceof LocalAttachments) {
            LocalAttachments la = (LocalAttachments)unit;
            return (T)la.getLocalAttachment(type);
        }
        return (T)unit.getAttachment(type);
    }
}

