/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.deployers.vfs.spi.structure.modified;

import java.io.IOException;
import java.net.URISyntaxException;
import java.util.Collection;
import org.jboss.deployers.client.spi.Deployment;
import org.jboss.deployers.structure.spi.DeploymentContext;
import org.jboss.deployers.structure.spi.main.MainDeployerInternals;
import org.jboss.deployers.vfs.spi.client.VFSDeployment;
import org.jboss.deployers.vfs.spi.structure.VFSDeploymentContext;
import org.jboss.deployers.vfs.spi.structure.modified.DefaultStructureCache;
import org.jboss.deployers.vfs.spi.structure.modified.ModificationCheckerFilter;
import org.jboss.deployers.vfs.spi.structure.modified.StructureCache;
import org.jboss.deployers.vfs.spi.structure.modified.StructureModificationChecker;
import org.jboss.logging.Logger;
import org.jboss.vfs.VirtualFile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractStructureModificationChecker<T>
implements StructureModificationChecker {
    protected Logger log = Logger.getLogger(this.getClass());
    private MainDeployerInternals mainDeployer;
    private ModificationCheckerFilter rootFilter;
    private volatile StructureCache<T> cache;
    private boolean checkMissingDeployments = true;

    protected AbstractStructureModificationChecker() {
    }

    protected AbstractStructureModificationChecker(MainDeployerInternals mainDeployer) {
        if (mainDeployer == null) {
            throw new IllegalArgumentException("Null main deployer");
        }
        this.mainDeployer = mainDeployer;
    }

    protected ModificationCheckerFilter getRootFilter() {
        if (this.rootFilter == null) {
            this.rootFilter = new DefaultRootFilter();
        }
        return this.rootFilter;
    }

    public void setRootFilter(ModificationCheckerFilter rootFilter) {
        if (rootFilter == null) {
            throw new IllegalArgumentException("Null root filter");
        }
        this.rootFilter = rootFilter;
    }

    protected StructureCache<T> getCache() {
        if (this.cache == null) {
            this.cache = new DefaultStructureCache();
        }
        return this.cache;
    }

    public void setCache(StructureCache<T> cache) {
        this.cache = cache;
    }

    protected MainDeployerInternals getMainDeployerInternals() {
        if (this.mainDeployer == null) {
            throw new IllegalArgumentException("Null main deployer structure");
        }
        return this.mainDeployer;
    }

    protected VFSDeploymentContext getDeploymentContext(String name) {
        DeploymentContext deploymentContext = this.getMainDeployerInternals().getDeploymentContext(name);
        if (deploymentContext == null || !(deploymentContext instanceof VFSDeploymentContext)) {
            return null;
        }
        return (VFSDeploymentContext)deploymentContext;
    }

    @Override
    public boolean hasStructureBeenModified(String name, VirtualFile root) throws IOException {
        return this.hasStructureBeenModified(root, this.getDeploymentContext(name));
    }

    @Override
    public boolean hasStructureBeenModified(VirtualFile root) throws IOException {
        VFSDeploymentContext deploymentContext = null;
        try {
            String name = root.toURI().toString();
            deploymentContext = this.getDeploymentContext(name);
        }
        catch (URISyntaxException uRISyntaxException) {
            // empty catch block
        }
        if (deploymentContext == null) {
            this.log.trace((Object)("Falling back to root name: " + root));
            deploymentContext = this.getDeploymentContext(root.getName());
        }
        return this.hasStructureBeenModified(root, deploymentContext);
    }

    protected boolean hasStructureBeenModified(VirtualFile root, VFSDeploymentContext deploymentContext) throws IOException {
        boolean result;
        if (root == null) {
            throw new IllegalArgumentException("Null root");
        }
        if (deploymentContext == null && !this.checkMissingDeployments) {
            return false;
        }
        if (this.getRootFilter().accepts(root) && ((result = this.hasRootBeenModified(root)) || this.getRootFilter().checkRootOnly(root))) {
            if (result) {
                this.getCache().invalidateCache(root);
            }
            return result;
        }
        if (deploymentContext == null && this.checkMissingDeployments) {
            Collection missing = this.getMainDeployerInternals().getMissingDeployer();
            if (missing != null && !missing.isEmpty()) {
                for (Deployment deployment : missing) {
                    VFSDeployment vfsd;
                    VirtualFile deploymentRoot;
                    if (!(deployment instanceof VFSDeployment) || !root.equals(deploymentRoot = (vfsd = (VFSDeployment)deployment).getRoot())) continue;
                    boolean modified = this.hasRootBeenModified(root);
                    if (modified) {
                        this.getCache().invalidateCache(root);
                    }
                    return modified;
                }
            }
            return false;
        }
        result = this.hasDeploymentContextBeenModified(root, deploymentContext);
        if (result) {
            this.getCache().invalidateCache(root);
        }
        return result;
    }

    protected abstract boolean hasRootBeenModified(VirtualFile var1) throws IOException;

    protected abstract boolean hasDeploymentContextBeenModified(VirtualFile var1, VFSDeploymentContext var2) throws IOException;

    @Override
    public void addStructureRoot(VirtualFile root) {
        if (root == null) {
            throw new IllegalArgumentException("Null root");
        }
        this.getCache().initializeCache(root);
    }

    @Override
    public void removeStructureRoot(VirtualFile root) {
        if (root == null) {
            throw new IllegalArgumentException("Null root");
        }
        this.getCache().removeCache(root);
    }

    public void setCheckMissingDeployments(boolean checkMissingDeployments) {
        this.checkMissingDeployments = checkMissingDeployments;
    }

    private static class DefaultRootFilter
    implements ModificationCheckerFilter {
        private DefaultRootFilter() {
        }

        public boolean accepts(VirtualFile file) {
            return !file.isDirectory();
        }

        public boolean checkRootOnly(VirtualFile root) {
            return true;
        }
    }
}

