/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.arquillian;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.TreeSet;
import java.util.regex.Pattern;
import org.jboss.arquillian.container.test.spi.TestDeployment;
import org.jboss.arquillian.container.test.spi.client.deployment.DeploymentPackager;
import org.jboss.arquillian.container.test.spi.client.deployment.ProtocolArchiveProcessor;
import org.jboss.forge.arquillian.archive.ForgeArchive;
import org.jboss.forge.arquillian.archive.ForgeRemoteAddon;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ArchivePath;
import org.jboss.shrinkwrap.api.Filter;

public class ForgeDeploymentPackager
implements DeploymentPackager {
    private Pattern SHRINKWRAP_DESCRIPTOR_PATTERN = Pattern.compile("/org/jboss/shrinkwrap/descriptor/.*");

    public Archive<?> generateDeployment(TestDeployment testDeployment, Collection<ProtocolArchiveProcessor> processors) {
        Archive applicationArchive = testDeployment.getApplicationArchive();
        if (applicationArchive instanceof ForgeArchive) {
            ForgeArchive deployment = (ForgeArchive)ForgeArchive.class.cast(applicationArchive);
            Collection auxiliaryArchives = testDeployment.getAuxiliaryArchives();
            for (Archive archive : auxiliaryArchives) {
                Map content = archive.getContent((Filter)new Filter<ArchivePath>(){

                    public boolean include(ArchivePath path) {
                        return ForgeDeploymentPackager.this.SHRINKWRAP_DESCRIPTOR_PATTERN.matcher(path.get()).matches();
                    }
                });
                TreeSet toRemove = new TreeSet(Collections.reverseOrder());
                toRemove.addAll(content.keySet());
                for (ArchivePath path : toRemove) {
                    archive.delete(path);
                }
                deployment.addAsLibrary(archive);
            }
            deployment.addClasses(new Class[]{ForgeArchive.class});
            return deployment;
        }
        if (applicationArchive instanceof ForgeRemoteAddon) {
            return applicationArchive;
        }
        throw new IllegalArgumentException("Invalid Archive type. Ensure that your @Deployment method returns type 'ForgeArchive'.");
    }
}

