/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.arquillian;

import java.io.File;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.maven.model.Model;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.graph.Dependency;
import org.jboss.arquillian.container.spi.client.deployment.DeploymentDescription;
import org.jboss.arquillian.container.spi.client.deployment.TargetDescription;
import org.jboss.arquillian.container.spi.client.protocol.ProtocolDescription;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.container.test.api.OverProtocol;
import org.jboss.arquillian.container.test.api.ShouldThrowException;
import org.jboss.arquillian.container.test.api.TargetsContainer;
import org.jboss.arquillian.container.test.spi.client.deployment.DeploymentScenarioGenerator;
import org.jboss.arquillian.test.spi.TestClass;
import org.jboss.forge.arquillian.AddonDependency;
import org.jboss.forge.arquillian.Dependencies;
import org.jboss.forge.arquillian.DeployToRepository;
import org.jboss.forge.arquillian.archive.ForgeRemoteAddon;
import org.jboss.forge.arquillian.archive.RepositoryForgeArchive;
import org.jboss.forge.arquillian.maven.ProjectHelper;
import org.jboss.forge.furnace.addons.AddonId;
import org.jboss.forge.furnace.util.Annotations;
import org.jboss.forge.furnace.util.Strings;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.descriptor.api.Descriptor;

public class ForgeDeploymentScenarioGenerator
implements DeploymentScenarioGenerator {
    Map<String, String> dependencyMap;

    public List<DeploymentDescription> generate(TestClass testClass) {
        Method[] deploymentMethods;
        ArrayList<DeploymentDescription> deployments = new ArrayList<DeploymentDescription>();
        for (Method deploymentMethod : deploymentMethods = testClass.getMethods(Deployment.class)) {
            this.validate(deploymentMethod);
            if (deploymentMethod.isAnnotationPresent(Dependencies.class)) {
                deployments.addAll(this.generateDependencyDeployments(testClass.getJavaClass(), deploymentMethod));
            }
            deployments.add(this.generateDeployment(deploymentMethod));
        }
        return deployments;
    }

    private Collection<DeploymentDescription> generateDependencyDeployments(Class<?> classUnderTest, Method deploymentMethod) {
        Dependencies dependency = deploymentMethod.getAnnotation(Dependencies.class);
        ArrayList<DeploymentDescription> deployments = new ArrayList<DeploymentDescription>();
        if (dependency.value() != null) {
            for (AddonDependency addon : dependency.value()) {
                String version;
                if (addon.version().isEmpty()) {
                    version = this.resolveVersionFromPOM(classUnderTest, addon.name());
                    if (version == null) {
                        throw new IllegalStateException("Could not resolve the version for [" + addon.name() + "]. Either specify the version for this @" + AddonDependency.class.getSimpleName() + " in [" + classUnderTest.getName() + "] or add it to pom.xml located at [" + this.getPomFileFor(classUnderTest) + "]");
                    }
                } else {
                    version = addon.version();
                }
                AddonId id = AddonId.from((String)addon.name(), (String)version);
                ForgeRemoteAddon remoteAddon = ((ForgeRemoteAddon)ShrinkWrap.create(ForgeRemoteAddon.class)).setAddonId(id);
                if (Annotations.isAnnotationPresent((Method)deploymentMethod, DeployToRepository.class)) {
                    remoteAddon.setAddonRepository(((DeployToRepository)Annotations.getAnnotation((Method)deploymentMethod, DeployToRepository.class)).value());
                }
                DeploymentDescription deploymentDescription = new DeploymentDescription(id.toCoordinates(), (Archive)remoteAddon);
                deploymentDescription.shouldBeTestable(false);
                deployments.add(deploymentDescription);
            }
        }
        return deployments;
    }

    private String resolveVersionFromPOM(Class<?> classUnderTest, String name) {
        if (this.dependencyMap == null) {
            ProjectHelper projectHelper = new ProjectHelper();
            this.dependencyMap = new HashMap<String, String>();
            File pomFile = this.getPomFileFor(classUnderTest);
            try {
                Model model = projectHelper.loadPomFromFile(pomFile, new String[0]);
                String thisAddonName = model.getGroupId() == null ? model.getParent().getGroupId() : model.getGroupId() + ":" + model.getArtifactId();
                String thisVersion = model.getVersion();
                this.dependencyMap.put(thisAddonName, thisVersion);
                List<Dependency> dependencies = projectHelper.resolveDependenciesFromPOM(pomFile);
                for (Dependency dependency : dependencies) {
                    Artifact artifact = dependency.getArtifact();
                    String addonName = artifact.getGroupId() + ":" + artifact.getArtifactId();
                    String version = artifact.getBaseVersion();
                    this.dependencyMap.put(addonName, version);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return this.dependencyMap.get(name);
    }

    private File getPomFileFor(Class<?> classUnderTest) {
        URL resource = classUnderTest.getClassLoader().getResource("");
        if (resource == null) {
            throw new IllegalStateException("Could not find the pom.xml for class " + classUnderTest.getName());
        }
        String directory = resource.getFile();
        File pomFile = this.findBuildDescriptor(directory);
        return pomFile;
    }

    private File findBuildDescriptor(String classLocation) {
        File pom = null;
        for (File dir = new File(classLocation); dir != null; dir = dir.getParentFile()) {
            File testPom = new File(dir, "pom.xml");
            if (!testPom.isFile()) continue;
            pom = testPom;
            break;
        }
        return pom;
    }

    private void validate(Method deploymentMethod) {
        if (!Modifier.isStatic(deploymentMethod.getModifiers())) {
            throw new IllegalArgumentException("Method annotated with " + Deployment.class.getName() + " is not static. " + deploymentMethod);
        }
        if (!Archive.class.isAssignableFrom(deploymentMethod.getReturnType()) && !Descriptor.class.isAssignableFrom(deploymentMethod.getReturnType())) {
            throw new IllegalArgumentException("Method annotated with " + Deployment.class.getName() + " must have return type " + Archive.class.getName() + " or " + Descriptor.class.getName() + ". " + deploymentMethod);
        }
        if (deploymentMethod.getParameterTypes().length != 0) {
            throw new IllegalArgumentException("Method annotated with " + Deployment.class.getName() + " can not accept parameters. " + deploymentMethod);
        }
        String name = deploymentMethod.getAnnotation(Deployment.class).name();
        try {
            if (!Strings.isNullOrEmpty((String)name) && !"_DEFAULT_".equals(name)) {
                AddonId.fromCoordinates((String)name);
            }
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("@" + Deployment.class.getName() + " requires name in the format \"name,version\", but was \"" + name + "\". ");
        }
    }

    private DeploymentDescription generateDeployment(Method deploymentMethod) {
        TargetDescription target = this.generateTarget(deploymentMethod);
        ProtocolDescription protocol = this.generateProtocol(deploymentMethod);
        Deployment deploymentAnnotation = deploymentMethod.getAnnotation(Deployment.class);
        DeploymentDescription description = null;
        if (Archive.class.isAssignableFrom(deploymentMethod.getReturnType())) {
            Archive archive = this.invoke(Archive.class, deploymentMethod);
            if (archive instanceof RepositoryForgeArchive && Annotations.isAnnotationPresent((Method)deploymentMethod, DeployToRepository.class)) {
                ((RepositoryForgeArchive)archive).setAddonRepository(((DeployToRepository)Annotations.getAnnotation((Method)deploymentMethod, DeployToRepository.class)).value());
            }
            description = new DeploymentDescription(deploymentAnnotation.name(), archive);
            description.shouldBeTestable(deploymentAnnotation.testable());
        } else if (Descriptor.class.isAssignableFrom(deploymentMethod.getReturnType())) {
            description = new DeploymentDescription(deploymentAnnotation.name(), this.invoke(Descriptor.class, deploymentMethod));
        }
        description.shouldBeManaged(deploymentAnnotation.managed());
        description.setOrder(deploymentAnnotation.order());
        if (target != null) {
            description.setTarget(target);
        }
        if (protocol != null) {
            description.setProtocol(protocol);
        }
        if (deploymentMethod.isAnnotationPresent(ShouldThrowException.class)) {
            description.setExpectedException(deploymentMethod.getAnnotation(ShouldThrowException.class).value());
        }
        return description;
    }

    private TargetDescription generateTarget(Method deploymentMethod) {
        if (deploymentMethod.isAnnotationPresent(TargetsContainer.class)) {
            return new TargetDescription(deploymentMethod.getAnnotation(TargetsContainer.class).value());
        }
        return TargetDescription.DEFAULT;
    }

    private ProtocolDescription generateProtocol(Method deploymentMethod) {
        if (deploymentMethod.isAnnotationPresent(OverProtocol.class)) {
            return new ProtocolDescription(deploymentMethod.getAnnotation(OverProtocol.class).value());
        }
        return ProtocolDescription.DEFAULT;
    }

    private <T> T invoke(Class<T> type, Method deploymentMethod) {
        try {
            return type.cast(deploymentMethod.invoke(null, new Object[0]));
        }
        catch (Exception e) {
            throw new RuntimeException("Could not invoke deployment method: " + deploymentMethod, e);
        }
    }
}

