/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.arquillian;

import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.concurrent.ExecutionException;
import org.jboss.arquillian.container.test.spi.ContainerMethodExecutor;
import org.jboss.arquillian.test.spi.TestMethodExecutor;
import org.jboss.arquillian.test.spi.TestResult;
import org.jboss.forge.arquillian.protocol.ForgeProtocolConfiguration;
import org.jboss.forge.arquillian.protocol.FurnaceHolder;
import org.jboss.forge.furnace.Furnace;
import org.jboss.forge.furnace.addons.Addon;
import org.jboss.forge.furnace.addons.AddonRegistry;
import org.jboss.forge.furnace.proxy.ClassLoaderAdapterBuilder;
import org.jboss.forge.furnace.proxy.Proxies;
import org.jboss.forge.furnace.repositories.AddonRepository;
import org.jboss.forge.furnace.spi.ExportedInstance;
import org.jboss.forge.furnace.spi.ServiceRegistry;
import org.jboss.forge.furnace.util.Annotations;
import org.jboss.forge.furnace.util.Assert;
import org.jboss.forge.furnace.util.ClassLoaders;

public class ForgeTestMethodExecutor
implements ContainerMethodExecutor {
    private Furnace furnace;

    public ForgeTestMethodExecutor(ForgeProtocolConfiguration config, FurnaceHolder holder) {
        Assert.notNull((Object)config, (String)"ForgeProtocolConfiguration must be specified");
        Assert.notNull((Object)holder, (String)"Furnace runtime must be provided");
        this.furnace = holder.getFurnace();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TestResult invoke(TestMethodExecutor testMethodExecutor) {
        Assert.notNull((Object)testMethodExecutor, (String)"TestMethodExecutor must be specified");
        String testClassName = testMethodExecutor.getInstance().getClass().getName();
        Object testInstance = null;
        Class testClass = null;
        try {
            AddonRegistry addonRegistry = this.furnace.getAddonRegistry(new AddonRepository[0]);
            this.waitUntilStable(this.furnace);
            System.out.println("Searching for test [" + testClassName + "]");
            for (Addon addon : addonRegistry.getAddons()) {
                ServiceRegistry registry;
                ExportedInstance exportedInstance;
                if (!addon.getStatus().isStarted() || (exportedInstance = (registry = addon.getServiceRegistry()).getExportedInstance(testClassName)) == null) continue;
                if (testInstance == null) {
                    testInstance = exportedInstance.get();
                    testClass = ClassLoaders.loadClass((ClassLoader)addon.getClassLoader(), (String)testClassName);
                    continue;
                }
                throw new IllegalStateException("Multiple test classes found in deployed addons. You must have only one @Deployment(testable=true\"); deployment");
            }
        }
        catch (Exception e) {
            String message = "Error launching test " + testMethodExecutor.getInstance().getClass().getName() + "." + testMethodExecutor.getMethod().getName() + "()";
            System.out.println(message);
            throw new IllegalStateException(message, e);
        }
        if (testInstance != null) {
            try {
                TestResult result;
                block33: {
                    result = null;
                    try {
                        Annotation[] annotations;
                        try {
                            testInstance = ClassLoaderAdapterBuilder.callingLoader((ClassLoader)this.getClass().getClassLoader()).delegateLoader(testInstance.getClass().getClassLoader()).enhance(testInstance, new Class[]{testClass});
                        }
                        catch (Exception e) {
                            System.out.println("Could not enhance test class. Falling back to un-proxied invocation.");
                        }
                        Method method = testInstance.getClass().getMethod(testMethodExecutor.getMethod().getName(), new Class[0]);
                        for (Annotation annotation : annotations = method.getAnnotations()) {
                            if (!"org.junit.Ignore".equals(annotation.getClass().getName())) continue;
                            result = TestResult.skipped(null);
                        }
                        if (result != null) break block33;
                        try {
                            System.out.println("Executing test method: " + testMethodExecutor.getInstance().getClass().getName() + "." + testMethodExecutor.getMethod().getName() + "()");
                            try {
                                this.invokeBefore(testInstance.getClass(), testInstance);
                                method.invoke(testInstance, new Object[0]);
                                result = TestResult.passed();
                            }
                            catch (Exception e) {
                                Throwable rootCause = this.getRootCause(e);
                                if (rootCause != null && Proxies.isForgeProxy((Object)rootCause) && "org.junit.internal.AssumptionViolatedException".equals(Proxies.unwrap((Object)rootCause).getClass().getName())) {
                                    try {
                                        Throwable thisClassloaderException = (Throwable)Class.forName("org.junit.internal.AssumptionViolatedException").getConstructor(String.class).newInstance(rootCause.getMessage());
                                        thisClassloaderException.setStackTrace(rootCause.getStackTrace());
                                        result = TestResult.skipped((Throwable)thisClassloaderException);
                                    }
                                    catch (Exception ex) {
                                        result = TestResult.skipped((Throwable)ex);
                                    }
                                    break block33;
                                }
                                throw e;
                            }
                            finally {
                                this.invokeAfter(testInstance.getClass(), testInstance);
                            }
                        }
                        catch (InvocationTargetException e) {
                            if (e.getCause() != null && e.getCause() instanceof Exception) {
                                throw (Exception)e.getCause();
                            }
                            throw e;
                        }
                    }
                    catch (AssertionError e) {
                        result = TestResult.failed((Throwable)((Object)e));
                    }
                    catch (Exception e) {
                        result = TestResult.failed((Throwable)e);
                        for (Throwable cause = e.getCause(); cause != null; cause = cause.getCause()) {
                            if (!(cause instanceof AssertionError)) continue;
                            result = TestResult.failed((Throwable)cause);
                            break;
                        }
                    }
                }
                TestResult e = result;
                return e;
            }
            catch (Exception e) {
                String message = "Error launching test " + testMethodExecutor.getInstance().getClass().getName() + "." + testMethodExecutor.getMethod().getName() + "()";
                System.out.println(message);
                throw new IllegalStateException(message, e);
            }
        }
        for (Addon addon : this.furnace.getAddonRegistry(new AddonRepository[0]).getAddons()) {
            try {
                addon.getFuture().get();
            }
            catch (InterruptedException e) {
            }
            catch (ExecutionException e) {
                throw new IllegalStateException("Test runner could not locate test class [" + testClassName + "] in any deployed Addon.", e.getCause());
            }
        }
        throw new IllegalStateException("Test runner could not locate test class [" + testClassName + "] in any deployed Addon.");
        finally {
            this.furnace = null;
        }
    }

    private void invokeBefore(Class<?> clazz, Object instance) throws Exception {
        if (clazz.getSuperclass() != null && !Object.class.equals(clazz.getSuperclass())) {
            this.invokeBefore(clazz.getSuperclass(), instance);
        }
        for (Method m : clazz.getMethods()) {
            if (!Annotations.isAnnotationPresent((Method)m, clazz.getClassLoader().loadClass("org.junit.Before"))) continue;
            m.invoke(instance, new Object[0]);
        }
    }

    private void invokeAfter(Class<?> clazz, Object instance) throws Exception {
        for (Method m : clazz.getMethods()) {
            if (!Annotations.isAnnotationPresent((Method)m, clazz.getClassLoader().loadClass("org.junit.After"))) continue;
            m.invoke(instance, new Object[0]);
        }
        if (clazz.getSuperclass() != null && !Object.class.equals(clazz.getSuperclass())) {
            this.invokeAfter(clazz.getSuperclass(), instance);
        }
    }

    private Throwable getRootCause(Throwable t) {
        Throwable result = t;
        for (Throwable cause = t; cause != null; cause = cause.getCause()) {
            result = cause;
        }
        return result;
    }

    private void waitUntilStable(Furnace furnace) throws InterruptedException {
        while (furnace.getStatus().isStarting()) {
            Thread.sleep(10L);
        }
    }
}

