/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.arquillian.archive;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.logging.Logger;
import org.jboss.forge.arquillian.archive.ForgeArchive;
import org.jboss.forge.arquillian.archive.RepositoryForgeArchive;
import org.jboss.forge.arquillian.services.LocalServices;
import org.jboss.forge.furnace.lifecycle.AddonLifecycleProvider;
import org.jboss.forge.furnace.repositories.AddonDependencyEntry;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ArchivePath;
import org.jboss.shrinkwrap.api.ArchivePaths;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.EmptyAsset;
import org.jboss.shrinkwrap.impl.base.Validate;
import org.jboss.shrinkwrap.impl.base.container.ContainerBase;

public class ForgeArchiveImpl
extends ContainerBase<ForgeArchive>
implements ForgeArchive,
RepositoryForgeArchive {
    private static final Logger log = Logger.getLogger(ForgeArchiveImpl.class.getName());
    private static final ArchivePath PATH_ROOT = ArchivePaths.root();
    private static final ArchivePath PATH_CLASSES = ArchivePaths.create((ArchivePath)PATH_ROOT, (String)"");
    private static final ArchivePath PATH_LIBRARY = ArchivePaths.create((ArchivePath)PATH_ROOT, (String)"lib");
    private static final ArchivePath PATH_MANIFEST = ArchivePaths.create((String)"META-INF");
    private static final ArchivePath PATH_FORGE_XML = ArchivePaths.create((String)"META-INF/forge.xml");
    private static final ArchivePath PATH_SERVICE_PROVIDERS = ArchivePaths.create((ArchivePath)PATH_CLASSES, (String)"META-INF/services");
    private List<AddonDependencyEntry> addonDependencies = new ArrayList<AddonDependencyEntry>();
    private String repository;
    private static final String SERVICE_REGISTRATION_FILE_NAME = "org.jboss.forge.furnace.services.Exported";

    public ForgeArchiveImpl(Archive<?> delegate) {
        super(ForgeArchive.class, delegate);
    }

    protected ArchivePath getManifestPath() {
        return PATH_MANIFEST;
    }

    protected ArchivePath getForgeXMLPath() {
        return PATH_FORGE_XML;
    }

    protected ArchivePath getClassesPath() {
        return PATH_CLASSES;
    }

    protected ArchivePath getLibraryPath() {
        return PATH_LIBRARY;
    }

    protected ArchivePath getServiceProvidersPath() {
        return PATH_SERVICE_PROVIDERS;
    }

    protected ArchivePath getResourcePath() {
        return PATH_CLASSES;
    }

    @Override
    public ForgeArchive setAsForgeXML(Asset resource) throws IllegalArgumentException {
        Validate.notNull((Object)resource, (String)"Resource should be specified");
        return (ForgeArchive)this.add(resource, this.getForgeXMLPath());
    }

    @Override
    public ForgeArchive addAsAddonDependencies(AddonDependencyEntry ... dependencies) {
        if (dependencies != null) {
            this.addonDependencies.addAll(Arrays.asList(dependencies));
        }
        return this;
    }

    @Override
    public List<AddonDependencyEntry> getAddonDependencies() {
        return this.addonDependencies;
    }

    @Override
    public ForgeArchive addBeansXML() {
        this.addAsManifestResource((Asset)EmptyAsset.INSTANCE, ArchivePaths.create((String)"beans.xml"));
        return this;
    }

    @Override
    public ForgeArchive addBeansXML(Asset resource) {
        this.addAsManifestResource(resource, ArchivePaths.create((String)"beans.xml"));
        return this;
    }

    @Override
    public String getAddonRepository() {
        return this.repository;
    }

    @Override
    public RepositoryForgeArchive setAddonRepository(String repository) {
        this.repository = repository;
        return this;
    }

    @Override
    public ForgeArchive addAsLocalServices(Class<?> ... serviceTypes) {
        this.addAsServiceProvider(AddonLifecycleProvider.class, new Class[]{LocalServices.class});
        this.addPackages(true, new Package[]{LocalServices.class.getPackage()});
        LinkedHashSet<String> typeNames = new LinkedHashSet<String>();
        for (Class<?> type : serviceTypes) {
            typeNames.add(type.getName());
        }
        this.addAsServiceProvider(SERVICE_REGISTRATION_FILE_NAME, typeNames.toArray(new String[typeNames.size()]));
        return this;
    }
}

