/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.arquillian.maven;

import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.maven.model.Parent;
import org.apache.maven.model.Repository;
import org.apache.maven.model.building.FileModelSource;
import org.apache.maven.model.building.ModelSource;
import org.apache.maven.model.resolution.InvalidRepositoryException;
import org.apache.maven.model.resolution.ModelResolver;
import org.apache.maven.model.resolution.UnresolvableModelException;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.resolution.ArtifactRequest;
import org.eclipse.aether.resolution.ArtifactResolutionException;

public class MavenModelResolver
implements ModelResolver {
    private final List<RemoteRepository> repositories;
    private final Set<String> repositoryIds;
    private final RepositorySystem system;
    private final RepositorySystemSession session;

    public MavenModelResolver(RepositorySystem system, RepositorySystemSession session, List<RemoteRepository> remoteRepositories) {
        this.system = system;
        this.session = session;
        this.repositories = new ArrayList<RemoteRepository>(remoteRepositories.size());
        for (RemoteRepository remoteRepository : remoteRepositories) {
            this.repositories.add(new RemoteRepository.Builder(remoteRepository).build());
        }
        this.repositoryIds = new HashSet<String>(this.repositories.size());
        for (RemoteRepository repository : this.repositories) {
            this.repositoryIds.add(repository.getId());
        }
    }

    private MavenModelResolver(MavenModelResolver origin) {
        this(origin.system, origin.session, origin.repositories);
    }

    public void addRepository(Repository repository) throws InvalidRepositoryException {
        if (this.repositoryIds.contains(repository.getId())) {
            return;
        }
        this.repositoryIds.add(repository.getId());
        this.repositories.add(new RemoteRepository.Builder(repository.getId(), repository.getName(), repository.getUrl()).build());
    }

    public ModelResolver newCopy() {
        return new MavenModelResolver(this);
    }

    public ModelSource resolveModel(String groupId, String artifactId, String version) throws UnresolvableModelException {
        DefaultArtifact pomArtifact = new DefaultArtifact(groupId, artifactId, "", "pom", version);
        try {
            ArtifactRequest request = new ArtifactRequest((Artifact)pomArtifact, this.repositories, null);
            pomArtifact = this.system.resolveArtifact(this.session, request).getArtifact();
        }
        catch (ArtifactResolutionException e) {
            throw new UnresolvableModelException("Failed to resolve POM for " + groupId + ":" + artifactId + ":" + version + " due to " + e.getMessage(), groupId, artifactId, version, (Throwable)e);
        }
        File pomFile = pomArtifact.getFile();
        return new FileModelSource(pomFile);
    }

    public ModelSource resolveModel(Parent parent) throws UnresolvableModelException {
        return this.resolveModel(parent.getGroupId(), parent.getArtifactId(), parent.getVersion());
    }

    public void addRepository(Repository repository, boolean replace) throws InvalidRepositoryException {
        if (this.session.isIgnoreArtifactDescriptorRepositories()) {
            return;
        }
        if (!this.repositoryIds.add(repository.getId())) {
            if (!replace) {
                return;
            }
            this.removeMatchingRepository(repository.getId());
        }
        this.repositories.add(new RemoteRepository.Builder(repository.getId(), repository.getName(), repository.getUrl()).build());
    }

    private void removeMatchingRepository(String id) {
        Iterator<RemoteRepository> iterator = this.repositories.iterator();
        while (iterator.hasNext()) {
            RemoteRepository remoteRepository = iterator.next();
            if (!remoteRepository.getId().equals(id)) continue;
            iterator.remove();
        }
    }
}

