/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.arquillian.maven;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.execution.DefaultMavenExecutionRequest;
import org.apache.maven.execution.MavenExecutionRequest;
import org.apache.maven.execution.MavenExecutionRequestPopulator;
import org.apache.maven.model.Model;
import org.apache.maven.model.building.DefaultModelBuilder;
import org.apache.maven.model.building.DefaultModelBuilderFactory;
import org.apache.maven.model.building.DefaultModelBuildingRequest;
import org.apache.maven.model.building.ModelBuildingException;
import org.apache.maven.model.building.ModelBuildingRequest;
import org.apache.maven.model.building.ModelBuildingResult;
import org.apache.maven.model.building.ModelProblem;
import org.apache.maven.model.resolution.ModelResolver;
import org.apache.maven.project.ProjectBuilder;
import org.apache.maven.project.ProjectBuildingRequest;
import org.apache.maven.project.ProjectBuildingResult;
import org.apache.maven.repository.internal.MavenRepositorySystemUtils;
import org.apache.maven.settings.Mirror;
import org.apache.maven.settings.Profile;
import org.apache.maven.settings.Proxy;
import org.apache.maven.settings.Repository;
import org.apache.maven.settings.Server;
import org.apache.maven.settings.Settings;
import org.eclipse.aether.DefaultRepositorySystemSession;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.graph.Dependency;
import org.eclipse.aether.repository.AuthenticationSelector;
import org.eclipse.aether.repository.LocalRepository;
import org.eclipse.aether.repository.MirrorSelector;
import org.eclipse.aether.repository.ProxySelector;
import org.eclipse.aether.util.repository.AuthenticationBuilder;
import org.eclipse.aether.util.repository.DefaultMirrorSelector;
import org.eclipse.aether.util.repository.DefaultProxySelector;
import org.jboss.forge.arquillian.maven.LazyAuthenticationSelector;
import org.jboss.forge.arquillian.maven.MavenModelResolver;
import org.jboss.forge.arquillian.maven.PlexusContainer;
import org.jboss.forge.arquillian.maven.RepositoryUtils;
import org.jboss.forge.furnace.manager.maven.MavenContainer;

public class ProjectHelper {
    private final MavenContainer mavenContainer = new MavenContainer();
    private ProjectBuildingRequest request;

    public Model loadPomFromFile(File pomFile, String ... profiles) {
        ModelBuildingResult result;
        RepositorySystem system = this.mavenContainer.getRepositorySystem();
        Settings settings = this.mavenContainer.getSettings();
        DefaultRepositorySystemSession session = this.mavenContainer.setupRepoSession(system, settings);
        DefaultModelBuildingRequest request = new DefaultModelBuildingRequest().setSystemProperties(System.getProperties()).setPomFile(pomFile).setActiveProfileIds(settings.getActiveProfiles());
        DefaultModelBuilder builder = new DefaultModelBuilderFactory().newInstance();
        try {
            request.setModelResolver((ModelResolver)new MavenModelResolver(system, (RepositorySystemSession)session, this.mavenContainer.getEnabledRepositoriesFromProfile(settings)));
            result = builder.build((ModelBuildingRequest)request);
        }
        catch (ModelBuildingException e) {
            String pomPath = request.getPomFile().getAbsolutePath();
            StringBuilder sb = new StringBuilder("Found ").append(e.getProblems().size()).append(" problems while building POM model from ").append(pomPath).append("\n");
            int counter = 1;
            for (ModelProblem problem : e.getProblems()) {
                sb.append(counter++).append("/ ").append(problem).append("\n");
            }
            throw new RuntimeException(sb.toString());
        }
        return result.getEffectiveModel();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Dependency> resolveDependenciesFromPOM(File pomFile) throws Exception {
        List result;
        PlexusContainer plexus = new PlexusContainer();
        try {
            ProjectBuildingRequest request = this.getBuildingRequest(plexus);
            request.setResolveDependencies(true);
            ProjectBuilder builder = plexus.lookup(ProjectBuilder.class);
            ProjectBuildingResult build = builder.build(pomFile, request);
            result = build.getDependencyResolutionResult().getDependencies();
        }
        finally {
            plexus.shutdown();
        }
        return result;
    }

    private ProjectBuildingRequest getBuildingRequest(PlexusContainer plexus) {
        if (this.request == null) {
            ClassLoader cl = Thread.currentThread().getContextClassLoader();
            try {
                Settings settings = this.mavenContainer.getSettings();
                DefaultMavenExecutionRequest executionRequest = new DefaultMavenExecutionRequest();
                RepositorySystem repositorySystem = plexus.lookup(RepositorySystem.class);
                MavenExecutionRequestPopulator requestPopulator = plexus.lookup(MavenExecutionRequestPopulator.class);
                requestPopulator.populateFromSettings((MavenExecutionRequest)executionRequest, settings);
                requestPopulator.populateDefaults((MavenExecutionRequest)executionRequest);
                ProjectBuildingRequest request = executionRequest.getProjectBuildingRequest();
                ArtifactRepository localRepository = RepositoryUtils.toArtifactRepository("local", new File(settings.getLocalRepository()).toURI().toURL().toString(), null, true, true);
                request.setLocalRepository(localRepository);
                ArrayList<ArtifactRepository> settingsRepos = new ArrayList<ArtifactRepository>(request.getRemoteRepositories());
                List activeProfiles = settings.getActiveProfiles();
                Map profiles = settings.getProfilesAsMap();
                for (String id : activeProfiles) {
                    Profile profile = (Profile)profiles.get(id);
                    if (profile == null) continue;
                    List repositories = profile.getRepositories();
                    for (Repository repository : repositories) {
                        settingsRepos.add(RepositoryUtils.convertFromMavenSettingsRepository(repository));
                    }
                }
                request.setRemoteRepositories(settingsRepos);
                request.setSystemProperties(System.getProperties());
                DefaultRepositorySystemSession repositorySession = MavenRepositorySystemUtils.newSession();
                Proxy activeProxy = settings.getActiveProxy();
                if (activeProxy != null) {
                    DefaultProxySelector dps = new DefaultProxySelector();
                    dps.add(RepositoryUtils.convertFromMavenProxy(activeProxy), activeProxy.getNonProxyHosts());
                    repositorySession.setProxySelector((ProxySelector)dps);
                }
                LocalRepository localRepo = new LocalRepository(settings.getLocalRepository());
                repositorySession.setLocalRepositoryManager(repositorySystem.newLocalRepositoryManager((RepositorySystemSession)repositorySession, localRepo));
                repositorySession.setOffline(settings.isOffline());
                List mirrors = executionRequest.getMirrors();
                DefaultMirrorSelector mirrorSelector = new DefaultMirrorSelector();
                if (mirrors != null) {
                    for (Mirror mirror : mirrors) {
                        mirrorSelector.add(mirror.getId(), mirror.getUrl(), mirror.getLayout(), false, mirror.getMirrorOf(), mirror.getMirrorOfLayouts());
                    }
                }
                repositorySession.setMirrorSelector((MirrorSelector)mirrorSelector);
                LazyAuthenticationSelector authSelector = new LazyAuthenticationSelector(mirrorSelector);
                for (Server server : settings.getServers()) {
                    authSelector.add(server.getId(), new AuthenticationBuilder().addUsername(server.getUsername()).addPassword(server.getPassword()).addPrivateKey(server.getPrivateKey(), server.getPassphrase()).build());
                }
                repositorySession.setAuthenticationSelector((AuthenticationSelector)authSelector);
                request.setRepositorySession((RepositorySystemSession)repositorySession);
                request.setProcessPlugins(false);
                request.setResolveDependencies(false);
                this.request = request;
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new RuntimeException("Could not create Maven project building request", e);
            }
            finally {
                Thread.currentThread().setContextClassLoader(cl);
            }
        }
        return this.request;
    }
}

