/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.arquillian.services;

import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.net.URL;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jboss.forge.arquillian.services.LazyServiceRegistryEventManager;
import org.jboss.forge.arquillian.services.ReflectionServiceRegistry;
import org.jboss.forge.furnace.Furnace;
import org.jboss.forge.furnace.addons.Addon;
import org.jboss.forge.furnace.addons.AddonRegistry;
import org.jboss.forge.furnace.event.EventManager;
import org.jboss.forge.furnace.event.PostStartup;
import org.jboss.forge.furnace.event.PreShutdown;
import org.jboss.forge.furnace.lifecycle.AddonLifecycleProvider;
import org.jboss.forge.furnace.lifecycle.ControlType;
import org.jboss.forge.furnace.spi.ServiceRegistry;
import org.jboss.forge.furnace.util.ClassLoaders;
import org.jboss.forge.furnace.util.Streams;

public class LocalServices
implements AddonLifecycleProvider {
    private static final String SERVICE_REGISTRATION_FILE_NAME = "org.jboss.forge.furnace.services.Exported";
    private Furnace furnace;
    private static Map<ClassLoader, Furnace> started = new ConcurrentHashMap<ClassLoader, Furnace>();

    public void initialize(Furnace furnace, AddonRegistry registry, Addon self) throws Exception {
        this.furnace = furnace;
    }

    public void start(Addon addon) throws Exception {
        started.put(addon.getClassLoader(), this.furnace);
    }

    public void stop(Addon addon) throws Exception {
        started.remove(addon.getClassLoader());
    }

    public static Furnace getFurnace(ClassLoader loader) {
        return started.get(loader);
    }

    public EventManager getEventManager(Addon addon) {
        return new LazyServiceRegistryEventManager(addon);
    }

    public ServiceRegistry getServiceRegistry(Addon addon) throws Exception {
        URL resource = addon.getClassLoader().getResource("/META-INF/services/org.jboss.forge.furnace.services.Exported");
        HashSet serviceTypes = new HashSet();
        if (resource != null) {
            InputStream stream = resource.openStream();
            String services = Streams.toString((InputStream)stream);
            for (String serviceType : services.split("\n")) {
                if (!ClassLoaders.containsClass((ClassLoader)addon.getClassLoader(), (String)serviceType)) continue;
                Class type = ClassLoaders.loadClass((ClassLoader)addon.getClassLoader(), (String)serviceType);
                serviceTypes.add(type);
            }
        }
        return new ReflectionServiceRegistry(this.furnace, addon, serviceTypes);
    }

    public void postStartup(Addon addon) throws Exception {
        this.getEventManager(addon).fireEvent((Object)new PostStartup(addon), new Annotation[0]);
    }

    public void preShutdown(Addon addon) throws Exception {
        this.getEventManager(addon).fireEvent((Object)new PreShutdown(addon), new Annotation[0]);
    }

    public ControlType getControlType() {
        return ControlType.SELF;
    }
}

