/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.arquillian.services;

import org.jboss.forge.furnace.addons.Addon;
import org.jboss.forge.furnace.exception.ContainerException;
import org.jboss.forge.furnace.proxy.ClassLoaderInterceptor;
import org.jboss.forge.furnace.proxy.ForgeProxy;
import org.jboss.forge.furnace.proxy.Proxies;
import org.jboss.forge.furnace.spi.ExportedInstance;

public class ReflectionExportedInstance<T>
implements ExportedInstance<T> {
    private final Class<T> type;
    private final Addon addon;

    public ReflectionExportedInstance(Addon addon, Class<T> clazz) {
        this.addon = addon;
        this.type = clazz;
    }

    public T get() {
        try {
            Object delegate = this.type.newInstance();
            delegate = Proxies.enhance((ClassLoader)this.addon.getClassLoader(), delegate, (ForgeProxy)new ClassLoaderInterceptor(this.addon.getClassLoader(), delegate));
            return delegate;
        }
        catch (Exception e) {
            throw new ContainerException("Could not create instance of [" + this.type.getName() + "] through reflection.", (Throwable)e);
        }
    }

    public void release(T instance) {
    }

    public String toString() {
        return this.type.getName() + " from " + this.addon;
    }

    public Class<? extends T> getActualType() {
        return this.type;
    }

    public Addon getSourceAddon() {
        return this.addon;
    }
}

