/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.arquillian.services;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Logger;
import org.jboss.forge.arquillian.services.ReflectionExportedInstance;
import org.jboss.forge.furnace.Furnace;
import org.jboss.forge.furnace.addons.Addon;
import org.jboss.forge.furnace.spi.ExportedInstance;
import org.jboss.forge.furnace.spi.ServiceRegistry;
import org.jboss.forge.furnace.util.Assert;
import org.jboss.forge.furnace.util.ClassLoaders;

public class ReflectionServiceRegistry
implements ServiceRegistry {
    private final Logger log = Logger.getLogger(this.getClass().getName());
    private final Addon addon;
    private final Set<Class<?>> serviceTypes;

    public ReflectionServiceRegistry(Furnace furnace, Addon addon, Set<Class<?>> serviceTypes) {
        this.addon = addon;
        this.serviceTypes = serviceTypes;
    }

    public <T> Set<ExportedInstance<T>> getExportedInstances(Class<T> requestedType) {
        HashSet<ExportedInstance<T>> result = new HashSet<ExportedInstance<T>>();
        for (Class<?> type : this.serviceTypes) {
            if (!requestedType.isAssignableFrom(type)) continue;
            result.add(new ReflectionExportedInstance<T>(this.addon, requestedType));
        }
        return result;
    }

    public <T> Set<ExportedInstance<T>> getExportedInstances(String typeName) {
        HashSet<ExportedInstance<T>> result = new HashSet<ExportedInstance<T>>();
        if (ClassLoaders.containsClass((ClassLoader)this.addon.getClassLoader(), (String)typeName)) {
            Class type = ClassLoaders.loadClass((ClassLoader)this.addon.getClassLoader(), (String)typeName);
            result.addAll(this.getExportedInstances(type));
        }
        return result;
    }

    public <T> ExportedInstance<T> getExportedInstance(Class<T> requestedType) {
        Assert.notNull(requestedType, (String)"Requested Class type may not be null");
        if (!ClassLoaders.ownsClass((ClassLoader)this.addon.getClassLoader(), requestedType)) {
            this.log.fine("Class " + requestedType.getName() + " is not present in this addon [" + this.addon + "]");
        }
        for (Class<?> type : this.serviceTypes) {
            if (!requestedType.isAssignableFrom(type)) continue;
            return new ReflectionExportedInstance(this.addon, type);
        }
        return null;
    }

    public <T> ExportedInstance<T> getExportedInstance(String type) {
        if (ClassLoaders.containsClass((ClassLoader)this.addon.getClassLoader(), (String)type)) {
            Class clazz = ClassLoaders.loadClass((ClassLoader)this.addon.getClassLoader(), (String)type);
            return this.getExportedInstance(clazz);
        }
        return null;
    }

    public Set<Class<?>> getExportedTypes() {
        return Collections.unmodifiableSet(this.serviceTypes);
    }

    public <T> Set<Class<T>> getExportedTypes(Class<T> type) {
        HashSet<Class<T>> result = new HashSet<Class<T>>();
        for (Class<?> serviceType : this.serviceTypes) {
            if (!type.isAssignableFrom(serviceType)) continue;
            result.add(type);
        }
        return result;
    }

    public boolean hasService(Class<?> clazz) {
        return !this.getExportedTypes(clazz).isEmpty();
    }

    public boolean hasService(String clazz) {
        if (ClassLoaders.containsClass((ClassLoader)this.addon.getClassLoader(), (String)clazz)) {
            return this.hasService(ClassLoaders.loadClass((ClassLoader)this.addon.getClassLoader(), (String)clazz));
        }
        return false;
    }
}

