/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.arquillian.util;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;

public class NativeSystemCall {
    public static int execFromPath(File path, String command, String ... parms) throws IOException {
        try {
            String[] commandTokens = parms == null ? new String[1] : new String[parms.length + 1];
            commandTokens[0] = command;
            if (commandTokens.length > 1) {
                System.arraycopy(parms, 0, commandTokens, 1, parms.length);
            }
            ProcessBuilder builder = new ProcessBuilder(commandTokens);
            builder.directory(path);
            builder.redirectErrorStream(true);
            Process p = builder.start();
            InputStream stdout = p.getInputStream();
            Thread outThread = new Thread(new Receiver(stdout, System.out));
            outThread.start();
            outThread.join();
            return p.waitFor();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
            return -1;
        }
    }

    public static Process exec(String command, String ... parms) throws IOException {
        String[] commandTokens = parms == null ? new String[1] : new String[parms.length + 1];
        commandTokens[0] = command;
        if (commandTokens.length > 1) {
            System.arraycopy(parms, 0, commandTokens, 1, parms.length);
        }
        ProcessBuilder builder = new ProcessBuilder(commandTokens);
        builder.redirectErrorStream(true);
        Process p = builder.start();
        InputStream stdout = p.getInputStream();
        Thread outThread = new Thread(new Receiver(stdout, System.out));
        outThread.start();
        return p;
    }

    public static Process exec(boolean wait, String command, String ... parms) throws IOException, InterruptedException {
        String[] commandTokens = parms == null ? new String[1] : new String[parms.length + 1];
        commandTokens[0] = command;
        if (commandTokens.length > 1) {
            System.arraycopy(parms, 0, commandTokens, 1, parms.length);
        }
        Process process = Runtime.getRuntime().exec(commandTokens, null);
        if (wait) {
            process.waitFor();
        }
        return process;
    }

    private static class Receiver
    implements Runnable {
        private final InputStream in;
        private final PrintStream out;

        public Receiver(InputStream in, PrintStream out) {
            this.in = in;
            this.out = out;
        }

        @Override
        public void run() {
            try {
                int read;
                byte[] buf = new byte[1024];
                while ((read = this.in.read(buf)) != -1) {
                    this.out.write(buf, 0, read);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

