/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.arquillian.util;

import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.Map;
import org.jboss.forge.furnace.util.Streams;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ArchivePath;
import org.jboss.shrinkwrap.api.Filter;
import org.jboss.shrinkwrap.api.Node;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.exporter.ZipExporter;
import org.jboss.shrinkwrap.descriptor.api.Descriptor;

public final class ShrinkWrapUtil {
    private ShrinkWrapUtil() {
    }

    public static void toFile(File target, Archive<?> archive) {
        try {
            ((ZipExporter)archive.as(ZipExporter.class)).exportTo(target, true);
        }
        catch (Exception e) {
            throw new RuntimeException("Could not export deployment to file [" + target.getAbsolutePath() + "]", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void unzip(File baseDir, Archive<?> archive) {
        try {
            Map content = archive.getContent((Filter)new Filter<ArchivePath>(){

                public boolean include(ArchivePath object) {
                    return object.get().endsWith(".jar");
                }
            });
            for (Map.Entry entry : content.entrySet()) {
                ArchivePath path = (ArchivePath)entry.getKey();
                File target = new File(baseDir.getAbsolutePath() + "/" + path.get().replaceFirst("/lib/", ""));
                target.mkdirs();
                target.delete();
                target.createNewFile();
                Node node = (Node)entry.getValue();
                Asset asset = node.getAsset();
                FileOutputStream fos = null;
                InputStream is = null;
                try {
                    fos = new FileOutputStream(target);
                    is = asset.openStream();
                    Streams.write((InputStream)is, (OutputStream)fos);
                }
                catch (Throwable throwable) {
                    Streams.closeQuietly(is);
                    Streams.closeQuietly((Closeable)fos);
                    throw throwable;
                    return;
                }
                Streams.closeQuietly((Closeable)is);
                Streams.closeQuietly((Closeable)fos);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static URL toURL(Archive<?> archive) {
        try {
            File root = File.createTempFile("arquillian", archive.getName());
            root.delete();
            root.mkdirs();
            File deployment = new File(root, archive.getName());
            deployment.deleteOnExit();
            ((ZipExporter)archive.as(ZipExporter.class)).exportTo(deployment, true);
            return deployment.toURI().toURL();
        }
        catch (Exception e) {
            throw new RuntimeException("Could not export deployment to temp", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static URL toURL(Descriptor descriptor) {
        try {
            File root = File.createTempFile("arquillian", descriptor.getDescriptorName());
            root.delete();
            root.mkdirs();
            File deployment = new File(root, descriptor.getDescriptorName());
            deployment.deleteOnExit();
            FileOutputStream stream = new FileOutputStream(deployment);
            try {
                descriptor.exportTo((OutputStream)stream);
            }
            finally {
                try {
                    stream.close();
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
            return deployment.toURI().toURL();
        }
        catch (Exception e) {
            throw new RuntimeException("Could not export deployment to temp", e);
        }
    }
}

