/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jca.common.api.metadata.ra;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jboss.jca.common.api.metadata.CopyUtil;
import org.jboss.jca.common.api.metadata.CopyableMetaData;
import org.jboss.jca.common.api.metadata.MergeUtil;
import org.jboss.jca.common.api.metadata.ra.IdDecoratedMetadata;
import org.jboss.jca.common.api.metadata.ra.LocalizedXsdString;
import org.jboss.jca.common.api.metadata.ra.MergeableMetadata;

public class LicenseType
implements IdDecoratedMetadata,
MergeableMetadata<LicenseType>,
CopyableMetaData {
    private static final long serialVersionUID = 1590514246054447090L;
    private final ArrayList<LocalizedXsdString> description;
    private final boolean licenseRequired;
    private final String id;
    private final String licReqId;

    public LicenseType(List<LocalizedXsdString> description, boolean licenseRequired, String id, String lrid) {
        if (description != null) {
            this.description = new ArrayList(description.size());
            this.description.addAll(description);
            for (LocalizedXsdString d : this.description) {
                d.setTag(Tag.DESCRIPTION.toString());
            }
        } else {
            this.description = new ArrayList(0);
        }
        this.licenseRequired = licenseRequired;
        this.id = id;
        this.licReqId = lrid;
    }

    public LicenseType(List<LocalizedXsdString> description, boolean licenseRequired, String id) {
        this(description, licenseRequired, id, null);
    }

    public List<LocalizedXsdString> getDescriptions() {
        return this.description == null ? null : Collections.unmodifiableList(this.description);
    }

    public boolean isLicenseRequired() {
        return this.licenseRequired;
    }

    @Override
    public String getId() {
        return this.id;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.description == null ? 0 : this.description.hashCode());
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        result = 31 * result + (this.licenseRequired ? 1231 : 1237);
        result = 31 * result + (this.licReqId == null ? 0 : this.licReqId.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LicenseType)) {
            return false;
        }
        LicenseType other = (LicenseType)obj;
        if (this.description == null ? other.description != null : !this.description.equals(other.description)) {
            return false;
        }
        if (this.licReqId == null ? other.licReqId != null : !this.licReqId.equals(other.licReqId)) {
            return false;
        }
        if (this.id == null ? other.id != null : !this.id.equals(other.id)) {
            return false;
        }
        return this.licenseRequired == other.licenseRequired;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("<license");
        if (this.id != null) {
            sb.append(" ").append((Object)Attribute.ID).append("=\"").append(this.id).append("\"");
        }
        sb.append(">");
        if (this.description != null) {
            for (LocalizedXsdString s : this.description) {
                sb.append(s);
            }
        }
        sb.append("<").append((Object)Tag.LICENSE_REQUIRED).append(this.licReqId == null ? "" : " id=\"" + this.licReqId + "\"").append(">");
        sb.append(this.licenseRequired);
        sb.append("</").append((Object)Tag.LICENSE_REQUIRED).append(">");
        sb.append("</license>");
        return sb.toString();
    }

    @Override
    public LicenseType merge(MergeableMetadata<?> jmd) throws Exception {
        if (jmd instanceof LicenseType) {
            LicenseType inputLicense = (LicenseType)jmd;
            boolean newLicenseRequired = this.licenseRequired || inputLicense.licenseRequired;
            String newId = this.id == null ? inputLicense.id : this.id;
            List<LocalizedXsdString> newDescription = MergeUtil.mergeList(this.description, inputLicense.description);
            return new LicenseType(newDescription, newLicenseRequired, newId);
        }
        return this;
    }

    @Override
    public CopyableMetaData copy() {
        return new LicenseType(CopyUtil.cloneList(this.description), this.licenseRequired, CopyUtil.cloneString(this.id), CopyUtil.cloneString(this.licReqId));
    }

    public static enum Attribute {
        UNKNOWN(null),
        ID("id");

        private String name;
        private static final Map<String, Attribute> MAP;

        private Attribute(String name) {
            this.name = name;
        }

        public String getLocalName() {
            return this.name;
        }

        public String toString() {
            return this.name;
        }

        Attribute value(String v) {
            this.name = v;
            return this;
        }

        public static Attribute forName(String localName) {
            Attribute element = MAP.get(localName);
            return element == null ? UNKNOWN.value(localName) : element;
        }

        static {
            HashMap<String, Attribute> map = new HashMap<String, Attribute>();
            for (Attribute element : Attribute.values()) {
                String name = element.getLocalName();
                if (name == null) continue;
                map.put(name, element);
            }
            MAP = map;
        }
    }

    public static enum Tag {
        UNKNOWN(null),
        DESCRIPTION("description"),
        LICENSE_REQUIRED("license-required");

        private String name;
        private static final Map<String, Tag> MAP;

        private Tag(String name) {
            this.name = name;
        }

        public String getLocalName() {
            return this.name;
        }

        public String toString() {
            return this.name;
        }

        Tag value(String v) {
            this.name = v;
            return this;
        }

        public static Tag forName(String localName) {
            Tag element = MAP.get(localName);
            return element == null ? UNKNOWN.value(localName) : element;
        }

        static {
            HashMap<String, Tag> map = new HashMap<String, Tag>();
            for (Tag element : Tag.values()) {
                String name = element.getLocalName();
                if (name == null) continue;
                map.put(name, element);
            }
            MAP = map;
        }
    }
}

