/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jca.common.metadata.ra.common;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jboss.jca.common.CommonBundle;
import org.jboss.jca.common.api.metadata.CopyUtil;
import org.jboss.jca.common.api.metadata.CopyableMetaData;
import org.jboss.jca.common.api.metadata.MergeUtil;
import org.jboss.jca.common.api.metadata.ra.AdminObject;
import org.jboss.jca.common.api.metadata.ra.ConfigProperty;
import org.jboss.jca.common.api.metadata.ra.InboundResourceAdapter;
import org.jboss.jca.common.api.metadata.ra.MergeableMetadata;
import org.jboss.jca.common.api.metadata.ra.OutboundResourceAdapter;
import org.jboss.jca.common.api.metadata.ra.ResourceAdapter1516;
import org.jboss.jca.common.api.metadata.ra.SecurityPermission;
import org.jboss.jca.common.api.metadata.ra.XsdString;
import org.jboss.jca.common.api.validator.ValidateException;
import org.jboss.jca.common.metadata.ra.common.AbstractResourceAdapetrImpl;
import org.jboss.logging.Messages;

public class ResourceAdapter1516Impl
extends AbstractResourceAdapetrImpl
implements ResourceAdapter1516 {
    private static final long serialVersionUID = 4841095296099713549L;
    private static CommonBundle bundle = (CommonBundle)Messages.getBundle(CommonBundle.class);
    private final XsdString resourceadapterClass;
    private final OutboundResourceAdapter outboundResourceadapter;
    private final InboundResourceAdapter inboundResourceadapter;
    private ArrayList<AdminObject> adminobjects;
    private final ArrayList<SecurityPermission> securityPermissions;
    private final String id;

    public ResourceAdapter1516Impl(String resourceadapterClass, List<? extends ConfigProperty> configProperties, OutboundResourceAdapter outboundResourceadapter, InboundResourceAdapter inboundResourceadapter, List<AdminObject> adminobjects, List<SecurityPermission> securityPermissions, String id) {
        this(new XsdString(resourceadapterClass, null), configProperties, outboundResourceadapter, inboundResourceadapter, adminobjects, securityPermissions, id);
    }

    public ResourceAdapter1516Impl(XsdString resourceadapterClass, List<? extends ConfigProperty> configProperties, OutboundResourceAdapter outboundResourceadapter, InboundResourceAdapter inboundResourceadapter, List<AdminObject> adminobjects, List<SecurityPermission> securityPermissions, String id) {
        this.resourceadapterClass = resourceadapterClass;
        if (!XsdString.isNull((XsdString)this.resourceadapterClass)) {
            this.resourceadapterClass.setTag(ResourceAdapter1516.Tag.RESOURCEADAPTER_CLASS.toString());
        }
        if (configProperties != null) {
            this.configProperties = new ArrayList(configProperties.size());
            this.configProperties.addAll(configProperties);
        } else {
            this.configProperties = new ArrayList(0);
        }
        this.outboundResourceadapter = outboundResourceadapter;
        this.inboundResourceadapter = inboundResourceadapter;
        if (adminobjects != null) {
            this.adminobjects = new ArrayList(adminobjects.size());
            this.adminobjects.addAll(adminobjects);
        } else {
            this.adminobjects = new ArrayList(0);
        }
        if (securityPermissions != null) {
            this.securityPermissions = new ArrayList(securityPermissions.size());
            this.securityPermissions.addAll(securityPermissions);
        } else {
            this.securityPermissions = new ArrayList(0);
        }
        this.id = id;
    }

    public String getResourceadapterClass() {
        if (XsdString.isNull((XsdString)this.resourceadapterClass)) {
            return null;
        }
        return this.resourceadapterClass.getValue();
    }

    public OutboundResourceAdapter getOutboundResourceadapter() {
        return this.outboundResourceadapter;
    }

    public InboundResourceAdapter getInboundResourceadapter() {
        return this.inboundResourceadapter;
    }

    public synchronized List<AdminObject> getAdminObjects() {
        return this.adminobjects == null ? null : Collections.unmodifiableList(this.adminobjects);
    }

    public synchronized void forceAdminObjectsContent(List<AdminObject> newContent) {
        if (newContent != null) {
            this.adminobjects = new ArrayList(newContent.size());
            this.adminobjects.addAll(newContent);
        } else {
            this.adminobjects = new ArrayList(0);
        }
    }

    public List<SecurityPermission> getSecurityPermissions() {
        return this.securityPermissions == null ? null : Collections.unmodifiableList(this.securityPermissions);
    }

    @Override
    public String getId() {
        return this.id;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.adminobjects == null ? 0 : this.adminobjects.hashCode());
        result = 31 * result + (this.configProperties == null ? 0 : this.configProperties.hashCode());
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        result = 31 * result + (this.inboundResourceadapter == null ? 0 : this.inboundResourceadapter.hashCode());
        result = 31 * result + (this.outboundResourceadapter == null ? 0 : this.outboundResourceadapter.hashCode());
        result = 31 * result + (this.resourceadapterClass == null ? 0 : this.resourceadapterClass.hashCode());
        result = 31 * result + (this.securityPermissions == null ? 0 : this.securityPermissions.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ResourceAdapter1516Impl)) {
            return false;
        }
        ResourceAdapter1516Impl other = (ResourceAdapter1516Impl)obj;
        if (this.adminobjects == null ? other.adminobjects != null : !this.adminobjects.equals(other.adminobjects)) {
            return false;
        }
        if (this.configProperties == null ? other.configProperties != null : !this.configProperties.equals(other.configProperties)) {
            return false;
        }
        if (this.id == null ? other.id != null : !this.id.equals(other.id)) {
            return false;
        }
        if (this.inboundResourceadapter == null ? other.inboundResourceadapter != null : !this.inboundResourceadapter.equals(other.inboundResourceadapter)) {
            return false;
        }
        if (this.outboundResourceadapter == null ? other.outboundResourceadapter != null : !this.outboundResourceadapter.equals(other.outboundResourceadapter)) {
            return false;
        }
        if (this.resourceadapterClass == null ? other.resourceadapterClass != null : !this.resourceadapterClass.equals((Object)other.resourceadapterClass)) {
            return false;
        }
        return !(this.securityPermissions == null ? other.securityPermissions != null : !this.securityPermissions.equals(other.securityPermissions));
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(1024);
        sb.append("<").append("resourceadapter");
        if (this.id != null) {
            sb.append(" ").append(ResourceAdapter1516.Attribute.ID).append("=\"").append(this.id).append("\"");
        }
        sb.append(">");
        if (this.resourceadapterClass != null) {
            sb.append(this.resourceadapterClass);
        }
        if (this.configProperties != null) {
            for (ConfigProperty cp : this.configProperties) {
                sb.append(cp);
            }
        }
        if (this.outboundResourceadapter != null) {
            sb.append(this.outboundResourceadapter);
        }
        if (this.inboundResourceadapter != null) {
            sb.append(this.inboundResourceadapter);
        }
        if (this.adminobjects != null) {
            for (AdminObject ao : this.adminobjects) {
                sb.append(ao);
            }
        }
        if (this.securityPermissions != null) {
            for (SecurityPermission sp : this.securityPermissions) {
                sb.append(sp);
            }
        }
        sb.append("</resourceadapter>");
        return sb.toString();
    }

    @Override
    public void validate() throws ValidateException {
        boolean inboundOrOutbound = false;
        if (this.getOutboundResourceadapter() != null && this.getOutboundResourceadapter().validationAsBoolean()) {
            inboundOrOutbound = true;
        }
        if (this.getInboundResourceadapter() != null && this.getInboundResourceadapter().validationAsBoolean() && this.getResourceadapterClass() != null) {
            inboundOrOutbound = true;
        }
        if (!inboundOrOutbound && (XsdString.isNull((XsdString)this.resourceadapterClass) || this.resourceadapterClass.getValue().trim().equals(""))) {
            throw new ValidateException(bundle.invalidMetadataForResourceAdapter());
        }
    }

    public ResourceAdapter1516 merge(MergeableMetadata<?> jmd) throws Exception {
        if (jmd instanceof ResourceAdapter1516Impl) {
            ResourceAdapter1516Impl inputRA = (ResourceAdapter1516Impl)jmd;
            InboundResourceAdapter newInboundResourceadapter = this.inboundResourceadapter == null ? inputRA.inboundResourceadapter : (InboundResourceAdapter)this.inboundResourceadapter.merge((MergeableMetadata)inputRA.inboundResourceadapter);
            OutboundResourceAdapter newOutboundResourceadapter = this.outboundResourceadapter == null ? inputRA.outboundResourceadapter : (OutboundResourceAdapter)this.outboundResourceadapter.merge((MergeableMetadata)inputRA.outboundResourceadapter);
            List newSecurityPermission = MergeUtil.mergeList(this.securityPermissions, inputRA.securityPermissions);
            List newConfigProperties = MergeUtil.mergeConfigList((List)this.configProperties, (List)inputRA.configProperties);
            List newAdminobjects = MergeUtil.mergeList(this.adminobjects, inputRA.adminobjects);
            String newId = this.id == null ? inputRA.id : this.id;
            XsdString newResourceadapterClass = this.resourceadapterClass == null ? inputRA.resourceadapterClass : this.resourceadapterClass;
            return new ResourceAdapter1516Impl(newResourceadapterClass, (List<? extends ConfigProperty>)newConfigProperties, newOutboundResourceadapter, newInboundResourceadapter, (List<AdminObject>)newAdminobjects, (List<SecurityPermission>)newSecurityPermission, newId);
        }
        return this;
    }

    @Override
    public CopyableMetaData copy() {
        return new ResourceAdapter1516Impl((XsdString)CopyUtil.clone((CopyableMetaData)this.resourceadapterClass), (List<? extends ConfigProperty>)CopyUtil.cloneList((List)this.configProperties), (OutboundResourceAdapter)CopyUtil.clone((CopyableMetaData)this.outboundResourceadapter), (InboundResourceAdapter)CopyUtil.clone((CopyableMetaData)this.inboundResourceadapter), (List<AdminObject>)CopyUtil.cloneList(this.adminobjects), (List<SecurityPermission>)CopyUtil.cloneList(this.securityPermissions), CopyUtil.cloneString((String)this.id));
    }
}

