/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jca.common.metadata.ra;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.jboss.jca.common.CommonBundle;
import org.jboss.jca.common.api.metadata.common.TransactionSupportEnum;
import org.jboss.jca.common.api.metadata.ra.AdminObject;
import org.jboss.jca.common.api.metadata.ra.AuthenticationMechanism;
import org.jboss.jca.common.api.metadata.ra.ConfigProperty;
import org.jboss.jca.common.api.metadata.ra.ConnectionDefinition;
import org.jboss.jca.common.api.metadata.ra.Connector;
import org.jboss.jca.common.api.metadata.ra.CredentialInterfaceEnum;
import org.jboss.jca.common.api.metadata.ra.Icon;
import org.jboss.jca.common.api.metadata.ra.InboundResourceAdapter;
import org.jboss.jca.common.api.metadata.ra.LicenseType;
import org.jboss.jca.common.api.metadata.ra.LocalizedXsdString;
import org.jboss.jca.common.api.metadata.ra.MessageListener;
import org.jboss.jca.common.api.metadata.ra.Messageadapter;
import org.jboss.jca.common.api.metadata.ra.OutboundResourceAdapter;
import org.jboss.jca.common.api.metadata.ra.RequiredConfigProperty;
import org.jboss.jca.common.api.metadata.ra.ResourceAdapter;
import org.jboss.jca.common.api.metadata.ra.ResourceAdapter1516;
import org.jboss.jca.common.api.metadata.ra.SecurityPermission;
import org.jboss.jca.common.api.metadata.ra.XsdString;
import org.jboss.jca.common.api.metadata.ra.ra10.Connector10;
import org.jboss.jca.common.api.metadata.ra.ra10.ResourceAdapter10;
import org.jboss.jca.common.api.metadata.ra.ra15.Activationspec15;
import org.jboss.jca.common.api.metadata.ra.ra15.Connector15;
import org.jboss.jca.common.api.metadata.ra.ra16.Activationspec16;
import org.jboss.jca.common.api.metadata.ra.ra16.ConfigProperty16;
import org.jboss.jca.common.api.metadata.ra.ra16.Connector16;
import org.jboss.jca.common.api.metadata.ra.ra17.Connector17;
import org.jboss.jca.common.metadata.AbstractParser;
import org.jboss.jca.common.metadata.MetadataParser;
import org.jboss.jca.common.metadata.ParserException;
import org.jboss.jca.common.metadata.ra.common.AdminObjectImpl;
import org.jboss.jca.common.metadata.ra.common.AuthenticationMechanismImpl;
import org.jboss.jca.common.metadata.ra.common.ConfigPropertyImpl;
import org.jboss.jca.common.metadata.ra.common.ConnectionDefinitionImpl;
import org.jboss.jca.common.metadata.ra.common.InboundResourceAdapterImpl;
import org.jboss.jca.common.metadata.ra.common.MessageAdapterImpl;
import org.jboss.jca.common.metadata.ra.common.MessageListenerImpl;
import org.jboss.jca.common.metadata.ra.common.OutboundResourceAdapterImpl;
import org.jboss.jca.common.metadata.ra.common.ResourceAdapter1516Impl;
import org.jboss.jca.common.metadata.ra.common.SecurityPermissionImpl;
import org.jboss.jca.common.metadata.ra.ra10.Connector10Impl;
import org.jboss.jca.common.metadata.ra.ra10.ResourceAdapter10Impl;
import org.jboss.jca.common.metadata.ra.ra15.Activationspec15Impl;
import org.jboss.jca.common.metadata.ra.ra15.Connector15Impl;
import org.jboss.jca.common.metadata.ra.ra16.Activationspec16Impl;
import org.jboss.jca.common.metadata.ra.ra16.ConfigProperty16Impl;
import org.jboss.jca.common.metadata.ra.ra16.Connector16Impl;
import org.jboss.jca.common.metadata.ra.ra17.Connector17Impl;
import org.jboss.logging.Messages;

public class RaParser
extends AbstractParser
implements MetadataParser<Connector> {
    private static CommonBundle bundle = (CommonBundle)Messages.getBundle(CommonBundle.class);

    @Override
    public Connector parse(InputStream xmlInputStream) throws Exception {
        XMLStreamReader reader = null;
        XMLInputFactory inputFactory = XMLInputFactory.newInstance();
        inputFactory.setProperty("javax.xml.stream.supportDTD", Boolean.FALSE);
        reader = inputFactory.createXMLStreamReader(xmlInputStream);
        return this.parse(reader);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Connector parse(XMLStreamReader reader) throws Exception {
        Connector connector = null;
        try {
            int iterate;
            try {
                iterate = reader.nextTag();
            }
            catch (XMLStreamException e) {
                iterate = reader.nextTag();
            }
            switch (iterate) {
                case 2: {
                    return connector;
                }
                case 1: {
                    if ("1.7".equals(reader.getAttributeValue(null, "version"))) {
                        switch (Tag.forName(reader.getLocalName())) {
                            case CONNECTOR: {
                                connector = this.parseConnector17(reader);
                                return connector;
                            }
                        }
                        throw new ParserException(bundle.unexpectedElement(reader.getLocalName()));
                    }
                    if ("1.6".equals(reader.getAttributeValue(null, "version"))) {
                        switch (Tag.forName(reader.getLocalName())) {
                            case CONNECTOR: {
                                connector = this.parseConnector16(reader);
                                return connector;
                            }
                        }
                        throw new ParserException(bundle.unexpectedElement(reader.getLocalName()));
                    }
                    if ("1.5".equals(reader.getAttributeValue(null, "version"))) {
                        switch (Tag.forName(reader.getLocalName())) {
                            case CONNECTOR: {
                                connector = this.parseConnector15(reader);
                                return connector;
                            }
                        }
                        throw new ParserException(bundle.unexpectedElement(reader.getLocalName()));
                    }
                    switch (Tag.forName(reader.getLocalName())) {
                        case CONNECTOR: {
                            connector = this.parseConnector10(reader);
                            return connector;
                        }
                    }
                    throw new ParserException(bundle.unexpectedElement(reader.getLocalName()));
                }
                default: {
                    throw new IllegalStateException();
                }
            }
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
    }

    private Connector parseConnector10(XMLStreamReader reader) throws XMLStreamException, ParserException {
        LicenseType license = null;
        String id = reader.getAttributeValue(null, Connector10.Attribute.ID.getLocalName());
        ArrayList<Icon> icon = new ArrayList<Icon>();
        ArrayList<LocalizedXsdString> description = new ArrayList<LocalizedXsdString>();
        XsdString eisType = XsdString.NULL_XSDSTRING;
        ResourceAdapter10 resourceadapter = null;
        XsdString vendorName = XsdString.NULL_XSDSTRING;
        ArrayList<LocalizedXsdString> displayName = new ArrayList<LocalizedXsdString>();
        XsdString resourceadapterVersion = XsdString.NULL_XSDSTRING;
        XsdString specVersion = XsdString.NULL_XSDSTRING;
        while (reader.hasNext()) {
            block0 : switch (reader.nextTag()) {
                case 2: {
                    if (Tag.forName(reader.getLocalName()) == Tag.CONNECTOR) {
                        icon.trimToSize();
                        description.trimToSize();
                        for (Icon i : icon) {
                            i.setLang(null);
                        }
                        for (LocalizedXsdString d : description) {
                            d.setLang(null);
                        }
                        for (LocalizedXsdString n : displayName) {
                            n.setLang(null);
                        }
                        return new Connector10Impl(vendorName, eisType, resourceadapterVersion, license, (ResourceAdapter)resourceadapter, description, displayName, icon, id, specVersion);
                    }
                    if (Connector10.Tag.forName((String)reader.getLocalName()) != Connector10.Tag.UNKNOWN) break;
                    throw new ParserException(bundle.unexpectedEndTag(reader.getLocalName()));
                }
                case 1: {
                    switch (Connector10.Tag.forName((String)reader.getLocalName())) {
                        case VENDOR_NAME: {
                            vendorName = this.elementAsXsdString(reader);
                            break block0;
                        }
                        case EIS_TYPE: {
                            eisType = this.elementAsXsdString(reader);
                            break block0;
                        }
                        case LICENSE: {
                            license = this.parseLicense(reader);
                            break block0;
                        }
                        case VERSION: {
                            resourceadapterVersion = this.elementAsXsdString(reader);
                            break block0;
                        }
                        case RESOURCEADAPTER: {
                            resourceadapter = this.parseResourceAdapter10(reader);
                            break block0;
                        }
                        case DESCRIPTION: {
                            if (description.size() > 0) {
                                throw new ParserException(bundle.unexpectedElement(reader.getLocalName()));
                            }
                            description.add(this.elementAsLocalizedXsdString(reader));
                            break block0;
                        }
                        case DISPLAY_NAME: {
                            if (displayName.size() > 0) {
                                throw new ParserException(bundle.unexpectedElement(reader.getLocalName()));
                            }
                            displayName.add(this.elementAsLocalizedXsdString(reader));
                            break block0;
                        }
                        case ICON: {
                            icon.add(this.parseIcon(reader));
                            break block0;
                        }
                        case SPEC_VERSION: {
                            specVersion = this.elementAsXsdString(reader);
                            break block0;
                        }
                    }
                    throw new ParserException(bundle.unexpectedElement(reader.getLocalName()));
                }
            }
        }
        throw new ParserException(bundle.unexpectedEndOfDocument());
    }

    private Connector parseConnector15(XMLStreamReader reader) throws XMLStreamException, ParserException {
        LicenseType license = null;
        String id = reader.getAttributeValue(null, Connector15.Attribute.ID.getLocalName());
        XsdString eisType = XsdString.NULL_XSDSTRING;
        ResourceAdapter1516 resourceadapter = null;
        XsdString vendorName = XsdString.NULL_XSDSTRING;
        XsdString resourceadapterVersion = XsdString.NULL_XSDSTRING;
        ArrayList<Icon> icon = new ArrayList<Icon>();
        ArrayList<LocalizedXsdString> description = new ArrayList<LocalizedXsdString>();
        ArrayList<LocalizedXsdString> displayName = new ArrayList<LocalizedXsdString>();
        while (reader.hasNext()) {
            block0 : switch (reader.nextTag()) {
                case 2: {
                    if (Tag.forName(reader.getLocalName()) == Tag.CONNECTOR) {
                        return new Connector15Impl(vendorName, eisType, resourceadapterVersion, license, resourceadapter, description, displayName, icon, id);
                    }
                    if (Connector15.Tag.forName((String)reader.getLocalName()) != Connector15.Tag.UNKNOWN) break;
                    throw new ParserException(bundle.unexpectedEndTag(reader.getLocalName()));
                }
                case 1: {
                    switch (Connector15.Tag.forName((String)reader.getLocalName())) {
                        case VENDOR_NAME: {
                            vendorName = this.elementAsXsdString(reader);
                            break block0;
                        }
                        case EIS_TYPE: {
                            eisType = this.elementAsXsdString(reader);
                            break block0;
                        }
                        case LICENSE: {
                            license = this.parseLicense(reader);
                            break block0;
                        }
                        case RESOURCEADPTER_VERSION: {
                            resourceadapterVersion = this.elementAsXsdString(reader);
                            break block0;
                        }
                        case RESOURCEADAPTER: {
                            resourceadapter = this.parseResourceAdapter(reader);
                            break block0;
                        }
                        case DESCRIPTION: {
                            description.add(this.elementAsLocalizedXsdString(reader));
                            break block0;
                        }
                        case DISPLAY_NAME: {
                            displayName.add(this.elementAsLocalizedXsdString(reader));
                            break block0;
                        }
                        case ICON: {
                            icon.add(this.parseIcon(reader));
                            break block0;
                        }
                    }
                    throw new ParserException(bundle.unexpectedElement(reader.getLocalName()));
                }
            }
        }
        throw new ParserException(bundle.unexpectedEndOfDocument());
    }

    private Connector parseConnector16(XMLStreamReader reader) throws XMLStreamException, ParserException {
        boolean metadataComplete = Boolean.valueOf(reader.getAttributeValue(null, Connector16.Attribute.METADATA_COMPLETE.getLocalName()));
        LicenseType license = null;
        String id = reader.getAttributeValue(null, Connector16.Attribute.ID.getLocalName());
        ArrayList<Icon> icon = new ArrayList<Icon>();
        ArrayList<LocalizedXsdString> description = new ArrayList<LocalizedXsdString>();
        ArrayList<LocalizedXsdString> displayName = new ArrayList<LocalizedXsdString>();
        XsdString eisType = XsdString.NULL_XSDSTRING;
        ResourceAdapter1516 resourceadapter = null;
        XsdString vendorName = XsdString.NULL_XSDSTRING;
        XsdString moduleName = null;
        ArrayList<XsdString> requiredWorkContext = new ArrayList<XsdString>();
        XsdString resourceadapterVersion = XsdString.NULL_XSDSTRING;
        while (reader.hasNext()) {
            block0 : switch (reader.nextTag()) {
                case 2: {
                    if (Tag.forName(reader.getLocalName()) == Tag.CONNECTOR) {
                        icon.trimToSize();
                        description.trimToSize();
                        displayName.trimToSize();
                        requiredWorkContext.trimToSize();
                        return new Connector16Impl(moduleName, vendorName, eisType, resourceadapterVersion, license, resourceadapter, requiredWorkContext, metadataComplete, description, displayName, icon, id);
                    }
                    if (Connector16.Tag.forName((String)reader.getLocalName()) != Connector16.Tag.UNKNOWN) break;
                    throw new ParserException(bundle.unexpectedEndTag(reader.getLocalName()));
                }
                case 1: {
                    switch (Connector16.Tag.forName((String)reader.getLocalName())) {
                        case MODULE_NAME: {
                            moduleName = this.elementAsXsdString(reader);
                            break block0;
                        }
                        case VENDOR_NAME: {
                            vendorName = this.elementAsXsdString(reader);
                            break block0;
                        }
                        case EIS_TYPE: {
                            eisType = this.elementAsXsdString(reader);
                            break block0;
                        }
                        case LICENSE: {
                            license = this.parseLicense(reader);
                            break block0;
                        }
                        case RESOURCEADPTER_VERSION: {
                            resourceadapterVersion = this.elementAsXsdString(reader);
                            break block0;
                        }
                        case RESOURCEADAPTER: {
                            resourceadapter = this.parseResourceAdapter(reader);
                            break block0;
                        }
                        case REQUIRED_WORK_CONTEXT: {
                            requiredWorkContext.add(this.elementAsXsdString(reader));
                            break block0;
                        }
                        case DESCRIPTION: {
                            description.add(this.elementAsLocalizedXsdString(reader));
                            break block0;
                        }
                        case DISPLAY_NAME: {
                            displayName.add(this.elementAsLocalizedXsdString(reader));
                            break block0;
                        }
                        case ICON: {
                            icon.add(this.parseIcon(reader));
                            break block0;
                        }
                    }
                    throw new ParserException(bundle.unexpectedElement(reader.getLocalName()));
                }
            }
        }
        throw new ParserException(bundle.unexpectedEndOfDocument());
    }

    private Connector parseConnector17(XMLStreamReader reader) throws XMLStreamException, ParserException {
        boolean metadataComplete = Boolean.valueOf(reader.getAttributeValue(null, Connector17.Attribute.METADATA_COMPLETE.getLocalName()));
        LicenseType license = null;
        String id = reader.getAttributeValue(null, Connector17.Attribute.ID.getLocalName());
        ArrayList<Icon> icon = new ArrayList<Icon>();
        ArrayList<LocalizedXsdString> description = new ArrayList<LocalizedXsdString>();
        ArrayList<LocalizedXsdString> displayName = new ArrayList<LocalizedXsdString>();
        XsdString eisType = XsdString.NULL_XSDSTRING;
        ResourceAdapter1516 resourceadapter = null;
        XsdString vendorName = XsdString.NULL_XSDSTRING;
        XsdString moduleName = null;
        ArrayList<XsdString> requiredWorkContext = new ArrayList<XsdString>();
        XsdString resourceadapterVersion = XsdString.NULL_XSDSTRING;
        while (reader.hasNext()) {
            block0 : switch (reader.nextTag()) {
                case 2: {
                    if (Tag.forName(reader.getLocalName()) == Tag.CONNECTOR) {
                        icon.trimToSize();
                        description.trimToSize();
                        displayName.trimToSize();
                        requiredWorkContext.trimToSize();
                        return new Connector17Impl(moduleName, vendorName, eisType, resourceadapterVersion, license, resourceadapter, requiredWorkContext, metadataComplete, description, displayName, icon, id);
                    }
                    if (Connector17.Tag.forName((String)reader.getLocalName()) != Connector17.Tag.UNKNOWN) break;
                    throw new ParserException(bundle.unexpectedEndTag(reader.getLocalName()));
                }
                case 1: {
                    switch (Connector17.Tag.forName((String)reader.getLocalName())) {
                        case MODULE_NAME: {
                            moduleName = this.elementAsXsdString(reader);
                            break block0;
                        }
                        case VENDOR_NAME: {
                            vendorName = this.elementAsXsdString(reader);
                            break block0;
                        }
                        case EIS_TYPE: {
                            eisType = this.elementAsXsdString(reader);
                            break block0;
                        }
                        case LICENSE: {
                            license = this.parseLicense(reader);
                            break block0;
                        }
                        case RESOURCEADPTER_VERSION: {
                            resourceadapterVersion = this.elementAsXsdString(reader);
                            break block0;
                        }
                        case RESOURCEADAPTER: {
                            resourceadapter = this.parseResourceAdapter(reader);
                            break block0;
                        }
                        case REQUIRED_WORK_CONTEXT: {
                            requiredWorkContext.add(this.elementAsXsdString(reader));
                            break block0;
                        }
                        case DESCRIPTION: {
                            description.add(this.elementAsLocalizedXsdString(reader));
                            break block0;
                        }
                        case DISPLAY_NAME: {
                            displayName.add(this.elementAsLocalizedXsdString(reader));
                            break block0;
                        }
                        case ICON: {
                            icon.add(this.parseIcon(reader));
                            break block0;
                        }
                    }
                    throw new ParserException(bundle.unexpectedElement(reader.getLocalName()));
                }
            }
        }
        throw new ParserException(bundle.unexpectedEndOfDocument());
    }

    private Icon parseIcon(XMLStreamReader reader) throws XMLStreamException, ParserException {
        XsdString largeIcon = null;
        XsdString smallIcon = null;
        String id = reader.getAttributeValue(null, Icon.Attribute.ID.getLocalName());
        String lang = reader.getAttributeValue(null, Icon.Attribute.LANG.getLocalName());
        while (reader.hasNext()) {
            block0 : switch (reader.nextTag()) {
                case 2: {
                    if (Connector16.Tag.forName((String)reader.getLocalName()) == Connector16.Tag.ICON) {
                        return new Icon(smallIcon, largeIcon, lang, id);
                    }
                    if (Icon.Tag.forName((String)reader.getLocalName()) != Icon.Tag.UNKNOWN) break;
                    throw new ParserException(bundle.unexpectedEndTag(reader.getLocalName()));
                }
                case 1: {
                    switch (Icon.Tag.forName((String)reader.getLocalName())) {
                        case SMALL_ICON: {
                            smallIcon = this.elementAsXsdString(reader);
                            break block0;
                        }
                        case LARGE_ICON: {
                            largeIcon = this.elementAsXsdString(reader);
                            break block0;
                        }
                    }
                    throw new ParserException(bundle.unexpectedElement(reader.getLocalName()));
                }
            }
        }
        throw new ParserException(bundle.unexpectedEndOfDocument());
    }

    private ResourceAdapter1516 parseResourceAdapter(XMLStreamReader reader) throws XMLStreamException, ParserException {
        ArrayList<ConfigProperty> configProperty = new ArrayList<ConfigProperty>();
        XsdString resourceadapterClass = null;
        OutboundResourceAdapter outboundResourceadapter = null;
        ArrayList<SecurityPermission> securityPermission = new ArrayList<SecurityPermission>();
        InboundResourceAdapter inboundResourceadapter = null;
        ArrayList<AdminObject> adminobject = new ArrayList<AdminObject>();
        String id = reader.getAttributeValue(null, ResourceAdapter1516.Attribute.ID.getLocalName());
        while (reader.hasNext()) {
            block0 : switch (reader.nextTag()) {
                case 2: {
                    if (Connector16.Tag.forName((String)reader.getLocalName()) == Connector16.Tag.RESOURCEADAPTER) {
                        configProperty.trimToSize();
                        securityPermission.trimToSize();
                        adminobject.trimToSize();
                        return new ResourceAdapter1516Impl(resourceadapterClass, configProperty, outboundResourceadapter, inboundResourceadapter, adminobject, securityPermission, id);
                    }
                    if (ResourceAdapter1516.Tag.forName((String)reader.getLocalName()) != ResourceAdapter1516.Tag.UNKNOWN) break;
                    throw new ParserException(bundle.unexpectedEndTag(reader.getLocalName()));
                }
                case 1: {
                    switch (ResourceAdapter1516.Tag.forName((String)reader.getLocalName())) {
                        case RESOURCEADAPTER_CLASS: {
                            resourceadapterClass = this.elementAsXsdString(reader);
                            break block0;
                        }
                        case CONFIG_PROPERTY: {
                            configProperty.add(this.parseConfigProperty(reader));
                            break block0;
                        }
                        case OUTBOUND_RESOURCEADAPTER: {
                            outboundResourceadapter = this.parseOutboundResourceadapter(reader);
                            break block0;
                        }
                        case INBOUND_RESOURCEADAPTER: {
                            inboundResourceadapter = this.parseInboundResourceadapter(reader);
                            break block0;
                        }
                        case ADMINOBJECT: {
                            adminobject.add(this.parseAdminObject(reader));
                            break block0;
                        }
                        case SECURITY_PERMISSION: {
                            securityPermission.add(this.parseSecurityPermission(reader));
                            break block0;
                        }
                    }
                    throw new ParserException(bundle.unexpectedElement(reader.getLocalName()));
                }
            }
        }
        throw new ParserException(bundle.unexpectedEndOfDocument());
    }

    private ResourceAdapter10 parseResourceAdapter10(XMLStreamReader reader) throws XMLStreamException, ParserException {
        XsdString managedConnectionFactoryClass = XsdString.NULL_XSDSTRING;
        XsdString connectionFactoryInterface = XsdString.NULL_XSDSTRING;
        XsdString connectionFactoryImplClass = XsdString.NULL_XSDSTRING;
        XsdString connectionInterface = XsdString.NULL_XSDSTRING;
        XsdString connectionImplClass = XsdString.NULL_XSDSTRING;
        TransactionSupportEnum transactionSupport = null;
        ArrayList<AuthenticationMechanism> authenticationMechanism = new ArrayList<AuthenticationMechanism>();
        ArrayList<ConfigProperty> configProperties = new ArrayList<ConfigProperty>();
        boolean reauthenticationSupport = false;
        ArrayList<SecurityPermission> securityPermission = new ArrayList<SecurityPermission>();
        String id = reader.getAttributeValue(null, ResourceAdapter1516.Attribute.ID.getLocalName());
        String rsId = null;
        String tsId = null;
        while (reader.hasNext()) {
            block0 : switch (reader.nextTag()) {
                case 2: {
                    if (Connector10.Tag.forName((String)reader.getLocalName()) == Connector10.Tag.RESOURCEADAPTER) {
                        authenticationMechanism.trimToSize();
                        configProperties.trimToSize();
                        securityPermission.trimToSize();
                        return new ResourceAdapter10Impl(managedConnectionFactoryClass, connectionFactoryInterface, connectionFactoryImplClass, connectionInterface, connectionImplClass, transactionSupport, authenticationMechanism, configProperties, reauthenticationSupport, securityPermission, id, tsId, rsId);
                    }
                    if (ResourceAdapter10.Tag.forName((String)reader.getLocalName()) != ResourceAdapter10.Tag.UNKNOWN) break;
                    throw new ParserException(bundle.unexpectedEndTag(reader.getLocalName()));
                }
                case 1: {
                    switch (ResourceAdapter10.Tag.forName((String)reader.getLocalName())) {
                        case CONFIG_PROPERTY: {
                            configProperties.add(this.parseConfigProperty(reader));
                            break block0;
                        }
                        case AUTHENTICATION_MECHANISM: {
                            authenticationMechanism.add(this.parseAuthenticationMechanism(reader));
                            break block0;
                        }
                        case MANAGEDCONNECTIONFACTORY_CLASS: {
                            managedConnectionFactoryClass = this.elementAsXsdString(reader);
                            break block0;
                        }
                        case CONNECTION_INTERFACE: {
                            connectionInterface = this.elementAsXsdString(reader);
                            break block0;
                        }
                        case CONNECTION_IMPL_CLASS: {
                            connectionImplClass = this.elementAsXsdString(reader);
                            break block0;
                        }
                        case CONNECTIONFACTORY_INTERFACE: {
                            connectionFactoryInterface = this.elementAsXsdString(reader);
                            break block0;
                        }
                        case CONNECTIONFACTORY_IMPL_CLASS: {
                            connectionFactoryImplClass = this.elementAsXsdString(reader);
                            break block0;
                        }
                        case REAUTHENTICATION_SUPPORT: {
                            rsId = reader.getAttributeValue(null, "id");
                            reauthenticationSupport = this.elementAsBoolean(reader);
                            break block0;
                        }
                        case SECURITY_PERMISSION: {
                            securityPermission.add(this.parseSecurityPermission(reader));
                            break block0;
                        }
                        case TRANSACTION_SUPPORT: {
                            tsId = reader.getAttributeValue(null, "id");
                            transactionSupport = TransactionSupportEnum.valueOf((String)reader.getElementText().trim());
                            break block0;
                        }
                    }
                    throw new ParserException(bundle.unexpectedElement(reader.getLocalName()));
                }
            }
        }
        throw new ParserException(bundle.unexpectedEndOfDocument());
    }

    private InboundResourceAdapter parseInboundResourceadapter(XMLStreamReader reader) throws XMLStreamException, ParserException {
        Messageadapter messageadapter = null;
        String id = reader.getAttributeValue(null, InboundResourceAdapter.Attribute.ID.getLocalName());
        while (reader.hasNext()) {
            block0 : switch (reader.nextTag()) {
                case 2: {
                    if (ResourceAdapter1516.Tag.forName((String)reader.getLocalName()) == ResourceAdapter1516.Tag.INBOUND_RESOURCEADAPTER) {
                        return new InboundResourceAdapterImpl(messageadapter, id);
                    }
                    if (InboundResourceAdapter.Tag.forName((String)reader.getLocalName()) != InboundResourceAdapter.Tag.UNKNOWN) break;
                    throw new ParserException(bundle.unexpectedEndTag(reader.getLocalName()));
                }
                case 1: {
                    switch (InboundResourceAdapter.Tag.forName((String)reader.getLocalName())) {
                        case MESSAGEADAPTER: {
                            messageadapter = this.parseMessageAdapter(reader);
                            break block0;
                        }
                    }
                    throw new ParserException(bundle.unexpectedElement(reader.getLocalName()));
                }
            }
        }
        throw new ParserException(bundle.unexpectedEndOfDocument());
    }

    private Messageadapter parseMessageAdapter(XMLStreamReader reader) throws XMLStreamException, ParserException {
        ArrayList<MessageListener> messagelistener = new ArrayList<MessageListener>();
        String id = reader.getAttributeValue(null, Messageadapter.Attribute.ID.getLocalName());
        while (reader.hasNext()) {
            block0 : switch (reader.nextTag()) {
                case 2: {
                    if (InboundResourceAdapter.Tag.forName((String)reader.getLocalName()) == InboundResourceAdapter.Tag.MESSAGEADAPTER) {
                        messagelistener.trimToSize();
                        return new MessageAdapterImpl(messagelistener, id);
                    }
                    if (Messageadapter.Tag.forName((String)reader.getLocalName()) != Messageadapter.Tag.UNKNOWN) break;
                    throw new ParserException(bundle.unexpectedEndTag(reader.getLocalName()));
                }
                case 1: {
                    switch (Messageadapter.Tag.forName((String)reader.getLocalName())) {
                        case MESSAGELISTENER: {
                            messagelistener.add(this.parseMessageListener(reader));
                            break block0;
                        }
                    }
                    throw new ParserException(bundle.unexpectedElement(reader.getLocalName()));
                }
            }
        }
        throw new ParserException(bundle.unexpectedEndOfDocument());
    }

    private MessageListener parseMessageListener(XMLStreamReader reader) throws XMLStreamException, ParserException {
        Activationspec15 activationspec = null;
        XsdString messagelistenerType = XsdString.NULL_XSDSTRING;
        String id = reader.getAttributeValue(null, MessageListener.Attribute.ID.getLocalName());
        while (reader.hasNext()) {
            block0 : switch (reader.nextTag()) {
                case 2: {
                    if (Messageadapter.Tag.forName((String)reader.getLocalName()) == Messageadapter.Tag.MESSAGELISTENER) {
                        return new MessageListenerImpl(messagelistenerType, activationspec, id);
                    }
                    if (MessageListener.Tag.forName((String)reader.getLocalName()) != MessageListener.Tag.UNKNOWN) break;
                    throw new ParserException(bundle.unexpectedEndTag(reader.getLocalName()));
                }
                case 1: {
                    switch (MessageListener.Tag.forName((String)reader.getLocalName())) {
                        case MESSAGELISTENER_TYPE: {
                            messagelistenerType = this.elementAsXsdString(reader);
                            break block0;
                        }
                        case ACTIVATIONSPEC: {
                            activationspec = this.parseActivationspec(reader);
                            break block0;
                        }
                    }
                    throw new ParserException(bundle.unexpectedElement(reader.getLocalName()));
                }
            }
        }
        throw new ParserException(bundle.unexpectedEndOfDocument());
    }

    private Activationspec15 parseActivationspec(XMLStreamReader reader) throws XMLStreamException, ParserException {
        ArrayList<RequiredConfigProperty> requiredConfigProperty = new ArrayList<RequiredConfigProperty>();
        XsdString activationspecClass = XsdString.NULL_XSDSTRING;
        ArrayList<ConfigProperty> configProperty = new ArrayList<ConfigProperty>();
        String id = reader.getAttributeValue(null, Activationspec16.Attribute.ID.getLocalName());
        while (reader.hasNext()) {
            block0 : switch (reader.nextTag()) {
                case 2: {
                    if (MessageListener.Tag.forName((String)reader.getLocalName()) == MessageListener.Tag.ACTIVATIONSPEC) {
                        requiredConfigProperty.trimToSize();
                        configProperty.trimToSize();
                        if (configProperty.size() != 0) {
                            return new Activationspec16Impl(activationspecClass, requiredConfigProperty, configProperty, id);
                        }
                        return new Activationspec15Impl(activationspecClass, requiredConfigProperty, id);
                    }
                    if (Activationspec16.Tag.forName((String)reader.getLocalName()) != Activationspec16.Tag.UNKNOWN) break;
                    throw new ParserException(bundle.unexpectedEndTag(reader.getLocalName()));
                }
                case 1: {
                    switch (Activationspec16.Tag.forName((String)reader.getLocalName())) {
                        case ACTIVATIONSPEC_CLASS: {
                            activationspecClass = this.elementAsXsdString(reader);
                            break block0;
                        }
                        case REQUIRED_CONFIG_PROPERTY: {
                            requiredConfigProperty.add(this.parseRequiredConfigProperty(reader));
                            break block0;
                        }
                        case CONFIG_PROPERTY: {
                            configProperty.add(this.parseConfigProperty(reader));
                            break block0;
                        }
                    }
                    throw new ParserException(bundle.unexpectedElement(reader.getLocalName()));
                }
            }
        }
        throw new ParserException(bundle.unexpectedEndOfDocument());
    }

    private RequiredConfigProperty parseRequiredConfigProperty(XMLStreamReader reader) throws XMLStreamException, ParserException {
        XsdString configPropertyName = XsdString.NULL_XSDSTRING;
        ArrayList<LocalizedXsdString> description = new ArrayList<LocalizedXsdString>();
        String id = reader.getAttributeValue(null, RequiredConfigProperty.Attribute.ID.getLocalName());
        while (reader.hasNext()) {
            block0 : switch (reader.nextTag()) {
                case 2: {
                    if (Activationspec16.Tag.forName((String)reader.getLocalName()) == Activationspec16.Tag.REQUIRED_CONFIG_PROPERTY) {
                        description.trimToSize();
                        return new RequiredConfigProperty(description, configPropertyName, id);
                    }
                    if (RequiredConfigProperty.Tag.forName((String)reader.getLocalName()) != RequiredConfigProperty.Tag.UNKNOWN) break;
                    throw new ParserException(bundle.unexpectedEndTag(reader.getLocalName()));
                }
                case 1: {
                    switch (RequiredConfigProperty.Tag.forName((String)reader.getLocalName())) {
                        case DESCRIPTION: {
                            description.add(this.elementAsLocalizedXsdString(reader));
                            break block0;
                        }
                        case CONFIG_PROPERTY_NAME: {
                            configPropertyName = this.elementAsXsdString(reader);
                            break block0;
                        }
                    }
                    throw new ParserException(bundle.unexpectedElement(reader.getLocalName()));
                }
            }
        }
        throw new ParserException(bundle.unexpectedEndOfDocument());
    }

    private OutboundResourceAdapter parseOutboundResourceadapter(XMLStreamReader reader) throws XMLStreamException, ParserException {
        boolean reauthenticationSupport = false;
        TransactionSupportEnum transactionSupport = null;
        ArrayList<ConnectionDefinition> connectionDefinition = new ArrayList<ConnectionDefinition>();
        ArrayList<AuthenticationMechanism> authenticationMechanism = new ArrayList<AuthenticationMechanism>();
        String id = reader.getAttributeValue(null, OutboundResourceAdapter.Attribute.ID.getLocalName());
        String tsId = null;
        String rsId = null;
        while (reader.hasNext()) {
            block0 : switch (reader.nextTag()) {
                case 2: {
                    if (ResourceAdapter1516.Tag.forName((String)reader.getLocalName()) == ResourceAdapter1516.Tag.OUTBOUND_RESOURCEADAPTER) {
                        authenticationMechanism.trimToSize();
                        connectionDefinition.trimToSize();
                        return new OutboundResourceAdapterImpl(connectionDefinition, transactionSupport, authenticationMechanism, reauthenticationSupport, id, tsId, rsId);
                    }
                    if (OutboundResourceAdapter.Tag.forName((String)reader.getLocalName()) != OutboundResourceAdapter.Tag.UNKNOWN) break;
                    throw new ParserException(bundle.unexpectedEndTag(reader.getLocalName()));
                }
                case 1: {
                    switch (OutboundResourceAdapter.Tag.forName((String)reader.getLocalName())) {
                        case CONNECTION_DEFINITION: {
                            connectionDefinition.add(this.parseConncetionDefinition(reader));
                            break block0;
                        }
                        case AUTHENTICATION_MECHANISM: {
                            authenticationMechanism.add(this.parseAuthenticationMechanism(reader));
                            break block0;
                        }
                        case TRANSACTION_SUPPORT: {
                            tsId = reader.getAttributeValue(null, "id");
                            transactionSupport = TransactionSupportEnum.valueOf((String)reader.getElementText().trim());
                            break block0;
                        }
                        case REAUTHENTICATION_SUPPORT: {
                            rsId = reader.getAttributeValue(null, "id");
                            reauthenticationSupport = this.elementAsBoolean(reader);
                            break block0;
                        }
                    }
                    throw new ParserException(bundle.unexpectedElement(reader.getLocalName()));
                }
            }
        }
        throw new ParserException(bundle.unexpectedEndOfDocument());
    }

    private ConnectionDefinition parseConncetionDefinition(XMLStreamReader reader) throws XMLStreamException, ParserException {
        XsdString managedconnectionfactoryClass = XsdString.NULL_XSDSTRING;
        ArrayList<ConfigProperty> configProperty = new ArrayList<ConfigProperty>();
        XsdString connectionImplClass = XsdString.NULL_XSDSTRING;
        XsdString connectionInterface = XsdString.NULL_XSDSTRING;
        XsdString connectionfactoryImplClass = XsdString.NULL_XSDSTRING;
        XsdString connectionfactoryInterface = XsdString.NULL_XSDSTRING;
        String id = reader.getAttributeValue(null, AuthenticationMechanism.Attribute.ID.getLocalName());
        while (reader.hasNext()) {
            block0 : switch (reader.nextTag()) {
                case 2: {
                    if (OutboundResourceAdapter.Tag.forName((String)reader.getLocalName()) == OutboundResourceAdapter.Tag.CONNECTION_DEFINITION) {
                        configProperty.trimToSize();
                        return new ConnectionDefinitionImpl(managedconnectionfactoryClass, configProperty, connectionfactoryInterface, connectionfactoryImplClass, connectionInterface, connectionImplClass, id);
                    }
                    if (ConnectionDefinition.Tag.forName((String)reader.getLocalName()) != ConnectionDefinition.Tag.UNKNOWN) break;
                    throw new ParserException(bundle.unexpectedEndTag(reader.getLocalName()));
                }
                case 1: {
                    switch (ConnectionDefinition.Tag.forName((String)reader.getLocalName())) {
                        case CONFIG_PROPERTY: {
                            configProperty.add(this.parseConfigProperty(reader));
                            break block0;
                        }
                        case MANAGEDCONNECTIONFACTORY_CLASS: {
                            managedconnectionfactoryClass = this.elementAsXsdString(reader);
                            break block0;
                        }
                        case CONNECTIONFACTORY_INTERFACE: {
                            connectionfactoryInterface = this.elementAsXsdString(reader);
                            break block0;
                        }
                        case CONNECTIONFACTORY_IMPL_CLASS: {
                            connectionfactoryImplClass = this.elementAsXsdString(reader);
                            break block0;
                        }
                        case CONNECTION_INTERFACE: {
                            connectionInterface = this.elementAsXsdString(reader);
                            break block0;
                        }
                        case CONNECTION_IMPL_CLASS: {
                            connectionImplClass = this.elementAsXsdString(reader);
                            break block0;
                        }
                    }
                    throw new ParserException(bundle.unexpectedElement(reader.getLocalName()));
                }
            }
        }
        throw new ParserException(bundle.unexpectedEndOfDocument());
    }

    private AuthenticationMechanism parseAuthenticationMechanism(XMLStreamReader reader) throws XMLStreamException, ParserException {
        XsdString authenticationMechanismType = XsdString.NULL_XSDSTRING;
        CredentialInterfaceEnum credentialInterface = null;
        String cIId = null;
        ArrayList<LocalizedXsdString> description = new ArrayList<LocalizedXsdString>();
        String id = reader.getAttributeValue(null, AuthenticationMechanism.Attribute.ID.getLocalName());
        while (reader.hasNext()) {
            block0 : switch (reader.nextTag()) {
                case 2: {
                    if (OutboundResourceAdapter.Tag.forName((String)reader.getLocalName()) == OutboundResourceAdapter.Tag.AUTHENTICATION_MECHANISM) {
                        description.trimToSize();
                        return new AuthenticationMechanismImpl(description, authenticationMechanismType, credentialInterface, id, cIId);
                    }
                    if (AuthenticationMechanism.Tag.forName((String)reader.getLocalName()) != AuthenticationMechanism.Tag.UNKNOWN) break;
                    throw new ParserException(bundle.unexpectedEndTag(reader.getLocalName()));
                }
                case 1: {
                    switch (AuthenticationMechanism.Tag.forName((String)reader.getLocalName())) {
                        case AUTHENTICATION_MECHANISM_TYPE: {
                            authenticationMechanismType = this.elementAsXsdString(reader);
                            break block0;
                        }
                        case CREDENTIAL_INTERFACE: {
                            cIId = reader.getAttributeValue(null, "id");
                            credentialInterface = CredentialInterfaceEnum.forName((String)reader.getElementText().trim());
                            break block0;
                        }
                        case DESCRIPTION: {
                            description.add(this.elementAsLocalizedXsdString(reader));
                            break block0;
                        }
                    }
                    throw new ParserException(bundle.unexpectedElement(reader.getLocalName()));
                }
            }
        }
        throw new ParserException(bundle.unexpectedEndOfDocument());
    }

    private AdminObject parseAdminObject(XMLStreamReader reader) throws XMLStreamException, ParserException {
        ArrayList<ConfigProperty> configProperty = new ArrayList<ConfigProperty>();
        XsdString adminobjectInterface = XsdString.NULL_XSDSTRING;
        XsdString adminobjectClass = XsdString.NULL_XSDSTRING;
        String id = reader.getAttributeValue(null, AdminObject.Attribute.ID.getLocalName());
        while (reader.hasNext()) {
            block0 : switch (reader.nextTag()) {
                case 2: {
                    if (ResourceAdapter1516.Tag.forName((String)reader.getLocalName()) == ResourceAdapter1516.Tag.ADMINOBJECT) {
                        configProperty.trimToSize();
                        return new AdminObjectImpl(adminobjectInterface, adminobjectClass, configProperty, id);
                    }
                    if (AdminObject.Tag.forName((String)reader.getLocalName()) != AdminObject.Tag.UNKNOWN) break;
                    throw new ParserException(bundle.unexpectedEndTag(reader.getLocalName()));
                }
                case 1: {
                    switch (AdminObject.Tag.forName((String)reader.getLocalName())) {
                        case ADMINOBJECT_CLASS: {
                            adminobjectClass = this.elementAsXsdString(reader);
                            break block0;
                        }
                        case ADMINOBJECT_INTERFACE: {
                            adminobjectInterface = this.elementAsXsdString(reader);
                            break block0;
                        }
                        case CONFIG_PROPERTY: {
                            configProperty.add(this.parseConfigProperty(reader));
                            break block0;
                        }
                    }
                    throw new ParserException(bundle.unexpectedElement(reader.getLocalName()));
                }
            }
        }
        throw new ParserException(bundle.unexpectedEndOfDocument());
    }

    private ConfigProperty parseConfigProperty(XMLStreamReader reader) throws XMLStreamException, ParserException {
        ArrayList<LocalizedXsdString> description = new ArrayList<LocalizedXsdString>();
        XsdString configPropertyType = XsdString.NULL_XSDSTRING;
        XsdString configPropertyValue = XsdString.NULL_XSDSTRING;
        Boolean configPropertyIgnore = null;
        XsdString configPropertyName = XsdString.NULL_XSDSTRING;
        Boolean configPropertySupportsDynamicUpdates = null;
        Boolean configPropertyConfidential = null;
        String ignoreId = null;
        String updatesId = null;
        String confidId = null;
        String id = reader.getAttributeValue(null, ConfigProperty16.Attribute.ID.getLocalName());
        while (reader.hasNext()) {
            block0 : switch (reader.nextTag()) {
                case 2: {
                    if (ResourceAdapter1516.Tag.forName((String)reader.getLocalName()) == ResourceAdapter1516.Tag.CONFIG_PROPERTY) {
                        description.trimToSize();
                        if (configPropertyIgnore != null || configPropertySupportsDynamicUpdates != null || configPropertyConfidential != null) {
                            return new ConfigProperty16Impl(description, configPropertyName, configPropertyType, configPropertyValue, configPropertyIgnore, configPropertySupportsDynamicUpdates, configPropertyConfidential, id, null, ignoreId, updatesId, confidId);
                        }
                        return new ConfigPropertyImpl(description, configPropertyName, configPropertyType, configPropertyValue, id);
                    }
                    if (ConfigProperty16.Tag.forName((String)reader.getLocalName()) != ConfigProperty16.Tag.UNKNOWN) break;
                    throw new ParserException(bundle.unexpectedEndTag(reader.getLocalName()));
                }
                case 1: {
                    switch (ConfigProperty16.Tag.forName((String)reader.getLocalName())) {
                        case DESCRIPTION: {
                            description.add(this.elementAsLocalizedXsdString(reader));
                            break block0;
                        }
                        case CONFIG_PROPERTY_NAME: {
                            configPropertyName = this.elementAsXsdString(reader);
                            break block0;
                        }
                        case CONFIG_PROPERTY_TYPE: {
                            configPropertyType = this.elementAsXsdString(reader);
                            break block0;
                        }
                        case CONFIG_PROPERTY_VALUE: {
                            configPropertyValue = this.elementAsXsdString(reader);
                            break block0;
                        }
                        case CONFIG_PROPERTY_IGNORE: {
                            ignoreId = reader.getAttributeValue(null, "id");
                            configPropertyIgnore = this.elementAsBoolean(reader);
                            break block0;
                        }
                        case CONFIG_PROPERTY_CONFIDENTIAL: {
                            confidId = reader.getAttributeValue(null, "id");
                            configPropertyConfidential = this.elementAsBoolean(reader);
                            break block0;
                        }
                        case CONFIG_PROPERTY_SUPPORT_DYNAMIC_UPDATE: {
                            updatesId = reader.getAttributeValue(null, "id");
                            configPropertySupportsDynamicUpdates = this.elementAsBoolean(reader);
                            break block0;
                        }
                    }
                    throw new ParserException(bundle.unexpectedElement(reader.getLocalName()));
                }
            }
        }
        throw new ParserException(bundle.unexpectedEndOfDocument());
    }

    private SecurityPermission parseSecurityPermission(XMLStreamReader reader) throws XMLStreamException, ParserException {
        ArrayList<LocalizedXsdString> description = new ArrayList<LocalizedXsdString>();
        XsdString securityPermissionSpec = XsdString.NULL_XSDSTRING;
        String id = reader.getAttributeValue(null, SecurityPermission.Attribute.ID.getLocalName());
        while (reader.hasNext()) {
            block0 : switch (reader.nextTag()) {
                case 2: {
                    if (ResourceAdapter1516.Tag.forName((String)reader.getLocalName()) == ResourceAdapter1516.Tag.SECURITY_PERMISSION) {
                        description.trimToSize();
                        return new SecurityPermissionImpl(description, securityPermissionSpec, id);
                    }
                    if (SecurityPermission.Tag.forName((String)reader.getLocalName()) != SecurityPermission.Tag.UNKNOWN) break;
                    throw new ParserException(bundle.unexpectedEndTag(reader.getLocalName()));
                }
                case 1: {
                    switch (SecurityPermission.Tag.forName((String)reader.getLocalName())) {
                        case DESCRIPTION: {
                            description.add(this.elementAsLocalizedXsdString(reader));
                            break block0;
                        }
                        case SECURITY_PERMISSION_SPEC: {
                            securityPermissionSpec = this.elementAsXsdString(reader);
                            break block0;
                        }
                    }
                    throw new ParserException(bundle.unexpectedElement(reader.getLocalName()));
                }
            }
        }
        throw new ParserException(bundle.unexpectedEndOfDocument());
    }

    private LicenseType parseLicense(XMLStreamReader reader) throws XMLStreamException, ParserException {
        String id = reader.getAttributeValue(null, LicenseType.Attribute.ID.getLocalName());
        boolean licenseRequired = false;
        String lrid = null;
        ArrayList<LocalizedXsdString> description = new ArrayList<LocalizedXsdString>();
        while (reader.hasNext()) {
            block0 : switch (reader.nextTag()) {
                case 2: {
                    if (Connector16.Tag.forName((String)reader.getLocalName()) == Connector16.Tag.LICENSE) {
                        description.trimToSize();
                        return new LicenseType(description, licenseRequired, id, lrid);
                    }
                    if (LicenseType.Tag.forName((String)reader.getLocalName()) != LicenseType.Tag.UNKNOWN) break;
                    throw new ParserException(bundle.unexpectedEndTag(reader.getLocalName()));
                }
                case 1: {
                    switch (LicenseType.Tag.forName((String)reader.getLocalName())) {
                        case LICENSE_REQUIRED: {
                            lrid = reader.getAttributeValue(null, "id");
                            licenseRequired = this.elementAsBoolean(reader);
                            break block0;
                        }
                        case DESCRIPTION: {
                            description.add(this.elementAsLocalizedXsdString(reader));
                            break block0;
                        }
                    }
                    throw new ParserException(bundle.unexpectedElement(reader.getLocalName()));
                }
            }
        }
        throw new ParserException(bundle.unexpectedEndOfDocument());
    }

    private XsdString elementAsXsdString(XMLStreamReader reader) throws XMLStreamException {
        String id = reader.getAttributeValue(null, "id");
        return new XsdString(reader.getElementText().trim(), id, reader.getLocalName());
    }

    private LocalizedXsdString elementAsLocalizedXsdString(XMLStreamReader reader) throws XMLStreamException {
        String id = reader.getAttributeValue(null, "id");
        String lang = reader.getAttributeValue(null, "lang");
        return new LocalizedXsdString(reader.getElementText().trim(), id, lang, reader.getLocalName());
    }

    public static enum Tag {
        UNKNOWN(null),
        CONNECTOR("connector");

        private String name;
        private static final Map<String, Tag> MAP;

        private Tag(String name) {
            this.name = name;
        }

        public String getLocalName() {
            return this.name;
        }

        Tag value(String v) {
            this.name = v;
            return this;
        }

        public static Tag forName(String localName) {
            Tag element = MAP.get(localName);
            return element == null ? UNKNOWN.value(localName) : element;
        }

        static {
            HashMap<String, Tag> map = new HashMap<String, Tag>();
            for (Tag element : Tag.values()) {
                String name = element.getLocalName();
                if (name == null) continue;
                map.put(name, element);
            }
            MAP = map;
        }
    }
}

