/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jca.core.workmanager;

import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.resource.spi.ResourceAdapter;
import javax.resource.spi.ResourceAdapterAssociation;
import javax.resource.spi.work.ExecutionContext;
import javax.resource.spi.work.HintsContext;
import javax.resource.spi.work.SecurityContext;
import javax.resource.spi.work.TransactionContext;
import javax.resource.spi.work.Work;
import javax.resource.spi.work.WorkCompletedException;
import javax.resource.spi.work.WorkContext;
import javax.resource.spi.work.WorkContextLifecycleListener;
import javax.resource.spi.work.WorkContextProvider;
import javax.resource.spi.work.WorkEvent;
import javax.resource.spi.work.WorkException;
import javax.resource.spi.work.WorkListener;
import javax.resource.spi.work.WorkRejectedException;
import org.jboss.jca.core.CoreBundle;
import org.jboss.jca.core.CoreLogger;
import org.jboss.jca.core.api.workmanager.WorkManager;
import org.jboss.jca.core.spi.security.Callback;
import org.jboss.jca.core.spi.transaction.xa.XATerminator;
import org.jboss.jca.core.workmanager.ClassUtil;
import org.jboss.jca.core.workmanager.WorkWrapper;
import org.jboss.logging.Logger;
import org.jboss.logging.Messages;
import org.jboss.threads.BlockingExecutor;
import org.jboss.threads.ExecutionTimedOutException;

public class WorkManagerImpl
implements WorkManager {
    private static CoreLogger log = (CoreLogger)Logger.getMessageLogger(CoreLogger.class, (String)WorkManagerImpl.class.getName());
    private static boolean trace = log.isTraceEnabled();
    private static CoreBundle bundle = (CoreBundle)Messages.getBundle(CoreBundle.class);
    private static final String RUN_METHOD_NAME = "run";
    private static final String RELEASE_METHOD_NAME = "release";
    private static final Set<Class<? extends WorkContext>> SUPPORTED_WORK_CONTEXT_CLASSES = new HashSet<Class<? extends WorkContext>>(3);
    private String id = null;
    private String name = null;
    private boolean specCompliant = true;
    private BlockingExecutor shortRunningExecutor;
    private BlockingExecutor longRunningExecutor;
    private XATerminator xaTerminator;
    private Set<String> validatedWork = new HashSet<String>();
    private Callback callbackSecurity;
    private ResourceAdapter resourceAdapter = null;
    private AtomicBoolean shutdown = new AtomicBoolean(false);
    private Set<WorkWrapper> activeWorkWrappers = new HashSet<WorkWrapper>();

    public String getId() {
        if (this.id == null) {
            return this.name;
        }
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String v) {
        this.name = v;
    }

    public ResourceAdapter getResourceAdapter() {
        return this.resourceAdapter;
    }

    public void setResourceAdapter(ResourceAdapter v) {
        this.resourceAdapter = v;
    }

    public BlockingExecutor getShortRunningThreadPool() {
        return this.shortRunningExecutor;
    }

    public void setShortRunningThreadPool(BlockingExecutor executor) {
        this.shortRunningExecutor = executor;
    }

    public BlockingExecutor getLongRunningThreadPool() {
        return this.longRunningExecutor;
    }

    public void setLongRunningThreadPool(BlockingExecutor executor) {
        this.longRunningExecutor = executor;
    }

    public XATerminator getXATerminator() {
        return this.xaTerminator;
    }

    public void setXATerminator(XATerminator xaTerminator) {
        this.xaTerminator = xaTerminator;
    }

    public boolean isSpecCompliant() {
        return this.specCompliant;
    }

    public void setSpecCompliant(boolean v) {
        this.specCompliant = v;
    }

    public Callback getCallbackSecurity() {
        return this.callbackSecurity;
    }

    public void setCallbackSecurity(Callback v) {
        this.callbackSecurity = v;
    }

    public WorkManager clone() throws CloneNotSupportedException {
        WorkManager wm = (WorkManager)super.clone();
        wm.setName(this.getName());
        wm.setShortRunningThreadPool(this.getShortRunningThreadPool());
        wm.setLongRunningThreadPool(this.getLongRunningThreadPool());
        wm.setXATerminator(this.getXATerminator());
        wm.setSpecCompliant(this.isSpecCompliant());
        wm.setCallbackSecurity(this.getCallbackSecurity());
        return wm;
    }

    public void doWork(Work work) throws WorkException {
        this.doWork(work, Long.MAX_VALUE, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doWork(Work work, long startTimeout, ExecutionContext execContext, WorkListener workListener) throws WorkException {
        if (trace) {
            log.tracef("doWork(%s, %s, %s, %s)", new Object[]{work, startTimeout, execContext, workListener});
        }
        if (this.shutdown.get()) {
            throw new WorkRejectedException(bundle.workmanagerShutdown());
        }
        WorkException exception = null;
        WorkWrapper wrapper = null;
        try {
            if (work == null) {
                throw new WorkRejectedException(bundle.workIsNull());
            }
            if (startTimeout < 0L) {
                throw new WorkRejectedException(bundle.startTimeoutIsNegative(startTimeout));
            }
            this.checkAndVerifyWork(work, execContext);
            if (workListener != null) {
                WorkEvent event = new WorkEvent((Object)this, 1, work, null);
                workListener.workAccepted(event);
            }
            if (execContext == null) {
                execContext = new ExecutionContext();
            }
            CountDownLatch completedLatch = new CountDownLatch(1);
            wrapper = new WorkWrapper(this, work, execContext, workListener, null, completedLatch, System.currentTimeMillis());
            this.setup(wrapper, workListener);
            BlockingExecutor executor = this.getExecutor(work);
            if (startTimeout == Long.MAX_VALUE) {
                executor.executeBlocking((Runnable)wrapper);
            } else {
                executor.executeBlocking((Runnable)wrapper, startTimeout, TimeUnit.MILLISECONDS);
            }
            completedLatch.await();
        }
        catch (ExecutionTimedOutException etoe) {
            exception = new WorkRejectedException((Throwable)etoe);
            exception.setErrorCode("1");
        }
        catch (RejectedExecutionException ree) {
            exception = new WorkRejectedException((Throwable)ree);
        }
        catch (WorkCompletedException wce) {
            if (wrapper != null) {
                wrapper.setWorkException((WorkException)((Object)wce));
            }
        }
        catch (WorkException we) {
            exception = we;
        }
        catch (InterruptedException ie) {
            Thread.currentThread().interrupt();
            exception = new WorkRejectedException(bundle.interruptedWhileRequestingPermit());
        }
        finally {
            if (exception != null) {
                if (workListener != null) {
                    WorkEvent event = new WorkEvent((Object)this, 2, work, exception);
                    workListener.workRejected(event);
                }
                if (trace) {
                    log.tracef("Exception %s for %s", (Object)exception, this);
                }
                throw exception;
            }
            if (wrapper != null) {
                this.checkWorkCompletionException(wrapper);
            }
        }
    }

    public long startWork(Work work) throws WorkException {
        return this.startWork(work, Long.MAX_VALUE, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long startWork(Work work, long startTimeout, ExecutionContext execContext, WorkListener workListener) throws WorkException {
        log.tracef("startWork(%s, %s, %s, %s)", new Object[]{work, startTimeout, execContext, workListener});
        if (this.shutdown.get()) {
            throw new WorkRejectedException(bundle.workmanagerShutdown());
        }
        WorkException exception = null;
        WorkWrapper wrapper = null;
        try {
            if (work == null) {
                throw new WorkRejectedException(bundle.workIsNull());
            }
            if (startTimeout < 0L) {
                throw new WorkRejectedException(bundle.startTimeoutIsNegative(startTimeout));
            }
            long started = System.currentTimeMillis();
            this.checkAndVerifyWork(work, execContext);
            if (workListener != null) {
                WorkEvent event = new WorkEvent((Object)this, 1, work, null);
                workListener.workAccepted(event);
            }
            if (execContext == null) {
                execContext = new ExecutionContext();
            }
            CountDownLatch startedLatch = new CountDownLatch(1);
            wrapper = new WorkWrapper(this, work, execContext, workListener, startedLatch, null, System.currentTimeMillis());
            this.setup(wrapper, workListener);
            BlockingExecutor executor = this.getExecutor(work);
            if (startTimeout == Long.MAX_VALUE) {
                executor.executeBlocking((Runnable)wrapper);
            } else {
                executor.executeBlocking((Runnable)wrapper, startTimeout, TimeUnit.MILLISECONDS);
            }
            startedLatch.await();
            long l = System.currentTimeMillis() - started;
            return l;
        }
        catch (ExecutionTimedOutException etoe) {
            exception = new WorkRejectedException((Throwable)etoe);
            exception.setErrorCode("1");
        }
        catch (RejectedExecutionException ree) {
            exception = new WorkRejectedException((Throwable)ree);
        }
        catch (WorkCompletedException wce) {
            if (wrapper != null) {
                wrapper.setWorkException((WorkException)((Object)wce));
            }
        }
        catch (WorkException we) {
            exception = we;
        }
        catch (InterruptedException ie) {
            Thread.currentThread().interrupt();
            exception = new WorkRejectedException(bundle.interruptedWhileRequestingPermit());
        }
        finally {
            if (exception != null) {
                if (workListener != null) {
                    WorkEvent event = new WorkEvent((Object)this, 2, work, exception);
                    workListener.workRejected(event);
                }
                if (trace) {
                    log.tracef("Exception %s for %s", (Object)exception, this);
                }
                throw exception;
            }
            if (wrapper != null) {
                this.checkWorkCompletionException(wrapper);
            }
        }
        return -1L;
    }

    public void scheduleWork(Work work) throws WorkException {
        this.scheduleWork(work, Long.MAX_VALUE, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void scheduleWork(Work work, long startTimeout, ExecutionContext execContext, WorkListener workListener) throws WorkException {
        log.tracef("scheduleWork(%s, %s, %s, %s)", new Object[]{work, startTimeout, execContext, workListener});
        if (this.shutdown.get()) {
            throw new WorkRejectedException(bundle.workmanagerShutdown());
        }
        WorkException exception = null;
        WorkWrapper wrapper = null;
        try {
            if (work == null) {
                throw new WorkRejectedException(bundle.workIsNull());
            }
            if (startTimeout < 0L) {
                throw new WorkRejectedException(bundle.startTimeoutIsNegative(startTimeout));
            }
            this.checkAndVerifyWork(work, execContext);
            if (workListener != null) {
                WorkEvent event = new WorkEvent((Object)this, 1, work, null);
                workListener.workAccepted(event);
            }
            if (execContext == null) {
                execContext = new ExecutionContext();
            }
            wrapper = new WorkWrapper(this, work, execContext, workListener, null, null, System.currentTimeMillis());
            this.setup(wrapper, workListener);
            BlockingExecutor executor = this.getExecutor(work);
            if (startTimeout == Long.MAX_VALUE) {
                executor.executeBlocking((Runnable)wrapper);
            } else {
                executor.executeBlocking((Runnable)wrapper, startTimeout, TimeUnit.MILLISECONDS);
            }
        }
        catch (ExecutionTimedOutException etoe) {
            exception = new WorkRejectedException((Throwable)etoe);
            exception.setErrorCode("1");
        }
        catch (RejectedExecutionException ree) {
            exception = new WorkRejectedException((Throwable)ree);
        }
        catch (WorkCompletedException wce) {
            if (wrapper != null) {
                wrapper.setWorkException((WorkException)((Object)wce));
            }
        }
        catch (WorkException we) {
            exception = we;
        }
        catch (InterruptedException ie) {
            Thread.currentThread().interrupt();
            exception = new WorkRejectedException(bundle.interruptedWhileRequestingPermit());
        }
        finally {
            if (exception != null) {
                if (workListener != null) {
                    WorkEvent event = new WorkEvent((Object)this, 2, work, exception);
                    workListener.workRejected(event);
                }
                if (trace) {
                    log.tracef("Exception %s for %s", (Object)exception, this);
                }
                throw exception;
            }
            if (wrapper != null) {
                this.checkWorkCompletionException(wrapper);
            }
        }
    }

    public void prepareShutdown() {
        this.shutdown.set(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        this.prepareShutdown();
        Set<WorkWrapper> set = this.activeWorkWrappers;
        synchronized (set) {
            for (WorkWrapper ww : this.activeWorkWrappers) {
                ww.getWork().release();
            }
        }
    }

    public boolean isShutdown() {
        return this.shutdown.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addWorkWrapper(WorkWrapper ww) {
        Set<WorkWrapper> set = this.activeWorkWrappers;
        synchronized (set) {
            this.activeWorkWrappers.add(ww);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeWorkWrapper(WorkWrapper ww) {
        Set<WorkWrapper> set = this.activeWorkWrappers;
        synchronized (set) {
            this.activeWorkWrappers.remove(ww);
        }
    }

    private BlockingExecutor getExecutor(Work work) {
        WorkContextProvider wcProvider;
        List contexts;
        BlockingExecutor executor = this.shortRunningExecutor;
        if (work instanceof WorkContextProvider && (contexts = (wcProvider = (WorkContextProvider)work).getWorkContexts()) != null && contexts.size() > 0) {
            boolean found = false;
            Iterator it = contexts.iterator();
            while (!found && it.hasNext()) {
                HintsContext hc;
                WorkContext wc = (WorkContext)it.next();
                if (!(wc instanceof HintsContext) || !(hc = (HintsContext)wc).getHints().containsKey("javax.resource.LongRunning")) continue;
                executor = this.longRunningExecutor;
                found = true;
            }
        }
        return executor;
    }

    private void checkAndVerifyWork(Work work, ExecutionContext executionContext) throws WorkException {
        if (this.specCompliant) {
            this.verifyWork(work);
        }
        if (work instanceof WorkContextProvider && executionContext != null) {
            throw new WorkRejectedException(bundle.workExecutionContextMustNullImplementsWorkContextProvider());
        }
    }

    private void verifyWork(Work work) throws WorkException {
        if (!this.validatedWork.contains(work.getClass().getName())) {
            Class<?> workClass = work.getClass();
            boolean result = false;
            result = this.verifyWorkMethods(workClass, RUN_METHOD_NAME, null, workClass.getName() + ": Run method is not defined");
            if (!result) {
                throw new WorkException(bundle.runMethodIsSynchronized(workClass.getName()));
            }
            result = this.verifyWorkMethods(workClass, RELEASE_METHOD_NAME, null, workClass.getName() + ": Release method is not defined");
            if (!result) {
                throw new WorkException(bundle.releaseMethodIsSynchronized(workClass.getName()));
            }
            this.validatedWork.add(work.getClass().getName());
        }
    }

    private boolean verifyWorkMethods(Class<?> workClass, String methodName, Class<?>[] parameterTypes, String errorMessage) throws WorkException {
        Method method = null;
        try {
            method = ClassUtil.getClassMethod(workClass, methodName, null);
            if (ClassUtil.modifiersHasSynchronizedKeyword(method.getModifiers())) {
                return false;
            }
        }
        catch (NoSuchMethodException nsme) {
            throw new WorkException(errorMessage);
        }
        return true;
    }

    private void checkWorkCompletionException(WorkWrapper wrapper) throws WorkException {
        if (wrapper.getWorkException() != null) {
            if (trace) {
                log.tracef("Exception %s for %s", (Object)wrapper.getWorkException(), this);
            }
            throw wrapper.getWorkException();
        }
    }

    private void setup(WorkWrapper wrapper, WorkListener workListener) throws WorkCompletedException, WorkException {
        WorkContextProvider wcProvider;
        List contexts;
        if (trace) {
            log.tracef("Setting up work: %s, work listener: %s", wrapper, workListener);
        }
        Work work = wrapper.getWork();
        if (this.resourceAdapter != null && work instanceof ResourceAdapterAssociation) {
            try {
                ResourceAdapterAssociation raa = (ResourceAdapterAssociation)work;
                raa.setResourceAdapter(this.resourceAdapter);
            }
            catch (Throwable t) {
                throw new WorkException(bundle.resourceAdapterAssociationFailed(work.getClass().getName()), t);
            }
        }
        if (work instanceof WorkContextProvider && (contexts = (wcProvider = (WorkContextProvider)work).getWorkContexts()) != null && contexts.size() > 0) {
            boolean isTransactionContext = false;
            boolean isSecurityContext = false;
            boolean isHintcontext = false;
            for (WorkContext context : contexts) {
                Class<?> contextType = null;
                contextType = this.getSupportedWorkContextClass(context.getClass());
                if (contextType == null) {
                    if (trace) {
                        log.trace("Not supported work context class : " + context.getClass().getName());
                    }
                    WorkCompletedException wce = new WorkCompletedException(bundle.unsupportedWorkContextClass(context.getClass().getName()), "1");
                    this.fireWorkContextSetupFailed(context, "1", workListener, work, (WorkException)((Object)wce));
                    throw wce;
                }
                if (this.isTransactionContext(contextType)) {
                    if (isTransactionContext) {
                        if (trace) {
                            log.trace("Duplicate transaction work context : " + context.getClass().getName());
                        }
                        WorkCompletedException wce = new WorkCompletedException(bundle.duplicateTransactionWorkContextClass(context.getClass().getName()), "2");
                        this.fireWorkContextSetupFailed(context, "2", workListener, work, (WorkException)((Object)wce));
                        throw wce;
                    }
                    isTransactionContext = true;
                } else if (this.isSecurityContext(contextType)) {
                    if (isSecurityContext) {
                        if (trace) {
                            log.trace("Duplicate security work context : " + context.getClass().getName());
                        }
                        WorkCompletedException wce = new WorkCompletedException(bundle.duplicateSecurityWorkContextClass(context.getClass().getName()), "2");
                        this.fireWorkContextSetupFailed(context, "2", workListener, work, (WorkException)((Object)wce));
                        throw wce;
                    }
                    isSecurityContext = true;
                } else if (this.isHintContext(contextType)) {
                    if (isHintcontext) {
                        if (trace) {
                            log.trace("Duplicate hint work context : " + context.getClass().getName());
                        }
                        WorkCompletedException wce = new WorkCompletedException(bundle.duplicateHintWorkContextClass(context.getClass().getName()), "2");
                        this.fireWorkContextSetupFailed(context, "2", workListener, work, (WorkException)((Object)wce));
                        throw wce;
                    }
                    isHintcontext = true;
                } else {
                    WorkCompletedException wce = new WorkCompletedException(bundle.unsupportedWorkContextClass(context.getClass().getName()), "1");
                    this.fireWorkContextSetupFailed(context, "1", workListener, work, (WorkException)((Object)wce));
                    throw wce;
                }
                wrapper.addWorkContext(contextType, context);
            }
        }
    }

    private void fireWorkContextSetupFailed(Object workContext, String errorCode, WorkListener workListener, Work work, WorkException exception) {
        WorkEvent event;
        if (workListener != null) {
            event = new WorkEvent((Object)this, 3, work, null);
            workListener.workStarted(event);
        }
        if (workContext instanceof WorkContextLifecycleListener) {
            WorkContextLifecycleListener listener = (WorkContextLifecycleListener)workContext;
            listener.contextSetupFailed(errorCode);
        }
        if (workListener != null) {
            event = new WorkEvent((Object)this, 4, work, exception);
            workListener.workCompleted(event);
        }
    }

    private boolean isTransactionContext(Class<? extends WorkContext> workContextType) {
        return workContextType.isAssignableFrom(TransactionContext.class);
    }

    private boolean isSecurityContext(Class<? extends WorkContext> workContextType) {
        return workContextType.isAssignableFrom(SecurityContext.class);
    }

    private boolean isHintContext(Class<? extends WorkContext> workContextType) {
        return workContextType.isAssignableFrom(HintsContext.class);
    }

    private <T extends WorkContext> Class<T> getSupportedWorkContextClass(Class<T> adaptorWorkContext) {
        for (Class<? extends WorkContext> supportedWorkContext : SUPPORTED_WORK_CONTEXT_CLASSES) {
            if (!supportedWorkContext.isAssignableFrom(adaptorWorkContext)) continue;
            for (Class<T> clz = adaptorWorkContext; clz != null; clz = clz.getSuperclass()) {
                if (!clz.equals(supportedWorkContext)) continue;
                return clz;
            }
        }
        return null;
    }

    static {
        SUPPORTED_WORK_CONTEXT_CLASSES.add(TransactionContext.class);
        SUPPORTED_WORK_CONTEXT_CLASSES.add(SecurityContext.class);
        SUPPORTED_WORK_CONTEXT_CLASSES.add(HintsContext.class);
    }
}

