/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jca.core.connectionmanager.pool.mcp;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.resource.ResourceException;
import javax.resource.spi.ConnectionEventListener;
import javax.resource.spi.ConnectionRequestInfo;
import javax.resource.spi.ManagedConnection;
import javax.resource.spi.ManagedConnectionFactory;
import javax.resource.spi.RetryableUnavailableException;
import javax.resource.spi.ValidatingManagedConnectionFactory;
import javax.security.auth.Subject;
import org.jboss.jca.core.CoreBundle;
import org.jboss.jca.core.CoreLogger;
import org.jboss.jca.core.api.connectionmanager.pool.PoolConfiguration;
import org.jboss.jca.core.connectionmanager.listener.ConnectionListener;
import org.jboss.jca.core.connectionmanager.listener.ConnectionListenerFactory;
import org.jboss.jca.core.connectionmanager.listener.ConnectionState;
import org.jboss.jca.core.connectionmanager.pool.api.Pool;
import org.jboss.jca.core.connectionmanager.pool.api.PrefillPool;
import org.jboss.jca.core.connectionmanager.pool.idle.IdleRemover;
import org.jboss.jca.core.connectionmanager.pool.mcp.ManagedConnectionPool;
import org.jboss.jca.core.connectionmanager.pool.mcp.ManagedConnectionPoolStatistics;
import org.jboss.jca.core.connectionmanager.pool.mcp.ManagedConnectionPoolStatisticsImpl;
import org.jboss.jca.core.connectionmanager.pool.mcp.ManagedConnectionPoolUtility;
import org.jboss.jca.core.connectionmanager.pool.mcp.PoolFiller;
import org.jboss.jca.core.connectionmanager.pool.validator.ConnectionValidator;
import org.jboss.logging.Messages;

public class ArrayBlockingQueueManagedConnectionPool
implements ManagedConnectionPool {
    private CoreLogger log;
    private boolean debug;
    private boolean trace;
    private static CoreBundle bundle = (CoreBundle)Messages.getBundle(CoreBundle.class);
    private ManagedConnectionFactory mcf;
    private ConnectionListenerFactory clf;
    private Subject defaultSubject;
    private ConnectionRequestInfo defaultCri;
    private PoolConfiguration poolConfiguration;
    private Pool pool;
    private ArrayBlockingQueue<ConnectionListener> cls;
    private ConcurrentSkipListSet<ConnectionListener> checkedOut;
    private AtomicBoolean shutdown = new AtomicBoolean(false);
    private ManagedConnectionPoolStatisticsImpl statistics;

    @Override
    public void initialize(ManagedConnectionFactory mcf, ConnectionListenerFactory clf, Subject subject, ConnectionRequestInfo cri, PoolConfiguration pc, Pool p) {
        if (mcf == null) {
            throw new IllegalArgumentException("ManagedConnectionFactory is null");
        }
        if (clf == null) {
            throw new IllegalArgumentException("ConnectionListenerFactory is null");
        }
        if (pc == null) {
            throw new IllegalArgumentException("PoolConfiguration is null");
        }
        if (p == null) {
            throw new IllegalArgumentException("Pool is null");
        }
        this.mcf = mcf;
        this.clf = clf;
        this.defaultSubject = subject;
        this.defaultCri = cri;
        this.poolConfiguration = pc;
        this.pool = p;
        this.log = this.pool.getLogger();
        this.debug = this.log.isDebugEnabled();
        this.trace = this.log.isTraceEnabled();
        this.cls = new ArrayBlockingQueue(pc.getMaxSize(), true);
        this.checkedOut = new ConcurrentSkipListSet();
        this.statistics = new ManagedConnectionPoolStatisticsImpl(pc.getMaxSize());
        if (pc.isPrefill() && p instanceof PrefillPool && pc.getMinSize() > 0) {
            PoolFiller.fillPool(this);
        }
        this.reenable();
        this.statistics.setMaxWaitCount(-1);
    }

    @Override
    public boolean isRunning() {
        return !this.shutdown.get();
    }

    @Override
    public synchronized boolean isEmpty() {
        return this.cls.size() == 0 && this.checkedOut.size() == 0;
    }

    @Override
    public void reenable() {
        if (this.poolConfiguration.getIdleTimeoutMinutes() > 0) {
            IdleRemover.getInstance().registerPool(this, (long)this.poolConfiguration.getIdleTimeoutMinutes() * 1000L * 60L);
        }
        if (this.poolConfiguration.isBackgroundValidation() && this.poolConfiguration.getBackgroundValidationMillis() > 0L) {
            this.log.debug("Registering for background validation at interval " + this.poolConfiguration.getBackgroundValidationMillis());
            ConnectionValidator.getInstance().registerPool(this, this.poolConfiguration.getBackgroundValidationMillis());
        }
        this.shutdown.set(false);
    }

    @Override
    public ConnectionListener getConnection(Subject subject, ConnectionRequestInfo cri) throws ResourceException {
        String method;
        if (this.trace) {
            method = "getConnection(" + subject + ", " + cri + ")";
            this.log.trace(ManagedConnectionPoolUtility.fullDetails(System.identityHashCode(this), method, this.mcf, this.clf, this.pool, this.poolConfiguration, this.cls, this.checkedOut, this.statistics));
        } else if (this.debug) {
            method = "getConnection(" + subject + ", " + cri + ")";
            this.log.debug(ManagedConnectionPoolUtility.details(method, this.pool.getName(), this.statistics));
        }
        subject = subject == null ? this.defaultSubject : subject;
        cri = cri == null ? this.defaultCri : cri;
        ConnectionListener cl = null;
        boolean verifyConnectionListener = true;
        long startWait = System.currentTimeMillis();
        if (this.cls.size() > 0) {
            if (this.shutdown.get()) {
                throw new RetryableUnavailableException(bundle.thePoolHasBeenShutdown(this.pool.getName(), Integer.toHexString(System.identityHashCode(this))));
            }
            cl = this.cls.peek();
            if (cl != null) {
                try {
                    cl = this.cls.poll(this.poolConfiguration.getBlockingTimeout(), TimeUnit.MILLISECONDS);
                    this.statistics.deltaTotalBlockingTime(System.currentTimeMillis() - startWait);
                }
                catch (InterruptedException ie) {
                    Thread.interrupted();
                    long end = System.currentTimeMillis() - startWait;
                    throw new ResourceException(bundle.interruptedWhileRequestingConnection(end));
                }
            } else {
                try {
                    cl = this.createConnectionEventListener(subject, cri);
                    if (this.trace) {
                        this.log.trace("supplying new ManagedConnection: " + cl);
                    }
                    verifyConnectionListener = false;
                }
                catch (Throwable t) {
                    this.log.throwableWhileAttemptingGetNewGonnection(cl, t);
                    throw new ResourceException(bundle.unexpectedThrowableWhileTryingCreateConnection(cl), t);
                }
            }
        } else {
            try {
                cl = this.cls.poll(this.poolConfiguration.getBlockingTimeout(), TimeUnit.MILLISECONDS);
                this.statistics.deltaTotalBlockingTime(System.currentTimeMillis() - startWait);
                if (this.shutdown.get()) {
                    throw new RetryableUnavailableException(bundle.thePoolHasBeenShutdown(this.pool.getName(), Integer.toHexString(System.identityHashCode(this))));
                }
            }
            catch (InterruptedException ie) {
                Thread.interrupted();
                if (!this.poolConfiguration.isUseFastFail()) {
                    throw new ResourceException(bundle.noMManagedConnectionsAvailableWithinConfiguredBlockingTimeout(this.poolConfiguration.getBlockingTimeout()));
                }
                if (this.trace) {
                    this.log.trace("Fast failing for connection attempt. No more attempts will be made to acquire connection from pool and a new connection will be created immeadiately");
                }
                try {
                    cl = this.createConnectionEventListener(subject, cri);
                    if (this.poolConfiguration.isPrefill() && this.pool instanceof PrefillPool && this.poolConfiguration.getMinSize() > 0) {
                        PoolFiller.fillPool(this);
                    }
                    if (this.trace) {
                        this.log.trace("supplying new ManagedConnection: " + cl);
                    }
                    verifyConnectionListener = false;
                }
                catch (Throwable t) {
                    this.log.throwableWhileAttemptingGetNewGonnection(cl, t);
                    throw new ResourceException(bundle.unexpectedThrowableWhileTryingCreateConnection(cl), t);
                }
            }
        }
        this.checkedOut.add(cl);
        this.statistics.setInUsedCount(this.checkedOut.size());
        if (!verifyConnectionListener) {
            return cl;
        }
        try {
            ManagedConnection matchedMC = this.mcf.matchManagedConnections(Collections.singleton(cl.getManagedConnection()), subject, cri);
            if (matchedMC != null) {
                if (this.trace) {
                    this.log.trace("supplying ManagedConnection from pool: " + cl);
                }
                return cl;
            }
            this.log.destroyingConnectionNotSuccessfullyMatched(cl, this.mcf);
            this.checkedOut.remove(cl);
            this.statistics.setInUsedCount(this.checkedOut.size());
            this.doDestroy(cl);
            cl = null;
        }
        catch (Throwable t) {
            this.log.throwableWhileTryingMatchManagedConnection(cl, t);
            this.checkedOut.remove(cl);
            this.statistics.setInUsedCount(this.checkedOut.size());
            this.doDestroy(cl);
            cl = null;
            throw new ResourceException(bundle.unexpectedThrowableWhileTryingCreateConnection(cl), t);
        }
        throw new ResourceException(bundle.shouldNeverHappen(), new Throwable("STACKTRACE"));
    }

    @Override
    public void returnConnection(ConnectionListener cl, boolean kill) {
        String method;
        if (this.trace) {
            method = "returnConnection(" + Integer.toHexString(System.identityHashCode(cl)) + ", " + kill + ")";
            this.log.trace(ManagedConnectionPoolUtility.fullDetails(System.identityHashCode(this), method, this.mcf, this.clf, this.pool, this.poolConfiguration, this.cls, this.checkedOut, this.statistics));
        } else if (this.debug) {
            method = "returnConnection(" + Integer.toHexString(System.identityHashCode(cl)) + ", " + kill + ")";
            this.log.debug(ManagedConnectionPoolUtility.details(method, this.pool.getName(), this.statistics));
        }
        if (cl.getState() == ConnectionState.DESTROYED) {
            if (this.trace) {
                this.log.trace("ManagedConnection is being returned after it was destroyed" + cl);
            }
            return;
        }
        try {
            cl.getManagedConnection().cleanup();
        }
        catch (ResourceException re) {
            this.log.resourceExceptionCleaningUpManagedConnection(cl, re);
            kill = true;
        }
        if (cl.getState() == ConnectionState.DESTROY || cl.getState() == ConnectionState.DESTROYED) {
            kill = true;
        }
        this.checkedOut.remove(cl);
        this.statistics.setInUsedCount(this.checkedOut.size());
        if (!kill && this.cls.size() >= this.poolConfiguration.getMaxSize()) {
            this.log.destroyingReturnedConnectionMaximumPoolSizeExceeded(cl);
            kill = true;
        }
        if (kill) {
            this.cls.remove(cl);
        } else {
            cl.used();
            if (!this.cls.contains(cl)) {
                try {
                    this.cls.put(cl);
                }
                catch (InterruptedException ie) {
                    Thread.interrupted();
                    cl.setState(ConnectionState.DESTROY);
                    kill = true;
                }
            } else {
                this.log.attemptReturnConnectionTwice(cl, new Throwable("STACKTRACE"));
            }
        }
        if (kill) {
            if (this.trace) {
                this.log.trace("Destroying returned connection " + cl);
            }
            this.doDestroy(cl);
            cl = null;
        }
    }

    @Override
    public void flush() {
        this.flush(false);
    }

    @Override
    public void flush(boolean kill) {
        ConnectionListener cl;
        ArrayList<ConnectionListener> destroy = null;
        if (this.trace) {
            this.log.trace("Flushing pool checkedOut=" + this.checkedOut + " inPool=" + this.cls);
        }
        if (kill) {
            while (this.checkedOut.size() > 0) {
                cl = this.checkedOut.pollFirst();
                if (this.trace) {
                    this.log.trace("Flush marking checked out connection for destruction " + cl);
                }
                cl.setState(ConnectionState.DESTROY);
                if (destroy == null) {
                    destroy = new ArrayList(1);
                }
                destroy.add(cl);
            }
        }
        cl = this.cls.poll();
        while (cl != null) {
            if (destroy == null) {
                destroy = new ArrayList<ConnectionListener>();
            }
            destroy.add(cl);
            cl = this.cls.poll();
        }
        if (destroy != null) {
            for (ConnectionListener destroyCl : destroy) {
                if (this.trace) {
                    this.log.trace("Destroying flushed connection " + destroyCl);
                }
                this.doDestroy(destroyCl);
                destroyCl = null;
            }
            if (!this.shutdown.get() && this.poolConfiguration.getMinSize() > 0 && this.poolConfiguration.isPrefill() && this.pool instanceof PrefillPool) {
                PoolFiller.fillPool(this);
            }
        }
    }

    @Override
    public void removeIdleConnections() {
        ArrayList<ConnectionListener> destroy = null;
        long timeout = System.currentTimeMillis() - (long)this.poolConfiguration.getIdleTimeoutMinutes() * 1000L * 60L;
        boolean cont = true;
        while (cont) {
            ConnectionListener cl = this.cls.peek();
            if (cl != null && cl.isTimedOut(timeout) && this.shouldRemove()) {
                this.statistics.deltaTimedOut();
                if (destroy == null) {
                    destroy = new ArrayList<ConnectionListener>(1);
                }
                if ((cl = this.cls.poll()) != null) {
                    destroy.add(cl);
                    continue;
                }
                cont = false;
                continue;
            }
            cont = false;
        }
        if (destroy != null) {
            for (ConnectionListener cl : destroy) {
                if (this.trace) {
                    this.log.trace("Destroying timedout connection " + cl);
                }
                this.doDestroy(cl);
                cl = null;
            }
            if (!this.shutdown.get() && !this.poolConfiguration.isStrictMin()) {
                boolean emptyManagedConnectionPool = false;
                if (this.poolConfiguration.isPrefill() && this.pool instanceof PrefillPool) {
                    if (this.poolConfiguration.getMinSize() > 0) {
                        PoolFiller.fillPool(this);
                    } else {
                        emptyManagedConnectionPool = true;
                    }
                } else {
                    emptyManagedConnectionPool = true;
                }
                if (emptyManagedConnectionPool) {
                    this.pool.emptyManagedConnectionPool(this);
                }
            }
        }
    }

    @Override
    public void shutdown() {
        if (this.trace) {
            this.log.tracef("Shutdown - Pool: %s MCP: %s", this.pool.getName(), Integer.toHexString(System.identityHashCode(this)));
        }
        this.shutdown.set(true);
        IdleRemover.getInstance().unregisterPool(this);
        ConnectionValidator.getInstance().unregisterPool(this);
        this.flush(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void fillToMin() {
        if (this.poolConfiguration.getMinSize() <= 0) {
            return;
        }
        if (!this.poolConfiguration.isPrefill()) {
            return;
        }
        if (!(this.pool instanceof PrefillPool)) {
            return;
        }
        while (this.poolConfiguration.getMinSize() - (this.cls.size() + this.checkedOut.size()) > 0) {
            if (this.shutdown.get()) {
                return;
            }
            ConnectionListener cl = null;
            boolean destroy = false;
            try {
                cl = this.createConnectionEventListener(this.defaultSubject, this.defaultCri);
                this.statistics.setInUsedCount(this.checkedOut.size() + 1);
                if (this.checkedOut.size() + this.cls.size() < this.poolConfiguration.getMinSize()) {
                    if (this.trace) {
                        this.log.trace("Filling pool cl=" + cl);
                    }
                    if (this.cls.offer(cl)) continue;
                    this.log.debug("Connection couldn't be inserted during fillToMin");
                    destroy = true;
                    continue;
                }
                this.log.debug("MinSize reached during fillToMin");
                destroy = true;
            }
            catch (ResourceException re) {
                this.log.unableFillPool(re);
                destroy = true;
            }
            finally {
                if (!destroy) continue;
                if (cl == null) break;
                this.doDestroy(cl);
                cl = null;
                break;
            }
        }
    }

    @Override
    public ManagedConnectionPoolStatistics getStatistics() {
        return this.statistics;
    }

    private ConnectionListener createConnectionEventListener(Subject subject, ConnectionRequestInfo cri) throws ResourceException {
        long start = System.currentTimeMillis();
        ManagedConnection mc = this.mcf.createManagedConnection(subject, cri);
        this.statistics.deltaTotalCreationTime(System.currentTimeMillis() - start);
        this.statistics.deltaCreatedCount();
        try {
            return this.clf.createConnectionListener(mc, this);
        }
        catch (ResourceException re) {
            this.statistics.deltaDestroyedCount();
            mc.destroy();
            throw re;
        }
    }

    private void doDestroy(ConnectionListener cl) {
        if (cl.getState() == ConnectionState.DESTROYED) {
            this.log.trace("ManagedConnection is already destroyed " + cl);
            return;
        }
        this.statistics.deltaDestroyedCount();
        cl.setState(ConnectionState.DESTROYED);
        ManagedConnection mc = cl.getManagedConnection();
        try {
            mc.destroy();
        }
        catch (Throwable t) {
            this.log.debug("Exception destroying ManagedConnection " + cl, t);
        }
        mc.removeConnectionEventListener((ConnectionEventListener)cl);
    }

    private boolean shouldRemove() {
        boolean remove = true;
        if (this.poolConfiguration.isStrictMin()) {
            boolean bl = remove = this.cls.size() > this.poolConfiguration.getMinSize();
            if (this.trace) {
                this.log.trace("StrictMin is active. Current connection will be removed is " + remove);
            }
        }
        return remove;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    public void validateConnections() throws Exception {
        block12: {
            if (this.trace) {
                this.log.trace("Attempting to  validate connections for pool " + this);
            }
            anyDestroyed = false;
            while (true) lbl-1000:
            // 5 sources

            {
                cl = null;
                destroyed = false;
                if (this.cls.size() == 0) {
                    break block12;
                }
                cl = this.removeForFrequencyCheck();
                if (cl == null) {
                    break block12;
                }
                try {
                    candidateSet = Collections.singleton(cl.getManagedConnection());
                    if (this.mcf instanceof ValidatingManagedConnectionFactory) {
                        vcf = (ValidatingManagedConnectionFactory)this.mcf;
                        if ((candidateSet = vcf.getInvalidConnections(candidateSet)) == null || candidateSet.size() <= 0 || cl.getState() == ConnectionState.DESTROY) ** GOTO lbl-1000
                        this.doDestroy(cl);
                        cl = null;
                        destroyed = true;
                        anyDestroyed = true;
                    }
                    this.log.backgroundValidationNonCompliantManagedConnectionFactory();
                }
                finally {
                    if (destroyed || this.returnForFrequencyCheck(cl)) continue;
                    anyDestroyed = true;
                    continue;
                }
                break;
            }
            ** GOTO lbl-1000
            finally {
                if (anyDestroyed && !this.shutdown.get() && this.poolConfiguration.getMinSize() > 0 && this.poolConfiguration.isPrefill() && this.pool instanceof PrefillPool) {
                    PoolFiller.fillPool(this);
                }
            }
        }
    }

    private ConnectionListener removeForFrequencyCheck() {
        this.log.debug("Checking for connection within frequency");
        ConnectionListener result = null;
        Iterator<ConnectionListener> iter = this.cls.iterator();
        while (result == null && iter.hasNext()) {
            ConnectionListener cl = iter.next();
            long lastCheck = cl.getLastValidatedTime();
            if (System.currentTimeMillis() - lastCheck < this.poolConfiguration.getBackgroundValidationMillis()) continue;
            result = cl;
            this.cls.remove(cl);
        }
        return result;
    }

    private boolean returnForFrequencyCheck(ConnectionListener cl) {
        this.log.debug("Returning for connection within frequency: " + cl);
        if (cl == null) {
            return true;
        }
        cl.setLastValidatedTime(System.currentTimeMillis());
        if (!this.cls.offer(cl)) {
            this.log.debug("Connection couldn't be returned");
            this.doDestroy(cl);
            cl = null;
            return false;
        }
        return true;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("ArrayBlockingQueueManagedConnectionPool@").append(Integer.toHexString(System.identityHashCode(this)));
        sb.append("[pool=").append(this.pool.getName());
        sb.append("]");
        return sb.toString();
    }
}

