/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jca.core.workmanager;

import org.jboss.jca.core.CoreLogger;
import org.jboss.jca.core.workmanager.WorkClassLoader;
import org.jboss.logging.Logger;

public class ResourceAdapterClassLoader
extends ClassLoader {
    private static CoreLogger log = (CoreLogger)Logger.getMessageLogger(CoreLogger.class, (String)ResourceAdapterClassLoader.class.getName());
    private static boolean trace = log.isTraceEnabled();
    private WorkClassLoader workClassLoader;

    public ResourceAdapterClassLoader(ClassLoader cl, WorkClassLoader wcl) {
        super(cl);
        this.workClassLoader = wcl;
    }

    @Override
    public Class<?> loadClass(String name) throws ClassNotFoundException {
        if (trace) {
            log.tracef("%s: loadClass(%s)", Integer.toHexString(System.identityHashCode(this)), name);
        }
        try {
            return super.loadClass(name);
        }
        catch (Throwable t) {
            if (trace) {
                log.tracef("%s: Failed to load=%s", Integer.toHexString(System.identityHashCode(this)), name);
            }
            return this.workClassLoader.loadClass(name, false);
        }
    }

    @Override
    public Class<?> findClass(String name) throws ClassNotFoundException {
        if (trace) {
            log.tracef("%s: findClass(%s)", Integer.toHexString(System.identityHashCode(this)), name);
        }
        try {
            return this.getParent().loadClass(name);
        }
        catch (Throwable t) {
            if (trace) {
                log.tracef("%s: Failed to find=%s", Integer.toHexString(System.identityHashCode(this)), name);
            }
            return this.workClassLoader.lookup(name);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("ResourceAdapterClassLoader@").append(Integer.toHexString(System.identityHashCode(this)));
        sb.append("[parent=").append(this.getParent());
        sb.append(" workClassLoader=").append(Integer.toHexString(System.identityHashCode(this.workClassLoader)));
        sb.append("]");
        return sb.toString();
    }
}

