/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jca.core.rar;

import java.lang.ref.WeakReference;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import javax.resource.spi.ResourceAdapter;
import org.jboss.jca.common.api.metadata.resourceadapter.Activation;
import org.jboss.jca.common.api.metadata.spec.Activationspec;
import org.jboss.jca.common.api.metadata.spec.Connector;
import org.jboss.jca.common.api.metadata.spec.MessageListener;
import org.jboss.jca.common.api.metadata.spec.RequiredConfigProperty;
import org.jboss.jca.common.api.metadata.spec.XsdString;
import org.jboss.jca.core.CoreBundle;
import org.jboss.jca.core.CoreLogger;
import org.jboss.jca.core.rar.ActivationImpl;
import org.jboss.jca.core.rar.EndpointImpl;
import org.jboss.jca.core.rar.MessageListenerImpl;
import org.jboss.jca.core.rar.SecurityActions;
import org.jboss.jca.core.spi.mdr.MetadataRepository;
import org.jboss.jca.core.spi.rar.Endpoint;
import org.jboss.jca.core.spi.rar.NotFoundException;
import org.jboss.jca.core.spi.rar.ResourceAdapterRepository;
import org.jboss.jca.core.spi.transaction.TransactionIntegration;
import org.jboss.logging.Logger;
import org.jboss.logging.Messages;

public class SimpleResourceAdapterRepository
implements ResourceAdapterRepository {
    private static CoreBundle bundle = (CoreBundle)Messages.getBundle(CoreBundle.class);
    private static CoreLogger log = (CoreLogger)Logger.getMessageLogger(CoreLogger.class, (String)SimpleResourceAdapterRepository.class.getName());
    private static Set<Class<?>> approvedTypes = new HashSet();
    private Map<String, WeakReference<ResourceAdapter>> rars = new HashMap<String, WeakReference<ResourceAdapter>>();
    private Map<String, AtomicInteger> ids = new HashMap<String, AtomicInteger>();
    private Map<String, Boolean> recovery = new HashMap<String, Boolean>();
    private MetadataRepository mdr = null;
    private TransactionIntegration transactionIntegration = null;

    public synchronized void setMetadataRepository(MetadataRepository v) {
        this.mdr = v;
    }

    public synchronized void setTransactionIntegration(TransactionIntegration v) {
        this.transactionIntegration = v;
    }

    public synchronized String registerResourceAdapter(ResourceAdapter ra) {
        if (ra == null) {
            throw new IllegalArgumentException("ResourceAdapter is null");
        }
        String clzName = ra.getClass().getName();
        AtomicInteger id = this.ids.get(clzName);
        if (id == null) {
            id = new AtomicInteger(0);
            this.ids.put(clzName, id);
        }
        String key = clzName + "#" + id.incrementAndGet();
        this.rars.put(key, new WeakReference<ResourceAdapter>(ra));
        return key;
    }

    public synchronized void unregisterResourceAdapter(String key) throws NotFoundException {
        if (key == null) {
            throw new IllegalArgumentException("Key is null");
        }
        if (!this.rars.keySet().contains(key)) {
            throw new NotFoundException(bundle.keyNotRegistered(key));
        }
        this.rars.remove(key);
        this.recovery.remove(key);
    }

    public synchronized ResourceAdapter getResourceAdapter(String uniqueId) throws NotFoundException {
        if (uniqueId == null) {
            throw new IllegalArgumentException("UniqueId is null");
        }
        if (uniqueId.trim().equals("")) {
            throw new IllegalArgumentException("UniqueId is empty");
        }
        if (!this.rars.containsKey(uniqueId)) {
            throw new NotFoundException(bundle.keyNotRegistered(uniqueId));
        }
        WeakReference<ResourceAdapter> ra = this.rars.get(uniqueId);
        if (ra.get() == null) {
            throw new NotFoundException(bundle.keyNotRegistered(uniqueId));
        }
        return (ResourceAdapter)ra.get();
    }

    public synchronized Set<String> getResourceAdapters() {
        return Collections.unmodifiableSet(this.rars.keySet());
    }

    public synchronized Set<String> getResourceAdapters(Class<?> messageListenerType) {
        if (messageListenerType == null) {
            throw new IllegalArgumentException("MessageListenerType is null");
        }
        if (this.mdr == null) {
            throw new IllegalStateException("MDR is null");
        }
        HashSet<String> result = new HashSet<String>();
        for (Map.Entry<String, WeakReference<ResourceAdapter>> entry : this.rars.entrySet()) {
            org.jboss.jca.common.api.metadata.spec.ResourceAdapter raSpec;
            String raKey = entry.getKey();
            WeakReference<ResourceAdapter> ra = entry.getValue();
            if (ra.get() == null) continue;
            ResourceAdapter rar = (ResourceAdapter)ra.get();
            Connector md = null;
            Set mdrKeys = this.mdr.getResourceAdapters();
            Iterator mdrIt = mdrKeys.iterator();
            while (md == null && mdrIt.hasNext()) {
                String mdrId = (String)mdrIt.next();
                try {
                    Connector c = this.mdr.getResourceAdapter(mdrId);
                    if (c.getResourceadapter() == null) continue;
                    String clz = c.getResourceadapter().getResourceadapterClass();
                    if (!rar.getClass().getName().equals(clz)) continue;
                    md = c;
                }
                catch (Throwable t) {
                    log.debugf("Resource adapter %s is ignored", rar.getClass().getName());
                }
            }
            if (md == null || md.getResourceadapter() == null || (raSpec = md.getResourceadapter()).getInboundResourceadapter() == null || raSpec.getInboundResourceadapter().getMessageadapter() == null || raSpec.getInboundResourceadapter().getMessageadapter().getMessagelisteners() == null || raSpec.getInboundResourceadapter().getMessageadapter().getMessagelisteners().size() <= 0) continue;
            List listeners = raSpec.getInboundResourceadapter().getMessageadapter().getMessagelisteners();
            for (MessageListener ml : listeners) {
                try {
                    ClassLoader cl = SecurityActions.getClassLoader(rar.getClass());
                    Class<?> mlType = Class.forName(ml.getMessagelistenerType().getValue(), true, cl);
                    if (!mlType.isAssignableFrom(messageListenerType)) continue;
                    result.add(raKey);
                }
                catch (Throwable throwable) {}
            }
        }
        return Collections.unmodifiableSet(result);
    }

    public synchronized Endpoint getEndpoint(String uniqueId) throws NotFoundException {
        if (uniqueId == null) {
            throw new IllegalArgumentException("UniqueId is null");
        }
        if (uniqueId.trim().equals("")) {
            throw new IllegalArgumentException("UniqueId is empty");
        }
        if (!this.rars.containsKey(uniqueId)) {
            throw new NotFoundException(bundle.keyNotRegistered(uniqueId));
        }
        WeakReference<ResourceAdapter> ra = this.rars.get(uniqueId);
        if (ra.get() == null) {
            throw new NotFoundException(bundle.keyNotRegistered(uniqueId));
        }
        String mdrIdentifier = this.getMDRIdentifier((ResourceAdapter)ra.get());
        boolean is16 = this.is16(mdrIdentifier);
        Set<String> beanValidationGroups = this.getBeanValidationGroups(mdrIdentifier);
        String productName = this.getProductName(mdrIdentifier);
        String productVersion = this.getProductVersion(mdrIdentifier);
        Boolean isXA = this.recovery.get(uniqueId);
        if (isXA == null) {
            isXA = Boolean.TRUE;
        }
        return new EndpointImpl(ra, is16, beanValidationGroups, productName, productVersion, this.transactionIntegration, isXA);
    }

    public synchronized List<org.jboss.jca.core.spi.rar.MessageListener> getMessageListeners(String uniqueId) throws NotFoundException, InstantiationException, IllegalAccessException {
        org.jboss.jca.common.api.metadata.spec.ResourceAdapter raSpec;
        if (uniqueId == null) {
            throw new IllegalArgumentException("UniqueId is null");
        }
        if (uniqueId.trim().equals("")) {
            throw new IllegalArgumentException("UniqueId is empty");
        }
        if (!this.rars.containsKey(uniqueId)) {
            throw new NotFoundException(bundle.keyNotRegistered(uniqueId));
        }
        WeakReference<ResourceAdapter> ra = this.rars.get(uniqueId);
        if (ra.get() == null) {
            throw new NotFoundException(bundle.keyNotRegistered(uniqueId));
        }
        if (this.mdr == null) {
            throw new IllegalStateException("MDR is null");
        }
        ResourceAdapter rar = (ResourceAdapter)ra.get();
        Connector md = null;
        Set mdrKeys = this.mdr.getResourceAdapters();
        Iterator mdrIt = mdrKeys.iterator();
        while (md == null && mdrIt.hasNext()) {
            String mdrId = (String)mdrIt.next();
            try {
                Connector c = this.mdr.getResourceAdapter(mdrId);
                if (c.getResourceadapter() == null) continue;
                String clz = c.getResourceadapter().getResourceadapterClass();
                if (!rar.getClass().getName().equals(clz)) continue;
                md = c;
            }
            catch (Throwable t) {
                throw new NotFoundException(bundle.unableLookupResourceAdapterInMDR(uniqueId), t);
            }
        }
        if (md == null) {
            throw new NotFoundException(bundle.unableLookupResourceAdapterInMDR(uniqueId));
        }
        if (md.getResourceadapter() != null && (raSpec = md.getResourceadapter()).getInboundResourceadapter() != null && raSpec.getInboundResourceadapter().getMessageadapter() != null && raSpec.getInboundResourceadapter().getMessageadapter().getMessagelisteners() != null && raSpec.getInboundResourceadapter().getMessageadapter().getMessagelisteners().size() > 0) {
            List listeners = raSpec.getInboundResourceadapter().getMessageadapter().getMessagelisteners();
            ArrayList<org.jboss.jca.core.spi.rar.MessageListener> result = new ArrayList<org.jboss.jca.core.spi.rar.MessageListener>(listeners.size());
            for (MessageListener ml : listeners) {
                result.add(this.createMessageListener(rar, ml));
            }
            return result;
        }
        return Collections.emptyList();
    }

    public void setRecoveryForResourceAdapter(String uniqueId, boolean isXA) throws NotFoundException {
        if (uniqueId == null) {
            throw new IllegalArgumentException("UniqueId is null");
        }
        if (uniqueId.trim().equals("")) {
            throw new IllegalArgumentException("UniqueId is empty");
        }
        if (!this.rars.containsKey(uniqueId)) {
            throw new NotFoundException(bundle.keyNotRegistered(uniqueId));
        }
        this.recovery.put(uniqueId, isXA ? Boolean.TRUE : Boolean.FALSE);
    }

    private org.jboss.jca.core.spi.rar.MessageListener createMessageListener(ResourceAdapter rar, MessageListener ml) throws InstantiationException, IllegalAccessException {
        try {
            ClassLoader cl = SecurityActions.getClassLoader(rar.getClass());
            Class<?> type = Class.forName(ml.getMessagelistenerType().getValue(), true, cl);
            HashMap configProperties = new HashMap();
            HashSet<String> requiredConfigProperties = new HashSet<String>();
            HashMap<String, String> valueProperties = new HashMap<String, String>();
            Activationspec as = ml.getActivationspec();
            Class<?> asClz = Class.forName(as.getActivationspecClass().getValue(), true, cl);
            if (as.getConfigProperties() != null && as.getConfigProperties().size() > 0) {
                for (Object cp : as.getConfigProperties()) {
                    String name = cp.getConfigPropertyName().getValue();
                    Class<?> ct = Class.forName(cp.getConfigPropertyType().getValue(), true, cl);
                    configProperties.put(name, ct);
                    if (cp.getConfigPropertyValue() == null || cp.getConfigPropertyValue().getValue() == null) continue;
                    valueProperties.put(name, cp.getConfigPropertyValue().getValue());
                }
            }
            configProperties.putAll(this.introspectActivationSpec(asClz));
            List rcps = as.getRequiredConfigProperties();
            if (rcps != null && rcps.size() > 0) {
                for (RequiredConfigProperty rcp : rcps) {
                    String name = rcp.getConfigPropertyName().getValue();
                    requiredConfigProperties.add(name);
                }
            }
            ActivationImpl a = new ActivationImpl(rar, asClz, Collections.unmodifiableMap(configProperties), Collections.unmodifiableSet(requiredConfigProperties), Collections.unmodifiableMap(valueProperties));
            return new MessageListenerImpl(type, a);
        }
        catch (ClassNotFoundException cnfe) {
            InstantiationException ie = new InstantiationException("Unable to create representation");
            ie.initCause(cnfe);
            throw ie;
        }
    }

    private Map<String, Class<?>> introspectActivationSpec(Class<?> clz) {
        Method[] methods;
        HashMap result = new HashMap();
        if (clz != null && (methods = SecurityActions.getMethods(clz)).length > 0) {
            for (int i = 0; i < methods.length; ++i) {
                Class<?> parameterType;
                Method m = methods[i];
                if (!m.getName().startsWith("set") || m.getParameterCount() != 1 || !approvedTypes.contains(parameterType = m.getParameterTypes()[0])) continue;
                String n = m.getName().substring(3);
                String name = n.substring(0, 1).toLowerCase(Locale.US);
                if (n.length() > 1) {
                    name = name.concat(n.substring(1));
                }
                result.put(name, parameterType);
            }
        }
        return result;
    }

    private String getMDRIdentifier(ResourceAdapter ra) {
        for (String id : this.mdr.getResourceAdapters()) {
            try {
                org.jboss.jca.common.api.metadata.spec.ResourceAdapter raSpec;
                Connector raXml = this.mdr.getResourceAdapter(id);
                if (raXml == null || raXml.getResourceadapter() == null || (raSpec = raXml.getResourceadapter()).getResourceadapterClass() == null || raSpec.getResourceadapterClass().equals("") || !ra.getClass().getName().equals(raSpec.getResourceadapterClass())) continue;
                return id;
            }
            catch (Throwable t) {
                log.debugf(t, "Exception while loading id: %s", id);
            }
        }
        return null;
    }

    private boolean is16(String id) {
        if (id == null || id.equals("")) {
            return false;
        }
        try {
            Connector raXml = this.mdr.getResourceAdapter(id);
            if (raXml != null) {
                return raXml.getVersion() == Connector.Version.V_16 || raXml.getVersion() == Connector.Version.V_17 || raXml.getVersion() == Connector.Version.V_20 || raXml.getVersion() == Connector.Version.V_21;
            }
        }
        catch (Throwable t) {
            log.debugf(t, "Exception while loading ra.xml: %s", id);
        }
        return false;
    }

    private Set<String> getBeanValidationGroups(String id) {
        if (id == null || id.equals("")) {
            return null;
        }
        try {
            Activation a = this.mdr.getActivation(id);
            if (a != null && a.getBeanValidationGroups() != null && a.getBeanValidationGroups().size() > 0) {
                HashSet<String> groups = new HashSet<String>();
                for (String group : a.getBeanValidationGroups()) {
                    groups.add(group);
                }
                return groups;
            }
        }
        catch (Throwable t) {
            log.debugf(t, "Exception while loading ironjacamar.xml: %s", id);
        }
        return null;
    }

    private String getProductName(String id) {
        if (id == null || id.equals("")) {
            return "";
        }
        try {
            Connector raXml = this.mdr.getResourceAdapter(id);
            if (raXml != null && !XsdString.isNull((XsdString)raXml.getEisType())) {
                return raXml.getEisType().getValue();
            }
        }
        catch (Throwable t) {
            log.debugf(t, "Exception while loading ra.xml: %s", id);
        }
        return "";
    }

    private String getProductVersion(String id) {
        if (id == null || id.equals("")) {
            return "";
        }
        try {
            Connector raXml = this.mdr.getResourceAdapter(id);
            if (raXml != null && !XsdString.isNull((XsdString)raXml.getResourceadapterVersion())) {
                return raXml.getResourceadapterVersion().getValue();
            }
        }
        catch (Throwable t) {
            log.debugf(t, "Exception while loading ra.xml: %s", id);
        }
        return "";
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("SimpleResourceAdapterRepository@").append(Integer.toHexString(System.identityHashCode(this)));
        sb.append("[");
        sb.append(" rars=").append(this.rars);
        sb.append(" ids=").append(this.ids);
        sb.append(" mdr=").append(this.mdr);
        sb.append(" ti=").append(this.transactionIntegration);
        sb.append("]");
        return sb.toString();
    }

    static {
        approvedTypes.add(Boolean.TYPE);
        approvedTypes.add(Boolean.class);
        approvedTypes.add(Byte.TYPE);
        approvedTypes.add(Byte.class);
        approvedTypes.add(Short.TYPE);
        approvedTypes.add(Short.class);
        approvedTypes.add(Integer.TYPE);
        approvedTypes.add(Integer.class);
        approvedTypes.add(Long.TYPE);
        approvedTypes.add(Long.class);
        approvedTypes.add(Float.TYPE);
        approvedTypes.add(Float.class);
        approvedTypes.add(Double.TYPE);
        approvedTypes.add(Double.class);
        approvedTypes.add(Character.TYPE);
        approvedTypes.add(Character.class);
        approvedTypes.add(String.class);
    }
}

