package org.jboss.jca.core;

import java.util.Locale;
import java.io.Serializable;
import javax.annotation.Generated;
import org.jboss.logging.DelegatingBasicLogger;
import org.jboss.logging.BasicLogger;
import java.lang.Throwable;
import java.lang.Object;
import java.lang.String;
import org.jboss.logging.Logger;
import java.lang.Exception;


import static org.jboss.logging.Logger.Level.ERROR;
import static org.jboss.logging.Logger.Level.INFO;
import static org.jboss.logging.Logger.Level.WARN;

/**
 * Warning this class consists of generated code.
 */
@Generated(value = "org.jboss.logging.processor.generator.model.MessageLoggerImplementor", date = "2022-02-11T14:41:37+0100")
public class CoreLogger_$logger extends DelegatingBasicLogger implements CoreLogger, BasicLogger, Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = CoreLogger_$logger.class.getName();
    public CoreLogger_$logger(final Logger log) {
        super(log);
    }
    private static final Locale LOCALE = Locale.ROOT;
    protected Locale getLoggingLocale() {
        return LOCALE;
    }
    @Override
    public final void closingConnection(final Object handle) {
        super.log.logf(FQCN, INFO, null, closingConnection$str(), handle);
    }
    protected String closingConnection$str() {
        return "IJ000100: Closing a connection for you. Please close them yourself: %s";
    }
    @Override
    public final void closingConnection(final Object handle, final Throwable t) {
        super.log.logf(FQCN, INFO, t, closingConnection$str(), handle);
    }
    @Override
    public final void closingConnectionThrowable(final Throwable t) {
        super.log.logf(FQCN, INFO, t, closingConnectionThrowable$str());
    }
    protected String closingConnectionThrowable$str() {
        return "IJ000102: Throwable trying to close a connection for you, please close it yourself";
    }
    @Override
    public final void closingConnectionNoClose(final String clz) {
        super.log.logf(FQCN, INFO, null, closingConnectionNoClose$str(), clz);
    }
    protected String closingConnectionNoClose$str() {
        return "IJ000103: Could not find a close method on alleged connection object (%s). Please close your own connections";
    }
    @Override
    public final void securityContextSetupFailed(final String description, final Throwable t) {
        super.log.logf(FQCN, ERROR, t, securityContextSetupFailed$str(), description);
    }
    protected String securityContextSetupFailed$str() {
        return "IJ000201: SecurityContext setup failed: %s";
    }
    @Override
    public final void securityContextSetupFailedCallbackSecurityNull() {
        super.log.logf(FQCN, ERROR, null, securityContextSetupFailedCallbackSecurityNull$str());
    }
    protected String securityContextSetupFailedCallbackSecurityNull$str() {
        return "IJ000202: SecurityContext setup failed since CallbackSecurity was null";
    }
    @Override
    public final void registeredNullHandleManagedConnection(final Object managedConnection) {
        super.log.logf(FQCN, INFO, null, registeredNullHandleManagedConnection$str(), managedConnection);
    }
    protected String registeredNullHandleManagedConnection$str() {
        return "IJ000301: Registered a null handle for managed connection: %s";
    }
    @Override
    public final void unregisteredHandleNotRegistered(final Object handle, final Object managedConnection) {
        super.log.logf(FQCN, INFO, null, unregisteredHandleNotRegistered$str(), handle, managedConnection);
    }
    protected String unregisteredHandleNotRegistered$str() {
        return "IJ000302: Unregistered handle that was not registered: %s for managed connection: %s";
    }
    @Override
    public final void unregisteredNullHandleManagedConnection(final Object managedConnection) {
        super.log.logf(FQCN, INFO, null, unregisteredNullHandleManagedConnection$str(), managedConnection);
    }
    protected String unregisteredNullHandleManagedConnection$str() {
        return "IJ000303: Unregistered a null handle for managed connection: %s";
    }
    @Override
    public final void connectionErrorOccured(final Object cl, final Throwable t) {
        super.log.logf(FQCN, WARN, t, connectionErrorOccured$str(), cl);
    }
    protected String connectionErrorOccured$str() {
        return "IJ000305: Connection error occured: %s";
    }
    @Override
    public final void unknownConnectionErrorOccured(final Object cl, final Throwable t) {
        super.log.logf(FQCN, WARN, t, unknownConnectionErrorOccured$str(), cl);
    }
    protected String unknownConnectionErrorOccured$str() {
        return "IJ000306: Unknown connection error occured: %s";
    }
    @Override
    public final void notifiedErrorDifferentManagedConnection() {
        super.log.logf(FQCN, WARN, null, notifiedErrorDifferentManagedConnection$str());
    }
    protected String notifiedErrorDifferentManagedConnection$str() {
        return "IJ000307: Notified of error on a different managed connection";
    }
    @Override
    public final void throwableFromUnregisterConnection(final Throwable t) {
        super.log.logf(FQCN, INFO, t, throwableFromUnregisterConnection$str());
    }
    protected String throwableFromUnregisterConnection$str() {
        return "IJ000311: Throwable from unregister connection";
    }
    @Override
    public final void errorWhileClosingConnectionHandle(final Throwable t) {
        super.log.logf(FQCN, ERROR, t, errorWhileClosingConnectionHandle$str());
    }
    protected String errorWhileClosingConnectionHandle$str() {
        return "IJ000312: Error while closing connection handle";
    }
    @Override
    public final void somethingWrongWithPooling(final Throwable t) {
        super.log.logf(FQCN, ERROR, t, somethingWrongWithPooling$str());
    }
    protected String somethingWrongWithPooling$str() {
        return "IJ000313: There is something wrong with the pooling";
    }
    @Override
    public final void beforeCompletionErrorOccured(final Object cl, final Throwable t) {
        super.log.logf(FQCN, WARN, t, beforeCompletionErrorOccured$str(), cl);
    }
    protected String beforeCompletionErrorOccured$str() {
        return "IJ000314: Error during beforeCompletion: %s";
    }
    @Override
    public final void activeHandles(final String pool, final int number) {
        super.log.logf(FQCN, ERROR, null, activeHandles$str(), pool, number);
    }
    protected String activeHandles$str() {
        return "IJ000315: Pool %s has %d active handles";
    }
    @Override
    public final void activeHandle(final Object handle, final Exception e) {
        super.log.logf(FQCN, ERROR, e, activeHandle$str(), handle);
    }
    protected String activeHandle$str() {
        return "IJ000316: Handle allocation: %s";
    }
    @Override
    public final void txConnectionListenerBoundary(final Exception e) {
        super.log.logf(FQCN, ERROR, e, txConnectionListenerBoundary$str());
    }
    protected String txConnectionListenerBoundary$str() {
        return "IJ000317: Transaction boundary";
    }
    @Override
    public final void delistingFailed(final String pool, final Exception e) {
        super.log.logf(FQCN, ERROR, e, delistingFailed$str(), pool);
    }
    protected String delistingFailed$str() {
        return "IJ000318: Delisting resource in pool %s failed";
    }
    @Override
    public final void errorDuringTidyUpConnection(final Object cl, final Throwable t) {
        super.log.logf(FQCN, WARN, t, errorDuringTidyUpConnection$str(), cl);
    }
    protected String errorDuringTidyUpConnection$str() {
        return "IJ000401: Error during tidy up connection: %s";
    }
    @Override
    public final void resourceExceptionReturningConnection(final Object mc, final Throwable t) {
        super.log.logf(FQCN, WARN, t, resourceExceptionReturningConnection$str(), mc);
    }
    protected String resourceExceptionReturningConnection$str() {
        return "IJ000402: ResourceException in returning connection: %s";
    }
    @Override
    public final void reconnectingConnectionHandleHasManagedConnection(final Object mc, final Object connection) {
        super.log.logf(FQCN, WARN, null, reconnectingConnectionHandleHasManagedConnection$str(), mc, connection);
    }
    protected String reconnectingConnectionHandleHasManagedConnection$str() {
        return "IJ000403: Reconnecting a connection handle that still has a managed connection: %s %s";
    }
    @Override
    public final void uncheckedThrowableInManagedConnectionDisconnected(final Object cl, final Throwable t) {
        super.log.logf(FQCN, WARN, t, uncheckedThrowableInManagedConnectionDisconnected$str(), cl);
    }
    protected String uncheckedThrowableInManagedConnectionDisconnected$str() {
        return "IJ000404: Unchecked throwable in managedConnectionDisconnected() cl=%s";
    }
    @Override
    public final void multipleLocalTransactionConnectionListenerEnlisted(final String name, final Object cl) {
        super.log.logf(FQCN, WARN, null, multipleLocalTransactionConnectionListenerEnlisted$str(), name, cl);
    }
    protected String multipleLocalTransactionConnectionListenerEnlisted$str() {
        return "IJ000405: Multiple LocalTransaction connection listeners enlisted for %s, cl=%s";
    }
    @Override
    public final void throwableReturningConnection(final Object mc, final Throwable t) {
        super.log.logf(FQCN, ERROR, t, throwableReturningConnection$str(), mc);
    }
    protected String throwableReturningConnection$str() {
        return "IJ000406: Throwable in returning connection: %s";
    }
    @Override
    public final void noLazyEnlistmentAvailable(final String pool) {
        super.log.logf(FQCN, WARN, null, noLazyEnlistmentAvailable$str(), pool);
    }
    protected String noLazyEnlistmentAvailable$str() {
        return "IJ000407: No lazy enlistment available for %s";
    }
    @Override
    public final void deprecatedPool(final String oldPool, final String newPool) {
        super.log.logf(FQCN, WARN, null, deprecatedPool$str(), oldPool, newPool);
    }
    protected String deprecatedPool$str() {
        return "IJ000408: Deprecated pool: %s, using %s instead";
    }
    @Override
    public final void threadIsnotEnlistingThread(final Object currentThread, final Object enlistingThread, final Throwable t) {
        super.log.logf(FQCN, WARN, t, threadIsnotEnlistingThread$str(), currentThread, enlistingThread);
    }
    protected String threadIsnotEnlistingThread$str() {
        return "IJ000501: Thread %s is not the enlisting thread %s";
    }
    @Override
    public final void transactionErrorInBeforeCompletion(final Object transaction, final Object synch, final Throwable t) {
        super.log.logf(FQCN, WARN, t, transactionErrorInBeforeCompletion$str(), transaction, synch);
    }
    protected String transactionErrorInBeforeCompletion$str() {
        return "IJ000502: Transaction %s error in beforeCompletion %s";
    }
    @Override
    public final void transactionErrorInAfterCompletion(final Object transaction, final Object synch, final Throwable t) {
        super.log.logf(FQCN, WARN, t, transactionErrorInAfterCompletion$str(), transaction, synch);
    }
    protected String transactionErrorInAfterCompletion$str() {
        return "IJ000503: Transaction %s error in afterCompletion %s";
    }
    @Override
    public final void transactionNotFound(final Object transaction) {
        super.log.logf(FQCN, WARN, null, transactionNotFound$str(), transaction);
    }
    protected String transactionNotFound$str() {
        return "IJ000504: Transaction not found: %s";
    }
    @Override
    public final void returningConnectionValidatorInterrupted() {
        super.log.logf(FQCN, INFO, null, returningConnectionValidatorInterrupted$str());
    }
    protected String returningConnectionValidatorInterrupted$str() {
        return "IJ000601: ConnectionValidator has been interrupted";
    }
    @Override
    public final void connectionValidatorIgnoredUnexpectedRuntimeException(final Throwable t) {
        super.log.logf(FQCN, WARN, t, connectionValidatorIgnoredUnexpectedRuntimeException$str());
    }
    protected String connectionValidatorIgnoredUnexpectedRuntimeException$str() {
        return "IJ000602: ConnectionValidator ignored unexpected runtime exception";
    }
    @Override
    public final void connectionValidatorIgnoredUnexpectedError(final Throwable t) {
        super.log.logf(FQCN, WARN, t, connectionValidatorIgnoredUnexpectedError$str());
    }
    protected String connectionValidatorIgnoredUnexpectedError$str() {
        return "IJ000603: ConnectionValidator ignored unexpected error";
    }
    @Override
    public final void throwableWhileAttemptingGetNewGonnection(final Object cl, final Throwable t) {
        super.log.logf(FQCN, WARN, t, throwableWhileAttemptingGetNewGonnection$str(), cl);
    }
    protected String throwableWhileAttemptingGetNewGonnection$str() {
        return "IJ000604: Throwable while attempting to get a new connection: %s";
    }
    @Override
    public final void destroyingConnectionNotSuccessfullyMatched(final Object cl, final Object mcf) {
        super.log.logf(FQCN, WARN, null, destroyingConnectionNotSuccessfullyMatched2$str(), cl, mcf);
    }
    protected String destroyingConnectionNotSuccessfullyMatched2$str() {
        return "IJ000605: Destroying connection that could not be successfully matched %s for %s";
    }
    @Override
    public final void throwableWhileTryingMatchManagedConnection(final Object cl, final Throwable t) {
        super.log.logf(FQCN, WARN, t, throwableWhileTryingMatchManagedConnection$str(), cl);
    }
    protected String throwableWhileTryingMatchManagedConnection$str() {
        return "IJ000606: Throwable while trying to match managed connection, destroying connection: %s";
    }
    @Override
    public final void resourceExceptionCleaningUpManagedConnection(final Object cl, final Throwable t) {
        super.log.logf(FQCN, WARN, t, resourceExceptionCleaningUpManagedConnection$str(), cl);
    }
    protected String resourceExceptionCleaningUpManagedConnection$str() {
        return "IJ000607: ResourceException cleaning up managed connection: %s";
    }
    @Override
    public final void destroyingReturnedConnectionMaximumPoolSizeExceeded(final Object cl) {
        super.log.logf(FQCN, WARN, null, destroyingReturnedConnectionMaximumPoolSizeExceeded$str(), cl);
    }
    protected String destroyingReturnedConnectionMaximumPoolSizeExceeded$str() {
        return "IJ000608: Destroying returned connection, maximum pool size exceeded %s";
    }
    @Override
    public final void attemptReturnConnectionTwice(final Object cl, final Throwable t) {
        super.log.logf(FQCN, WARN, t, attemptReturnConnectionTwice$str(), cl);
    }
    protected String attemptReturnConnectionTwice$str() {
        return "IJ000609: Attempt to return connection twice: %s";
    }
    @Override
    public final void unableFillPool(final Throwable t, final String jndiName) {
        super.log.logf(FQCN, WARN, t, unableFillPool$str(), jndiName);
    }
    protected String unableFillPool$str() {
        return "IJ000610: Unable to fill pool: %s";
    }
    @Override
    public final void backgroundValidationNonCompliantManagedConnectionFactory() {
        super.log.logf(FQCN, WARN, null, backgroundValidationNonCompliantManagedConnectionFactory$str());
    }
    protected String backgroundValidationNonCompliantManagedConnectionFactory$str() {
        return "IJ000611: Warning: Background validation was specified with a non compliant ManagedConnectionFactory interface";
    }
    @Override
    public final void destroyingConnectionNotSuccessfullyMatched(final Object cl) {
        super.log.logf(FQCN, WARN, null, destroyingConnectionNotSuccessfullyMatched1$str(), cl);
    }
    protected String destroyingConnectionNotSuccessfullyMatched1$str() {
        return "IJ000612: Destroying connection that could not be successfully matched: %s";
    }
    @Override
    public final void throwableWhileTryingMatchManagedConnectionThenDestroyingConnection(final Object cl, final Throwable t) {
        super.log.logf(FQCN, WARN, t, throwableWhileTryingMatchManagedConnectionThenDestroyingConnection$str(), cl);
    }
    protected String throwableWhileTryingMatchManagedConnectionThenDestroyingConnection$str() {
        return "IJ000613: Throwable while trying to match managed connection, destroying connection: %s";
    }
    @Override
    public final void exceptionDuringCreateSubject(final String jndiName, final String description, final Throwable t) {
        super.log.logf(FQCN, ERROR, t, exceptionDuringCreateSubject$str(), jndiName, description);
    }
    protected String exceptionDuringCreateSubject$str() {
        return "IJ000614: Exception during createSubject() for %s: %s";
    }
    @Override
    public final void destroyingActiveConnection(final String poolName, final Object mc) {
        super.log.logf(FQCN, WARN, null, destroyingActiveConnection$str(), poolName, mc);
    }
    protected String destroyingActiveConnection$str() {
        return "IJ000615: Destroying active connection in pool: %s (%s)";
    }
    @Override
    public final void connectionLeak(final String poolName, final String id, final long time, final Throwable t) {
        super.log.logf(FQCN, ERROR, t, connectionLeak$str(), poolName, id, time);
    }
    protected String connectionLeak$str() {
        return "IJ000616: Leak detected in pool: %s (%s) (%d)";
    }
    @Override
    public final void invalidCapacityIncrementer(final String clz) {
        super.log.logf(FQCN, WARN, null, invalidCapacityIncrementer$str(), clz);
    }
    protected String invalidCapacityIncrementer$str() {
        return "IJ000617: Invalid incrementer capacity policy: %s";
    }
    @Override
    public final void invalidCapacityDecrementer(final String clz) {
        super.log.logf(FQCN, WARN, null, invalidCapacityDecrementer$str(), clz);
    }
    protected String invalidCapacityDecrementer$str() {
        return "IJ000618: Invalid decrementer capacity policy: %s";
    }
    @Override
    public final void invalidCapacityOption(final String key, final String value, final String policy) {
        super.log.logf(FQCN, WARN, null, invalidCapacityOption$str(), key, value, policy);
    }
    protected String invalidCapacityOption$str() {
        return "IJ000619: Invalid property '%s' with value '%s' for %s";
    }
    @Override
    public final void validateOnMatchNonCompliantManagedConnectionFactory(final String mcf) {
        super.log.logf(FQCN, WARN, null, validateOnMatchNonCompliantManagedConnectionFactory$str(), mcf);
    }
    protected String validateOnMatchNonCompliantManagedConnectionFactory$str() {
        return "IJ000620: Warning: ValidateOnMatch validation was specified with a non compliant ManagedConnectionFactory: %s";
    }
    @Override
    public final void destroyingConnectionNotValidated(final Object cl) {
        super.log.logf(FQCN, WARN, null, destroyingConnectionNotValidated$str(), cl);
    }
    protected String destroyingConnectionNotValidated$str() {
        return "IJ000621: Destroying connection that could not be validated: %s";
    }
    @Override
    public final void unsupportedPoolImplementation(final String clz) {
        super.log.logf(FQCN, WARN, null, unsupportedPoolImplementation$str(), clz);
    }
    protected String unsupportedPoolImplementation$str() {
        return "IJ000622: Unsupported pool implementation: %s";
    }
    @Override
    public final void exceptionDuringUnbind(final Throwable t) {
        super.log.logf(FQCN, WARN, t, exceptionDuringUnbind$str());
    }
    protected String exceptionDuringUnbind$str() {
        return "IJ000701: Exception during unbind";
    }
    @Override
    public final void exceptionDuringConnectionClose(final Throwable t) {
        super.log.logf(FQCN, WARN, t, exceptionDuringConnectionClose$str());
    }
    protected String exceptionDuringConnectionClose$str() {
        return "IJ000901: Error during connection close";
    }
    @Override
    public final void exceptionDuringCrashRecoveryInflow(final String rar, final Object as, final Throwable t) {
        super.log.logf(FQCN, ERROR, t, exceptionDuringCrashRecoveryInflow$str(), rar, as);
    }
    protected String exceptionDuringCrashRecoveryInflow$str() {
        return "IJ000902: Error during inflow crash recovery for '%s' (%s)";
    }
    @Override
    public final void exceptionDuringCrashRecoverySubject(final String jndiName, final String reason, final Throwable t) {
        super.log.logf(FQCN, ERROR, t, exceptionDuringCrashRecoverySubject$str(), jndiName, reason);
    }
    protected String exceptionDuringCrashRecoverySubject$str() {
        return "IJ000903: Error creating Subject for crash recovery: %s (%s)";
    }
    @Override
    public final void noCrashRecoverySecurityDomain(final String jndiName) {
        super.log.logf(FQCN, WARN, null, noCrashRecoverySecurityDomain$str(), jndiName);
    }
    protected String noCrashRecoverySecurityDomain$str() {
        return "IJ000904: No security domain defined for crash recovery: %s";
    }
    @Override
    public final void nullSubjectCrashRecovery(final String jndiName) {
        super.log.logf(FQCN, WARN, null, nullSubjectCrashRecovery$str(), jndiName);
    }
    protected String nullSubjectCrashRecovery$str() {
        return "IJ000905: Subject for crash recovery was null: %s";
    }
    @Override
    public final void exceptionDuringCrashRecovery(final String jndiName, final String reason, final Throwable t) {
        super.log.logf(FQCN, ERROR, t, exceptionDuringCrashRecovery$str(), jndiName, reason);
    }
    protected String exceptionDuringCrashRecovery$str() {
        return "IJ000906: Error during crash recovery: %s (%s)";
    }
    @Override
    public final void noUsersPropertiesFound() {
        super.log.logf(FQCN, WARN, null, noUsersPropertiesFound$str());
    }
    protected String noUsersPropertiesFound$str() {
        return "IJ001001: No users.properties were found";
    }
    @Override
    public final void errorWhileLoadingUsersProperties(final Throwable t) {
        super.log.logf(FQCN, ERROR, t, errorWhileLoadingUsersProperties$str());
    }
    protected String errorWhileLoadingUsersProperties$str() {
        return "IJ001002: Error while loading users.properties";
    }
    @Override
    public final void noRolesPropertiesFound() {
        super.log.logf(FQCN, WARN, null, noRolesPropertiesFound$str());
    }
    protected String noRolesPropertiesFound$str() {
        return "IJ001003: No roles.properties were found";
    }
    @Override
    public final void errorWhileLoadingRolesProperties(final Throwable t) {
        super.log.logf(FQCN, ERROR, t, errorWhileLoadingRolesProperties$str());
    }
    protected String errorWhileLoadingRolesProperties$str() {
        return "IJ001004: Error while loading roles.properties";
    }
    @Override
    public final void noCallbackPropertiesFound() {
        super.log.logf(FQCN, WARN, null, noCallbackPropertiesFound$str());
    }
    protected String noCallbackPropertiesFound$str() {
        return "IJ001005: No callback.properties were found";
    }
    @Override
    public final void errorWhileLoadingCallbackProperties(final Throwable t) {
        super.log.logf(FQCN, ERROR, t, errorWhileLoadingCallbackProperties$str());
    }
    protected String errorWhileLoadingCallbackProperties$str() {
        return "IJ001006: Error while loading callback.properties";
    }
    @Override
    public final void prepareCalledOnLocaltx() {
        super.log.logf(FQCN, WARN, null, prepareCalledOnLocaltx$str());
    }
    protected String prepareCalledOnLocaltx$str() {
        return "IJ001101: Prepare called on a local tx. Use of local transactions on a JTA transaction with more than one branch may result in inconsistent data in some cases of failure";
    }
}
