/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jca.deployers.fungal;

import com.github.fungal.spi.deployers.Deployment;
import java.io.Closeable;
import java.io.IOException;
import java.net.URL;
import java.util.List;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.resource.spi.ResourceAdapter;
import org.jboss.jca.core.api.management.DataSource;
import org.jboss.jca.core.api.management.ManagementRepository;
import org.jboss.jca.core.bootstrapcontext.BootstrapContextCoordinator;
import org.jboss.jca.core.connectionmanager.ConnectionManager;
import org.jboss.jca.core.naming.ExplicitJndiStrategy;
import org.jboss.jca.core.spi.rar.NotFoundException;
import org.jboss.jca.core.spi.rar.ResourceAdapterRepository;
import org.jboss.jca.core.spi.transaction.recovery.XAResourceRecovery;
import org.jboss.jca.core.spi.transaction.recovery.XAResourceRecoveryRegistry;
import org.jboss.jca.deployers.DeployersLogger;
import org.jboss.logging.Logger;

public class DsXmlDeployment
implements Deployment {
    private static DeployersLogger log = (DeployersLogger)Logger.getMessageLogger(DeployersLogger.class, (String)DsXmlDeployment.class.getName());
    private URL deployment;
    private String deploymentName;
    private ResourceAdapter ra;
    private String raKey;
    private String bootstrapContextId;
    private ResourceAdapterRepository rar;
    private Object[] cfs;
    private String[] jndis;
    private ConnectionManager[] cms;
    private XAResourceRecovery[] recoveryModules;
    private XAResourceRecoveryRegistry recoveryRegistry;
    private DataSource[] dataSources;
    private ManagementRepository managementRepository;
    private List<ObjectName> objectNames;
    private MBeanServer mbeanServer;
    private ClassLoader cl;

    public DsXmlDeployment(URL deployment, String deploymentName, ResourceAdapter ra, String raKey, String bootstrapContextId, ResourceAdapterRepository resourceAdapterRepository, Object[] cfs, String[] jndis, ConnectionManager[] cms, XAResourceRecovery[] recoveryModules, XAResourceRecoveryRegistry recoveryRegistry, DataSource[] dataSources, ManagementRepository managementRepository, List<ObjectName> onames, MBeanServer mbeanServer, ClassLoader cl) {
        this.deployment = deployment;
        this.deploymentName = deploymentName;
        this.ra = ra;
        this.raKey = raKey;
        this.bootstrapContextId = bootstrapContextId;
        this.rar = resourceAdapterRepository;
        this.cfs = cfs;
        this.jndis = jndis;
        this.cms = cms;
        this.recoveryModules = recoveryModules;
        this.recoveryRegistry = recoveryRegistry;
        this.dataSources = dataSources;
        this.managementRepository = managementRepository;
        this.objectNames = onames;
        this.mbeanServer = mbeanServer;
        this.cl = cl;
    }

    public URL getURL() {
        return this.deployment;
    }

    public ClassLoader getClassLoader() {
        return this.cl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public void stop() {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Undeploying: " + this.deployment.toExternalForm()));
        }
        if (this.objectNames != null && this.mbeanServer != null) {
            for (ObjectName on : this.objectNames) {
                try {
                    this.mbeanServer.unregisterMBean(on);
                }
                catch (Throwable t) {
                    log.warn((Object)"Exception during JMX unregistering", t);
                }
            }
        }
        if (this.dataSources != null && this.managementRepository != null) {
            for (DataSource dataSource : this.dataSources) {
                this.managementRepository.getDataSources().remove(dataSource);
            }
        }
        if (this.recoveryModules != null && this.recoveryRegistry != null) {
            for (DataSource dataSource : this.recoveryModules) {
                if (dataSource == null) continue;
                try {
                    dataSource.shutdown();
                }
                catch (Exception e) {
                    log.error((Object)"Error during recovery shutdown", (Throwable)e);
                }
                finally {
                    this.recoveryRegistry.removeXAResourceRecovery((XAResourceRecovery)dataSource);
                }
            }
        }
        if (this.cms != null) {
            for (DataSource dataSource : this.cms) {
                dataSource.shutdown();
            }
        }
        if (this.cfs != null) {
            ExplicitJndiStrategy jndiStrategy = new ExplicitJndiStrategy();
            try {
                void var4_20;
                jndiStrategy.unbindConnectionFactories(this.deploymentName, this.cfs, this.jndis);
                String[] on = this.jndis;
                int n = on.length;
                boolean bl = false;
                while (var4_20 < n) {
                    String jndi = on[var4_20];
                    log.infof("Unbound data source at: %s", (Object)jndi);
                    ++var4_20;
                }
            }
            catch (Throwable t) {
                log.warn((Object)"Exception during JNDI unbinding", t);
            }
        }
        if (this.raKey != null && this.rar != null) {
            try {
                this.rar.unregisterResourceAdapter(this.raKey);
            }
            catch (NotFoundException nfe) {
                log.warn((Object)"Exception during unregistering deployment", (Throwable)nfe);
            }
        }
        if (this.ra != null) {
            this.ra.stop();
            this.ra = null;
            if (this.bootstrapContextId != null) {
                BootstrapContextCoordinator.getInstance().removeBootstrapContext(this.bootstrapContextId);
            }
        }
    }

    public void destroy() {
        if (this.cl != null && this.cl instanceof Closeable) {
            try {
                ((Closeable)((Object)this.cl)).close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

