/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jca.adapters.jdbc;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Serializable;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import javax.resource.ResourceException;
import javax.resource.spi.ConnectionManager;
import javax.resource.spi.ConnectionRequestInfo;
import javax.resource.spi.ManagedConnectionFactory;
import javax.resource.spi.ValidatingManagedConnectionFactory;
import javax.resource.spi.security.PasswordCredential;
import javax.security.auth.Subject;
import javax.transaction.TransactionSynchronizationRegistry;
import javax.transaction.UserTransaction;
import org.jboss.jca.adapters.jdbc.BaseWrapperManagedConnection;
import org.jboss.jca.adapters.jdbc.CheckValidConnectionSQL;
import org.jboss.jca.adapters.jdbc.WrappedConnectionRequestInfo;
import org.jboss.jca.adapters.jdbc.WrapperDataSource;
import org.jboss.jca.adapters.jdbc.classloading.TCClassLoaderPlugin;
import org.jboss.jca.adapters.jdbc.extensions.novendor.NullExceptionSorter;
import org.jboss.jca.adapters.jdbc.extensions.novendor.NullStaleConnectionChecker;
import org.jboss.jca.adapters.jdbc.extensions.novendor.NullValidConnectionChecker;
import org.jboss.jca.adapters.jdbc.spi.ClassLoaderPlugin;
import org.jboss.jca.adapters.jdbc.spi.ExceptionSorter;
import org.jboss.jca.adapters.jdbc.spi.StaleConnectionChecker;
import org.jboss.jca.adapters.jdbc.spi.ValidConnectionChecker;
import org.jboss.jca.adapters.jdbc.spi.listener.ConnectionListener;
import org.jboss.jca.adapters.jdbc.spi.reauth.ReauthPlugin;
import org.jboss.jca.adapters.jdbc.statistics.JdbcStatisticsPlugin;
import org.jboss.jca.adapters.jdbc.util.Injection;
import org.jboss.jca.core.spi.statistics.Statistics;
import org.jboss.logging.Logger;

public abstract class BaseWrapperManagedConnectionFactory
implements ManagedConnectionFactory,
ValidatingManagedConnectionFactory,
Statistics,
Serializable {
    static final long serialVersionUID = -84923705377702088L;
    public static final int TRACK_STATEMENTS_FALSE_INT = 0;
    public static final int TRACK_STATEMENTS_TRUE_INT = 1;
    public static final int TRACK_STATEMENTS_NOWARN_INT = 2;
    public static final String TRACK_STATEMENTS_FALSE = "false";
    public static final String TRACK_STATEMENTS_TRUE = "true";
    public static final String TRACK_STATEMENTS_NOWARN = "nowarn";
    protected final Logger log = Logger.getLogger(this.getClass());
    private PrintWriter printWriter;
    protected String userName;
    protected String password;
    protected final Properties connectionProps = new Properties();
    protected int transactionIsolation = -1;
    protected Integer preparedStatementCacheSize = 0;
    protected boolean doQueryTimeout = false;
    protected String newConnectionSQL;
    protected String checkValidConnectionSQL;
    protected String validConnectionCheckerClassName;
    private String validConnectionCheckerProperties;
    protected final Properties validConnectionCheckerProps = new Properties();
    protected ValidConnectionChecker connectionChecker;
    protected StaleConnectionChecker staleConnectionChecker;
    private String staleConnectionCheckerClassName;
    private String staleConnectionCheckerProperties;
    protected final Properties staleConnectionCheckerProps = new Properties();
    private String exceptionSorterClassName;
    private String exceptionSorterProperties;
    private final Properties exceptionSorterProps = new Properties();
    private ExceptionSorter exceptionSorter;
    protected int trackStatements = 2;
    protected Boolean sharePS = Boolean.FALSE;
    protected Boolean isTransactionQueryTimeout = Boolean.FALSE;
    protected Integer queryTimeout = 0;
    protected String urlDelimiter;
    protected String urlSelectorStrategyClassName;
    private Boolean validateOnMatch = Boolean.TRUE;
    private Integer useTryLock = 60;
    private Boolean spy = Boolean.FALSE;
    private String jndiName;
    private Boolean reauthEnabled = Boolean.FALSE;
    private String reauthPluginClassName;
    private String reauthPluginProperties;
    private ReauthPlugin reauthPlugin;
    private ClassLoaderPlugin classLoaderPlugin;
    private String userTransactionJndiName;
    private UserTransaction userTransaction;
    private TransactionSynchronizationRegistry tsr;
    private JdbcStatisticsPlugin statisticsPlugin = new JdbcStatisticsPlugin();
    private Boolean jta = Boolean.TRUE;
    private String connectionListenerClassName;
    private String connectionListenerProperties;
    private ConnectionListener connectionListenerPlugin;

    public PrintWriter getLogWriter() throws ResourceException {
        return this.printWriter;
    }

    public void setLogWriter(PrintWriter v) throws ResourceException {
        this.printWriter = v;
    }

    public Object createConnectionFactory(ConnectionManager cm) throws ResourceException {
        return new WrapperDataSource(this, cm);
    }

    public Object createConnectionFactory() throws ResourceException {
        throw new ResourceException("Resource Adapter does not currently support running in a non-managed environment.");
    }

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public Integer getPreparedStatementCacheSize() {
        return this.preparedStatementCacheSize;
    }

    public void setPreparedStatementCacheSize(Integer size) {
        if (size != null) {
            this.preparedStatementCacheSize = size;
        }
    }

    public Boolean getSharePreparedStatements() {
        return this.sharePS;
    }

    public void setSharePreparedStatements(Boolean sharePS) {
        if (sharePS != null) {
            this.sharePS = sharePS;
        }
    }

    public String getTransactionIsolation() {
        switch (this.transactionIsolation) {
            case 0: {
                return "TRANSACTION_NONE";
            }
            case 2: {
                return "TRANSACTION_READ_COMMITTED";
            }
            case 1: {
                return "TRANSACTION_READ_UNCOMMITTED";
            }
            case 4: {
                return "TRANSACTION_REPEATABLE_READ";
            }
            case 8: {
                return "TRANSACTION_SERIALIZABLE";
            }
            case -1: {
                return "DEFAULT";
            }
        }
        return Integer.toString(this.transactionIsolation);
    }

    public void setTransactionIsolation(String transactionIsolation) {
        if (transactionIsolation.equals("TRANSACTION_NONE")) {
            this.transactionIsolation = 0;
        } else if (transactionIsolation.equals("TRANSACTION_READ_COMMITTED")) {
            this.transactionIsolation = 2;
        } else if (transactionIsolation.equals("TRANSACTION_READ_UNCOMMITTED")) {
            this.transactionIsolation = 1;
        } else if (transactionIsolation.equals("TRANSACTION_REPEATABLE_READ")) {
            this.transactionIsolation = 4;
        } else if (transactionIsolation.equals("TRANSACTION_SERIALIZABLE")) {
            this.transactionIsolation = 8;
        } else {
            try {
                this.transactionIsolation = Integer.parseInt(transactionIsolation);
            }
            catch (NumberFormatException nfe) {
                throw new IllegalArgumentException("Setting Isolation level to unknown state: " + transactionIsolation);
            }
        }
    }

    public String getNewConnectionSQL() {
        return this.newConnectionSQL;
    }

    public void setNewConnectionSQL(String newConnectionSQL) {
        this.newConnectionSQL = newConnectionSQL;
    }

    public String getCheckValidConnectionSQL() {
        return this.checkValidConnectionSQL;
    }

    public void setCheckValidConnectionSQL(String checkValidConnectionSQL) {
        this.checkValidConnectionSQL = checkValidConnectionSQL;
    }

    public String getStaleConnectionCheckerClassName() {
        return this.staleConnectionCheckerClassName;
    }

    public void setStaleConnectionCheckerClassName(String value) {
        this.staleConnectionCheckerClassName = value;
    }

    public String getTrackStatements() {
        if (this.trackStatements == 0) {
            return TRACK_STATEMENTS_FALSE;
        }
        if (this.trackStatements == 1) {
            return TRACK_STATEMENTS_TRUE;
        }
        return TRACK_STATEMENTS_NOWARN;
    }

    public void setTrackStatements(String value) {
        if (value == null) {
            throw new IllegalArgumentException("Null value for trackStatements");
        }
        String trimmed = value.trim();
        this.trackStatements = trimmed.equalsIgnoreCase(TRACK_STATEMENTS_FALSE) ? 0 : (trimmed.equalsIgnoreCase(TRACK_STATEMENTS_TRUE) ? 1 : 2);
    }

    public Boolean getValidateOnMatch() {
        return this.validateOnMatch;
    }

    public void setValidateOnMatch(Boolean validateOnMatch) {
        if (validateOnMatch != null) {
            this.validateOnMatch = validateOnMatch;
        }
    }

    public String getExceptionSorterClassName() {
        return this.exceptionSorterClassName;
    }

    public void setExceptionSorterClassName(String exceptionSorterClassName) {
        this.exceptionSorterClassName = exceptionSorterClassName;
    }

    public String getValidConnectionCheckerClassName() {
        return this.validConnectionCheckerClassName;
    }

    public void setValidConnectionCheckerClassName(String value) {
        this.validConnectionCheckerClassName = value;
    }

    public Boolean isTransactionQueryTimeout() {
        return this.isTransactionQueryTimeout;
    }

    public void setTransactionQueryTimeout(Boolean value) {
        if (value != null) {
            this.isTransactionQueryTimeout = value;
        }
    }

    public Integer getQueryTimeout() {
        return this.queryTimeout;
    }

    public void setQueryTimeout(Integer timeout) {
        if (timeout != null) {
            this.queryTimeout = timeout;
        }
    }

    public Integer getUseTryLock() {
        return this.useTryLock;
    }

    public void setUseTryLock(Integer useTryLock) {
        if (useTryLock != null) {
            this.useTryLock = useTryLock;
        }
    }

    public void setSpy(Boolean v) {
        if (v != null) {
            this.spy = v;
        }
    }

    public Boolean getSpy() {
        return this.spy;
    }

    public void setJndiName(String v) {
        if (v != null) {
            this.jndiName = v;
        }
    }

    public String getJndiName() {
        return this.jndiName;
    }

    public Boolean getReauthEnabled() {
        return this.reauthEnabled;
    }

    public void setReauthEnabled(Boolean v) {
        if (v != null) {
            this.reauthEnabled = v;
        }
    }

    public String getReauthPluginClassName() {
        return this.reauthPluginClassName;
    }

    public void setReauthPluginClassName(String v) {
        if (v != null) {
            this.reauthPluginClassName = v;
        }
    }

    public String getReauthPluginProperties() {
        return this.reauthPluginProperties;
    }

    public void setReauthPluginProperties(String v) {
        if (v != null) {
            this.reauthPluginProperties = v;
        }
    }

    synchronized void loadReauthPlugin() throws ResourceException {
        if (this.reauthPlugin != null) {
            return;
        }
        if (Boolean.FALSE.equals(this.reauthEnabled)) {
            throw new IllegalStateException("Reauthentication not enabled");
        }
        if (this.reauthPluginClassName == null || this.reauthPluginClassName.trim().equals("")) {
            throw new IllegalStateException("ReauthPlugin class name not defined");
        }
        Class<?> clz = null;
        ClassLoader usedCl = null;
        try {
            clz = Class.forName(this.reauthPluginClassName, true, this.getClassLoaderPlugin().getClassLoader());
            usedCl = this.getClassLoaderPlugin().getClassLoader();
        }
        catch (ClassNotFoundException cnfe) {
            // empty catch block
        }
        if (clz == null) {
            try {
                clz = Class.forName(this.reauthPluginClassName, true, new TCClassLoaderPlugin().getClassLoader());
                usedCl = new TCClassLoaderPlugin().getClassLoader();
            }
            catch (ClassNotFoundException cnfe) {
                // empty catch block
            }
        }
        if (clz == null) {
            try {
                clz = Class.forName(this.reauthPluginClassName, true, BaseWrapperManagedConnectionFactory.class.getClassLoader());
                usedCl = BaseWrapperManagedConnectionFactory.class.getClassLoader();
            }
            catch (ClassNotFoundException cnfe) {
                throw new ResourceException("Error during loading reauth plugin", (Throwable)cnfe);
            }
        }
        try {
            this.reauthPlugin = (ReauthPlugin)clz.newInstance();
            if (this.reauthPluginProperties != null) {
                Injection injector = new Injection();
                StringTokenizer st = new StringTokenizer(this.reauthPluginProperties, ",");
                while (st.hasMoreTokens()) {
                    String keyValue = st.nextToken();
                    int split = keyValue.indexOf("|");
                    if (split == -1) {
                        throw new IllegalStateException("Reauth plugin property incorrect: " + keyValue);
                    }
                    String key = keyValue.substring(0, split);
                    String value = "";
                    if (keyValue.length() > split + 1) {
                        value = keyValue.substring(split + 1);
                    }
                    injector.inject(this.reauthPlugin, key, value);
                }
            }
            this.reauthPlugin.initialize(usedCl);
        }
        catch (Throwable t) {
            throw new ResourceException("Error during loading reauth plugin", t);
        }
    }

    ReauthPlugin getReauthPlugin() {
        return this.reauthPlugin;
    }

    public String getConnectionListenerClassName() {
        return this.connectionListenerClassName;
    }

    public void setConnectionListenerClassName(String v) {
        if (v != null) {
            this.connectionListenerClassName = v;
        }
    }

    public String getConnectionListenerProperties() {
        return this.connectionListenerProperties;
    }

    public void setConnectionListenerProperties(String v) {
        if (v != null) {
            this.connectionListenerProperties = v;
        }
    }

    synchronized void loadConnectionListenerPlugin() throws ResourceException {
        if (this.connectionListenerPlugin != null) {
            return;
        }
        if (this.connectionListenerClassName == null || this.connectionListenerClassName.trim().equals("")) {
            throw new IllegalStateException("ConnectionListener class name not defined");
        }
        Class<?> clz = null;
        ClassLoader usedCl = null;
        try {
            clz = Class.forName(this.connectionListenerClassName, true, this.getClassLoaderPlugin().getClassLoader());
            usedCl = this.getClassLoaderPlugin().getClassLoader();
        }
        catch (ClassNotFoundException cnfe) {
            // empty catch block
        }
        if (clz == null) {
            try {
                clz = Class.forName(this.connectionListenerClassName, true, new TCClassLoaderPlugin().getClassLoader());
                usedCl = new TCClassLoaderPlugin().getClassLoader();
            }
            catch (ClassNotFoundException cnfe) {
                // empty catch block
            }
        }
        if (clz == null) {
            try {
                clz = Class.forName(this.connectionListenerClassName, true, BaseWrapperManagedConnectionFactory.class.getClassLoader());
                usedCl = BaseWrapperManagedConnectionFactory.class.getClassLoader();
            }
            catch (ClassNotFoundException cnfe) {
                throw new ResourceException("Error during loading connection listener", (Throwable)cnfe);
            }
        }
        try {
            this.connectionListenerPlugin = (ConnectionListener)clz.newInstance();
            if (this.connectionListenerProperties != null) {
                Injection injector = new Injection();
                StringTokenizer st = new StringTokenizer(this.connectionListenerProperties, ",");
                while (st.hasMoreTokens()) {
                    String keyValue = st.nextToken();
                    int split = keyValue.indexOf("|");
                    if (split == -1) {
                        throw new IllegalStateException("ConnectionListener property incorrect: " + keyValue);
                    }
                    String key = keyValue.substring(0, split);
                    String value = "";
                    if (keyValue.length() > split + 1) {
                        value = keyValue.substring(split + 1);
                    }
                    injector.inject(this.connectionListenerPlugin, key, value);
                }
            }
            this.connectionListenerPlugin.initialize(usedCl);
        }
        catch (Throwable t) {
            throw new ResourceException("Error during loading connection listener plugin", t);
        }
    }

    ConnectionListener getConnectionListenerPlugin() {
        try {
            if (this.connectionListenerClassName != null && this.connectionListenerPlugin == null) {
                this.loadConnectionListenerPlugin();
            }
            return this.connectionListenerPlugin;
        }
        catch (ResourceException re) {
            this.log.warn((Object)re.getMessage(), (Throwable)re);
            return null;
        }
    }

    public String getURLDelimiter() {
        return this.urlDelimiter;
    }

    public void setURLDelimiter(String urlDelimiter) {
        this.urlDelimiter = urlDelimiter;
    }

    public String getUrlSelectorStrategyClassName() {
        return this.urlSelectorStrategyClassName;
    }

    public void setUrlSelectorStrategyClassName(String urlSelectorStrategyClassName) {
        this.urlSelectorStrategyClassName = urlSelectorStrategyClassName;
    }

    public String getUserTransactionJndiName() {
        if (this.userTransactionJndiName == null || this.userTransactionJndiName.trim().equals("")) {
            return "java:/UserTransaction";
        }
        return this.userTransactionJndiName;
    }

    public void setUserTransactionJndiName(String v) {
        this.userTransactionJndiName = v;
    }

    protected UserTransaction getUserTransaction() {
        return this.userTransaction;
    }

    protected void setUserTransaction(UserTransaction v) {
        this.userTransaction = v;
    }

    protected TransactionSynchronizationRegistry getTransactionSynchronizationRegistry() {
        return this.tsr;
    }

    protected void setTransactionSynchronizationRegistry(TransactionSynchronizationRegistry v) {
        this.tsr = v;
    }

    public JdbcStatisticsPlugin getStatistics() {
        return this.statisticsPlugin;
    }

    public Boolean isJTA() {
        return this.jta;
    }

    public void setJTA(Boolean v) {
        if (v != null) {
            this.jta = v;
        }
    }

    public Set<BaseWrapperManagedConnection> getInvalidConnections(Set connectionSet) throws ResourceException {
        HashSet<BaseWrapperManagedConnection> invalid = new HashSet<BaseWrapperManagedConnection>();
        for (Object anonymous : connectionSet) {
            BaseWrapperManagedConnection mc;
            if (!(anonymous instanceof BaseWrapperManagedConnection) || (mc = (BaseWrapperManagedConnection)anonymous).checkValid()) continue;
            invalid.add(mc);
        }
        return invalid;
    }

    protected synchronized Properties getConnectionProperties(Subject subject, ConnectionRequestInfo cri) throws ResourceException {
        if (cri != null && cri.getClass() != WrappedConnectionRequestInfo.class) {
            throw new ResourceException("Wrong kind of ConnectionRequestInfo: " + cri.getClass());
        }
        Properties props = new Properties();
        props.putAll((Map<?, ?>)this.connectionProps);
        if (subject != null) {
            if (SubjectActions.addMatchingProperties(subject, cri, props, this.userName, this.password, this)) {
                return props;
            }
            throw new ResourceException("No matching credentials in Subject!");
        }
        WrappedConnectionRequestInfo lcri = (WrappedConnectionRequestInfo)cri;
        if (lcri != null) {
            props.setProperty("user", lcri.getUserName() == null ? "" : lcri.getUserName());
            props.setProperty("password", lcri.getPassword() == null ? "" : lcri.getPassword());
            return props;
        }
        if (this.userName != null) {
            props.setProperty("user", this.userName);
            props.setProperty("password", this.password == null ? "" : this.password);
        }
        return props;
    }

    Object loadPlugin(String plugin, Properties props) throws Exception {
        if (plugin == null) {
            throw new Exception("Plugin is null");
        }
        if (plugin.trim().equals("")) {
            throw new Exception("Plugin isn't defined");
        }
        Class<?> clz = null;
        try {
            clz = Class.forName(plugin, true, this.getClassLoaderPlugin().getClassLoader());
        }
        catch (ClassNotFoundException cnfe) {
            // empty catch block
        }
        if (clz == null) {
            try {
                clz = Class.forName(plugin, true, new TCClassLoaderPlugin().getClassLoader());
            }
            catch (ClassNotFoundException cnfe) {
                // empty catch block
            }
        }
        if (clz == null) {
            try {
                clz = Class.forName(plugin, true, BaseWrapperManagedConnectionFactory.class.getClassLoader());
            }
            catch (ClassNotFoundException cnfe) {
                throw new Exception("Unable to load: " + plugin);
            }
        }
        Object result = clz.newInstance();
        if (props != null) {
            Injection injection = new Injection();
            for (Map.Entry<Object, Object> prop : props.entrySet()) {
                injection.inject(result, (String)prop.getKey(), (String)prop.getValue());
            }
        }
        return result;
    }

    boolean isExceptionFatal(SQLException e) {
        try {
            if (this.exceptionSorter != null) {
                return this.exceptionSorter.isExceptionFatal(e);
            }
            if (this.exceptionSorterClassName != null) {
                try {
                    Object o = this.loadPlugin(this.exceptionSorterClassName, this.exceptionSorterProps);
                    if (o != null && o instanceof ExceptionSorter) {
                        this.exceptionSorter = (ExceptionSorter)o;
                        return this.exceptionSorter.isExceptionFatal(e);
                    }
                    this.log.warn((Object)"Disabling exception sorter");
                    this.exceptionSorter = new NullExceptionSorter();
                }
                catch (Exception e2) {
                    this.log.warn((Object)"exception trying to create exception sorter (disabling):", (Throwable)e2);
                    this.exceptionSorter = new NullExceptionSorter();
                }
            }
        }
        catch (Throwable t) {
            this.log.warn((Object)"Error checking exception fatality: ", t);
        }
        return false;
    }

    SQLException isValidConnection(Connection c) {
        if (this.connectionChecker != null) {
            return this.connectionChecker.isValidConnection(c);
        }
        if (this.validConnectionCheckerClassName != null) {
            try {
                Object o = this.loadPlugin(this.validConnectionCheckerClassName, this.validConnectionCheckerProps);
                if (o != null && o instanceof ValidConnectionChecker) {
                    this.connectionChecker = (ValidConnectionChecker)o;
                    return this.connectionChecker.isValidConnection(c);
                }
                this.log.warn((Object)"Disabling valid connection checker");
                this.connectionChecker = new NullValidConnectionChecker();
            }
            catch (Exception e) {
                this.log.warn((Object)"Exception trying to create valid connection checker (disabling):", (Throwable)e);
                this.connectionChecker = new NullValidConnectionChecker();
            }
        }
        if (this.checkValidConnectionSQL != null) {
            this.connectionChecker = new CheckValidConnectionSQL(this.checkValidConnectionSQL);
            return this.connectionChecker.isValidConnection(c);
        }
        return null;
    }

    boolean isStaleConnection(SQLException e) {
        if (this.staleConnectionChecker != null) {
            return this.staleConnectionChecker.isStaleConnection(e);
        }
        if (this.staleConnectionCheckerClassName != null) {
            try {
                Object o = this.loadPlugin(this.staleConnectionCheckerClassName, this.staleConnectionCheckerProps);
                if (o != null && o instanceof StaleConnectionChecker) {
                    this.staleConnectionChecker = (StaleConnectionChecker)o;
                    return this.staleConnectionChecker.isStaleConnection(e);
                }
                this.log.warn((Object)"Disabling stale connection checker");
                this.staleConnectionChecker = new NullStaleConnectionChecker();
            }
            catch (Exception ex2) {
                this.log.warn((Object)("Exception trying to create stale connection checker (disabling) " + this.staleConnectionCheckerClassName), (Throwable)ex2);
                this.staleConnectionChecker = new NullStaleConnectionChecker();
            }
        }
        return false;
    }

    public final Properties getValidConnectionCheckerProps() {
        return this.validConnectionCheckerProps;
    }

    public final Properties getStaleConnectionCheckerProps() {
        return this.staleConnectionCheckerProps;
    }

    public final Properties getExceptionSorterProps() {
        return this.exceptionSorterProps;
    }

    public final String getValidConnectionCheckerProperties() {
        return this.validConnectionCheckerProperties;
    }

    public final void setValidConnectionCheckerProperties(String validConnectionCheckerProperties) {
        this.validConnectionCheckerProperties = validConnectionCheckerProperties;
        this.validConnectionCheckerProps.clear();
        if (validConnectionCheckerProperties != null) {
            validConnectionCheckerProperties = validConnectionCheckerProperties.replaceAll("\\\\", "\\\\\\\\");
            validConnectionCheckerProperties = validConnectionCheckerProperties.replaceAll(";", "\n");
            ByteArrayInputStream is = new ByteArrayInputStream(validConnectionCheckerProperties.getBytes());
            try {
                this.validConnectionCheckerProps.load(is);
            }
            catch (IOException ioe) {
                throw new RuntimeException("Could not load connection properties", ioe);
            }
        }
    }

    public final String getStaleConnectionCheckerProperties() {
        return this.staleConnectionCheckerProperties;
    }

    public final void setStaleConnectionCheckerProperties(String staleConnectionCheckerProperties) {
        this.staleConnectionCheckerProperties = staleConnectionCheckerProperties;
        this.staleConnectionCheckerProps.clear();
        if (staleConnectionCheckerProperties != null) {
            staleConnectionCheckerProperties = staleConnectionCheckerProperties.replaceAll("\\\\", "\\\\\\\\");
            staleConnectionCheckerProperties = staleConnectionCheckerProperties.replaceAll(";", "\n");
            ByteArrayInputStream is = new ByteArrayInputStream(staleConnectionCheckerProperties.getBytes());
            try {
                this.staleConnectionCheckerProps.load(is);
            }
            catch (IOException ioe) {
                throw new RuntimeException("Could not load connection properties", ioe);
            }
        }
    }

    public final String getExceptionSorterProperties() {
        return this.exceptionSorterProperties;
    }

    public final void setExceptionSorterProperties(String exceptionSorterProperties) {
        this.exceptionSorterProperties = exceptionSorterProperties;
        this.exceptionSorterProps.clear();
        if (exceptionSorterProperties != null) {
            exceptionSorterProperties = exceptionSorterProperties.replaceAll("\\\\", "\\\\\\\\");
            exceptionSorterProperties = exceptionSorterProperties.replaceAll(";", "\n");
            ByteArrayInputStream is = new ByteArrayInputStream(exceptionSorterProperties.getBytes());
            try {
                this.exceptionSorterProps.load(is);
            }
            catch (IOException ioe) {
                throw new RuntimeException("Could not load connection properties", ioe);
            }
        }
    }

    public final ClassLoaderPlugin getClassLoaderPlugin() {
        if (this.classLoaderPlugin == null) {
            this.classLoaderPlugin = new TCClassLoaderPlugin();
        }
        return this.classLoaderPlugin;
    }

    public final void setClassLoaderPlugin(ClassLoaderPlugin clPlugin) {
        this.classLoaderPlugin = clPlugin;
    }

    static class SubjectActions
    implements PrivilegedAction<Boolean> {
        private final Subject subject;
        private final ConnectionRequestInfo cri;
        private final Properties props;
        private final String userName;
        private final String password;
        private final ManagedConnectionFactory mcf;

        SubjectActions(Subject subject, ConnectionRequestInfo cri, Properties props, String userName, String password, ManagedConnectionFactory mcf) {
            this.subject = subject;
            this.cri = cri;
            this.props = props;
            this.userName = userName;
            this.password = password;
            this.mcf = mcf;
        }

        @Override
        public Boolean run() {
            Set<PasswordCredential> creds = this.subject.getPrivateCredentials(PasswordCredential.class);
            if (creds != null && creds.size() > 0) {
                for (PasswordCredential cred : creds) {
                    if (!cred.getManagedConnectionFactory().equals((Object)this.mcf)) continue;
                    String user = null;
                    String pass = null;
                    if (this.cri != null) {
                        WrappedConnectionRequestInfo lcri = (WrappedConnectionRequestInfo)this.cri;
                        user = lcri.getUserName();
                        pass = lcri.getPassword();
                    } else {
                        user = cred.getUserName();
                        if (cred.getPassword() != null) {
                            pass = new String(cred.getPassword());
                        }
                    }
                    if (this.userName != null) {
                        user = this.userName;
                        if (this.password != null) {
                            pass = this.password;
                        }
                    }
                    this.props.setProperty("user", user == null ? "" : user);
                    this.props.setProperty("password", pass == null ? "" : pass);
                    return Boolean.TRUE;
                }
            }
            return Boolean.FALSE;
        }

        static boolean addMatchingProperties(Subject subject, ConnectionRequestInfo cri, Properties props, String userName, String password, ManagedConnectionFactory mcf) {
            SubjectActions action = new SubjectActions(subject, cri, props, userName, password, mcf);
            Boolean matched = AccessController.doPrivileged(action);
            return matched;
        }
    }
}

