/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jca.adapters.jdbc.statistics;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.jboss.jca.adapters.jdbc.PreparedStatementCache;
import org.jboss.jca.core.spi.statistics.StatisticsPlugin;

public class JdbcStatisticsPlugin
implements StatisticsPlugin {
    private static final long serialVersionUID = 1L;
    private static final String PREPARED_STATEMENT_CACHE_ACCESS_COUNT = "PreparedStatementCacheAccessCount";
    private static final String PREPARED_STATEMENT_CACHE_ADD_COUNT = "PreparedStatementCacheAddCount";
    private static final String PREPARED_STATEMENT_CACHE_CURRENT_SIZE = "PreparedStatementCacheCurrentSize";
    private static final String PREPARED_STATEMENT_CACHE_DELETE_COUNT = "PreparedStatementCacheDeleteCount";
    private static final String PREPARED_STATEMENT_CACHE_HIT_COUNT = "PreparedStatementCacheHitCount";
    private static final String PREPARED_STATEMENT_CACHE_MISS_COUNT = "PreparedStatementCacheMissCount";
    private AtomicLong preparedStatementCacheAccessCount;
    private AtomicLong preparedStatementCacheAddCount;
    private AtomicLong preparedStatementCacheDeleteCount;
    private AtomicInteger preparedStatementCacheHitCount;
    private AtomicInteger preparedStatementCacheMissCount;
    private Set<String> names;
    private Map<String, Class> types;
    private AtomicBoolean enabled;
    private transient Map<Locale, ResourceBundle> rbs;
    private transient Set<PreparedStatementCache> psCaches;

    public JdbcStatisticsPlugin() {
        HashSet<String> n = new HashSet<String>();
        HashMap<String, Class<Number>> t = new HashMap<String, Class<Number>>();
        n.add(PREPARED_STATEMENT_CACHE_ACCESS_COUNT);
        t.put(PREPARED_STATEMENT_CACHE_ACCESS_COUNT, Long.TYPE);
        n.add(PREPARED_STATEMENT_CACHE_ADD_COUNT);
        t.put(PREPARED_STATEMENT_CACHE_ADD_COUNT, Long.TYPE);
        n.add(PREPARED_STATEMENT_CACHE_CURRENT_SIZE);
        t.put(PREPARED_STATEMENT_CACHE_CURRENT_SIZE, Integer.TYPE);
        n.add(PREPARED_STATEMENT_CACHE_DELETE_COUNT);
        t.put(PREPARED_STATEMENT_CACHE_DELETE_COUNT, Long.TYPE);
        n.add(PREPARED_STATEMENT_CACHE_HIT_COUNT);
        t.put(PREPARED_STATEMENT_CACHE_HIT_COUNT, Integer.TYPE);
        n.add(PREPARED_STATEMENT_CACHE_MISS_COUNT);
        t.put(PREPARED_STATEMENT_CACHE_MISS_COUNT, Integer.TYPE);
        this.names = Collections.unmodifiableSet(n);
        this.types = Collections.unmodifiableMap(t);
        this.enabled = new AtomicBoolean(true);
        ResourceBundle defaultResourceBundle = ResourceBundle.getBundle("jdbc", Locale.US, JdbcStatisticsPlugin.class.getClassLoader());
        this.rbs = new HashMap<Locale, ResourceBundle>(1);
        this.rbs.put(Locale.US, defaultResourceBundle);
        this.preparedStatementCacheAccessCount = new AtomicLong(0L);
        this.preparedStatementCacheAddCount = new AtomicLong(0L);
        this.preparedStatementCacheDeleteCount = new AtomicLong(0L);
        this.preparedStatementCacheHitCount = new AtomicInteger(0);
        this.preparedStatementCacheMissCount = new AtomicInteger(0);
        this.psCaches = Collections.synchronizedSet(new HashSet());
        this.clear();
    }

    public Set<String> getNames() {
        return this.names;
    }

    public Class getType(String name) {
        return this.types.get(name);
    }

    public String getDescription(String name) {
        return this.getDescription(name, Locale.US);
    }

    public String getDescription(String name, Locale locale) {
        ResourceBundle newResourceBundle;
        ResourceBundle rb = this.rbs.get(locale);
        if (rb == null && (newResourceBundle = ResourceBundle.getBundle("jdbc", locale, JdbcStatisticsPlugin.class.getClassLoader())) != null) {
            this.rbs.put(locale, newResourceBundle);
        }
        if (rb == null) {
            rb = this.rbs.get(Locale.US);
        }
        if (rb != null) {
            return rb.getString(name);
        }
        return "";
    }

    public Object getValue(String name) {
        if (PREPARED_STATEMENT_CACHE_ACCESS_COUNT.equals(name)) {
            return this.getPreparedStatementCacheAccessCount();
        }
        if (PREPARED_STATEMENT_CACHE_ADD_COUNT.equals(name)) {
            return this.getPreparedStatementCacheAddCount();
        }
        if (PREPARED_STATEMENT_CACHE_CURRENT_SIZE.equals(name)) {
            return this.getPreparedStatementCacheCurrentSize();
        }
        if (PREPARED_STATEMENT_CACHE_DELETE_COUNT.equals(name)) {
            return this.getPreparedStatementCacheDeleteCount();
        }
        if (PREPARED_STATEMENT_CACHE_HIT_COUNT.equals(name)) {
            return this.getPreparedStatementCacheHitCount();
        }
        if (PREPARED_STATEMENT_CACHE_MISS_COUNT.equals(name)) {
            return this.getPreparedStatementCacheMissCount();
        }
        return null;
    }

    public boolean isEnabled() {
        return this.enabled.get();
    }

    public void setEnabled(boolean v) {
        this.enabled.set(v);
    }

    public void registerPreparedStatementCache(PreparedStatementCache v) {
        this.psCaches.add(v);
    }

    public void deregisterPreparedStatementCache(PreparedStatementCache v) {
        this.psCaches.remove(v);
    }

    public long getPreparedStatementCacheAccessCount() {
        if (this.isEnabled()) {
            return this.preparedStatementCacheAccessCount.get();
        }
        return 0L;
    }

    public void deltaPreparedStatementCacheAccessCount() {
        if (this.isEnabled()) {
            this.preparedStatementCacheAccessCount.incrementAndGet();
        }
    }

    public long getPreparedStatementCacheAddCount() {
        if (this.isEnabled()) {
            return this.preparedStatementCacheAddCount.get();
        }
        return 0L;
    }

    public void deltaPreparedStatementCacheAddCount() {
        if (this.isEnabled()) {
            this.preparedStatementCacheAddCount.incrementAndGet();
        }
    }

    public int getPreparedStatementCacheCurrentSize() {
        if (this.isEnabled()) {
            HashSet<PreparedStatementCache> copy = new HashSet<PreparedStatementCache>(this.psCaches);
            int size = 0;
            for (PreparedStatementCache psc : copy) {
                size += psc.size();
            }
            return size;
        }
        return 0;
    }

    public long getPreparedStatementCacheDeleteCount() {
        if (this.isEnabled()) {
            return this.preparedStatementCacheDeleteCount.get();
        }
        return 0L;
    }

    public void deltaPreparedStatementCacheDeleteCount() {
        if (this.isEnabled()) {
            this.preparedStatementCacheDeleteCount.incrementAndGet();
        }
    }

    public int getPreparedStatementCacheHitCount() {
        if (this.isEnabled()) {
            return this.preparedStatementCacheHitCount.get();
        }
        return 0;
    }

    public void deltaPreparedStatementCacheHitCount() {
        if (this.isEnabled()) {
            this.preparedStatementCacheHitCount.incrementAndGet();
        }
    }

    public int getPreparedStatementCacheMissCount() {
        if (this.isEnabled()) {
            return this.preparedStatementCacheMissCount.get();
        }
        return 0;
    }

    public void deltaPreparedStatementCacheMissCount() {
        if (this.isEnabled()) {
            this.preparedStatementCacheMissCount.incrementAndGet();
        }
    }

    public synchronized void clear() {
        if (this.isEnabled()) {
            this.preparedStatementCacheAccessCount.set(0L);
            this.preparedStatementCacheAddCount.set(0L);
            this.preparedStatementCacheDeleteCount.set(0L);
            this.preparedStatementCacheHitCount.set(0);
            this.preparedStatementCacheMissCount.set(0);
        }
    }
}

