/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jca.adapters.jdbc.local;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.lang.reflect.Method;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.concurrent.ConcurrentHashMap;
import javax.resource.ResourceException;
import javax.resource.spi.ConnectionManager;
import javax.resource.spi.ConnectionRequestInfo;
import javax.resource.spi.ManagedConnection;
import javax.security.auth.Subject;
import javax.sql.DataSource;
import org.jboss.jca.adapters.jdbc.BaseWrapperManagedConnectionFactory;
import org.jboss.jca.adapters.jdbc.classloading.TCClassLoaderPlugin;
import org.jboss.jca.adapters.jdbc.local.LocalManagedConnection;
import org.jboss.jca.adapters.jdbc.local.SecurityActions;
import org.jboss.jca.adapters.jdbc.local.URLSelector;
import org.jboss.jca.adapters.jdbc.spi.URLSelectorStrategy;
import org.jboss.jca.adapters.jdbc.util.Injection;

public class LocalManagedConnectionFactory
extends BaseWrapperManagedConnectionFactory {
    private static final long serialVersionUID = -2751268690794983375L;
    private String driverClass;
    private String dataSourceClass;
    private transient Driver driver = null;
    private transient DataSource dataSource = null;
    private String connectionURL;
    private transient URLSelectorStrategy urlSelector = null;
    protected String connectionProperties;
    protected final Properties connectionProps = new Properties();
    private static Map<String, Driver> driverCache = new ConcurrentHashMap<String, Driver>();

    @Override
    public Object createConnectionFactory(ConnectionManager cm) throws ResourceException {
        if (this.driverClass == null && this.dataSourceClass == null) {
            throw new ResourceException(bundle.driverClassNull());
        }
        if (this.connectionURL == null && this.driverClass != null) {
            throw new ResourceException(bundle.connectionURLNull());
        }
        return super.createConnectionFactory(cm);
    }

    public String getConnectionURL() {
        return this.connectionURL;
    }

    public void setConnectionURL(String connectionURL) {
        this.connectionURL = connectionURL;
    }

    public String getDriverClass() {
        return this.driverClass;
    }

    public void setDriverClass(String driverClass) {
        this.driverClass = driverClass;
        this.driver = null;
    }

    public String getDataSourceClass() {
        return this.dataSourceClass;
    }

    public void setDataSourceClass(String dataSourceClass) {
        this.dataSourceClass = dataSourceClass;
        this.driver = null;
    }

    public String getConnectionProperties() {
        return this.connectionProperties;
    }

    public void setConnectionProperties(String connectionProperties) {
        this.connectionProperties = connectionProperties;
        this.connectionProps.clear();
        if (connectionProperties != null) {
            connectionProperties = connectionProperties.replaceAll("\\\\", "\\\\\\\\");
            connectionProperties = connectionProperties.replaceAll(";", "\n");
            ByteArrayInputStream is = new ByteArrayInputStream(connectionProperties.getBytes());
            try {
                this.connectionProps.load(is);
            }
            catch (IOException ioe) {
                throw new RuntimeException("Could not load connection properties", ioe);
            }
        }
    }

    public ManagedConnection createManagedConnection(Subject subject, ConnectionRequestInfo cri) throws ResourceException {
        final Properties props = this.getConnectionProperties(this.connectionProps, subject, cri);
        final Properties copy = (Properties)props.clone();
        Subject copySubject = null;
        if (subject != null) {
            copySubject = SecurityActions.createSubject(false, subject);
        }
        if (this.log.isTraceEnabled()) {
            Properties logCopy = copy;
            if (copy.getProperty("password") != null) {
                logCopy = (Properties)props.clone();
                logCopy.setProperty("password", "--hidden--");
            }
            this.log.trace("Using properties: " + logCopy);
        }
        if (this.getURLDelimiter() != null && !this.getURLDelimiter().trim().equals("") && this.urlSelector == null) {
            this.initUrlSelector();
        }
        if (copySubject != null) {
            try {
                return Subject.doAs(copySubject, new PrivilegedExceptionAction<ManagedConnection>(){

                    @Override
                    public ManagedConnection run() throws ResourceException {
                        if (LocalManagedConnectionFactory.this.urlSelector != null) {
                            return LocalManagedConnectionFactory.this.getHALocalManagedConnection(props, copy);
                        }
                        return LocalManagedConnectionFactory.this.getLocalManagedConnection(props, copy);
                    }
                });
            }
            catch (PrivilegedActionException pe) {
                if (pe.getException() instanceof ResourceException) {
                    throw (ResourceException)((Object)pe.getException());
                }
                throw new ResourceException((Throwable)pe);
            }
        }
        if (this.urlSelector != null) {
            return this.getHALocalManagedConnection(props, copy);
        }
        return this.getLocalManagedConnection(props, copy);
    }

    private LocalManagedConnection createLocalManagedConnection(String url, Properties props, Properties copy) throws ResourceException {
        if (this.driverClass != null && !this.isDriverLoadedForURL(url)) {
            try {
                this.getDriver(url);
            }
            catch (ResourceException re) {
                this.log.debug("Exception while registering driver", re);
            }
        }
        Connection con = null;
        try {
            if (this.dataSourceClass != null) {
                DataSource d = this.getDataSource();
                con = d.getConnection(copy.getProperty("user"), copy.getProperty("password"));
                if (con == null) {
                    throw new ResourceException(bundle.unableToCreateConnectionFromDataSource());
                }
            } else if (this.driverClass != null) {
                Driver d = this.getDriver(url);
                con = d.connect(url, copy);
                if (con == null) {
                    throw new ResourceException(bundle.wrongDriverClass(d.getClass().getName(), url));
                }
            } else {
                throw new ResourceException(bundle.unableToCreateConnection());
            }
            return new LocalManagedConnection(this, con, props, this.transactionIsolation, (int)this.preparedStatementCacheSize);
        }
        catch (Throwable e) {
            if (con != null) {
                try {
                    con.close();
                }
                catch (Throwable ignored) {
                    // empty catch block
                }
            }
            throw new ResourceException(bundle.unableToCreateConnection(), e);
        }
    }

    private LocalManagedConnection getLocalManagedConnection(Properties props, Properties copy) throws ResourceException {
        return this.createLocalManagedConnection(this.getConnectionURL(), props, copy);
    }

    private LocalManagedConnection getHALocalManagedConnection(Properties props, Properties copy) throws ResourceException {
        boolean trace = this.log.isTraceEnabled();
        while (this.urlSelector.hasMore()) {
            String url = this.urlSelector.active();
            if (trace) {
                this.log.tracef("Trying to create a connection to %s", url);
            }
            try {
                return this.createLocalManagedConnection(url, props, copy);
            }
            catch (Exception e) {
                this.log.errorCreatingConnection(url, e);
                this.urlSelector.fail(url);
            }
        }
        this.urlSelector.reset();
        throw new ResourceException(bundle.unableToCreateConnectionFromURL(this.urlSelector.getData()));
    }

    protected void initUrlSelector() {
        boolean trace = this.log.isTraceEnabled();
        ArrayList<String> urlsList = new ArrayList<String>();
        StringTokenizer st = new StringTokenizer(this.getConnectionURL(), this.urlDelimiter);
        while (st.hasMoreTokens()) {
            String url = st.nextToken();
            urlsList.add(url);
            if (!trace) continue;
            this.log.trace("added HA connection url: " + url);
        }
        if (this.getUrlSelectorStrategyClassName() == null) {
            this.urlSelector = new URLSelector();
            this.urlSelector.init(urlsList);
            this.log.debugf("Default URLSelectorStrategy is being used : %s", this.urlSelector);
        } else {
            this.urlSelector = this.initUrlSelectorClass(this.getUrlSelectorStrategyClassName(), urlsList);
            this.log.debugf("Customized URLSelectorStrategy is being used : %s", this.urlSelector);
        }
    }

    private URLSelectorStrategy initUrlSelectorClass(String className, List<String> urls) {
        URLSelectorStrategy result = null;
        if (className == null || className.trim().equals("")) {
            this.log.undefinedURLSelectStrategy(this.getJndiName());
            return null;
        }
        Class<?> clz = null;
        try {
            clz = Class.forName(className, true, this.getClassLoaderPlugin().getClassLoader());
        }
        catch (ClassNotFoundException cnfe) {
            // empty catch block
        }
        if (clz == null) {
            try {
                clz = Class.forName(className, true, new TCClassLoaderPlugin().getClassLoader());
            }
            catch (ClassNotFoundException cnfe) {
                // empty catch block
            }
        }
        if (clz == null) {
            try {
                clz = Class.forName(className, true, SecurityActions.getClassLoader(LocalManagedConnectionFactory.class));
            }
            catch (ClassNotFoundException cnfe) {
                // empty catch block
            }
        }
        if (clz == null) {
            this.log.errorURLSelectStrategy(className, this.getJndiName());
            return null;
        }
        try {
            result = (URLSelectorStrategy)clz.newInstance();
            Method init = clz.getMethod("init", List.class);
            init.invoke((Object)result, urls);
        }
        catch (Throwable t) {
            this.log.errorURLSelectStrategyExt(className, this.getJndiName(), t);
        }
        return result;
    }

    public ManagedConnection matchManagedConnections(Set mcs, Subject subject, ConnectionRequestInfo cri) throws ResourceException {
        Properties newProps = this.getConnectionProperties(this.connectionProps, subject, cri);
        for (Object o : mcs) {
            if (!(o instanceof LocalManagedConnection)) continue;
            LocalManagedConnection mc = (LocalManagedConnection)o;
            if (Boolean.TRUE.equals(this.getReauthEnabled())) {
                return mc;
            }
            if (!mc.getProperties().equals(newProps)) continue;
            return mc;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isEqual(Properties other) {
        Properties properties = this.connectionProps;
        synchronized (properties) {
            return this.connectionProps.equals(other);
        }
    }

    public int hashCode() {
        int result = 17;
        result = result * 37 + (this.connectionURL == null ? 0 : this.connectionURL.hashCode());
        result = result * 37 + (this.driverClass == null ? 0 : this.driverClass.hashCode());
        result = result * 37 + (this.dataSourceClass == null ? 0 : this.dataSourceClass.hashCode());
        result = result * 37 + (this.userName == null ? 0 : this.userName.hashCode());
        result = result * 37 + (this.password == null ? 0 : this.password.hashCode());
        result = result * 37 + this.transactionIsolation;
        return result;
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (this == other) {
            return true;
        }
        if (this.getClass() != other.getClass()) {
            return false;
        }
        LocalManagedConnectionFactory otherMcf = (LocalManagedConnectionFactory)other;
        return this.connectionURL.equals(otherMcf.connectionURL) && (this.driverClass == null ? otherMcf.driverClass == null : this.driverClass.equals(otherMcf.driverClass)) && (this.dataSourceClass == null ? otherMcf.dataSourceClass == null : this.dataSourceClass.equals(otherMcf.dataSourceClass)) && (this.userName == null ? otherMcf.userName == null : this.userName.equals(otherMcf.userName)) && (this.password == null ? otherMcf.password == null : this.password.equals(otherMcf.password)) && this.transactionIsolation == otherMcf.transactionIsolation;
    }

    protected synchronized Driver getDriver(String url) throws ResourceException {
        boolean trace = this.log.isTraceEnabled();
        if (this.driver != null) {
            return this.driver;
        }
        if (trace) {
            this.log.trace("Checking driver for URL: " + url);
        }
        if (this.driverClass == null) {
            throw new ResourceException(bundle.noDriverClassForURL(url));
        }
        String driverKey = url.substring(0, url.indexOf(":", 6));
        this.driver = driverCache.get(driverKey);
        if (this.driver != null) {
            return this.driver;
        }
        try {
            Class<?> clazz = Class.forName(this.driverClass, true, this.getClassLoaderPlugin().getClassLoader());
            if (this.isDriverLoadedForURL(url)) {
                return this.driver;
            }
            this.driver = (Driver)clazz.newInstance();
            DriverManager.registerDriver(this.driver);
            this.log.debugf("Driver loaded and instance created:%s", this.driver);
            driverCache.put(driverKey, this.driver);
        }
        catch (Exception e) {
            throw new ResourceException(bundle.failedToRegisterDriverClass(this.driverClass), (Throwable)e);
        }
        return this.driver;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isDriverLoadedForURL(String url) {
        boolean trace = this.log.isTraceEnabled();
        ClassLoader tccl = SecurityActions.getThreadContextClassLoader();
        try {
            SecurityActions.setThreadContextClassLoader(this.getClassLoaderPlugin().getClassLoader());
            this.driver = DriverManager.getDriver(url);
            if (trace) {
                this.log.trace("Driver already registered for url: " + url);
            }
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            if (trace) {
                this.log.trace("Driver not yet registered for url: " + url);
            }
            boolean bl = false;
            return bl;
        }
        finally {
            SecurityActions.setThreadContextClassLoader(tccl);
        }
    }

    protected String internalGetConnectionURL() {
        return this.connectionURL;
    }

    private synchronized DataSource getDataSource() throws ResourceException {
        if (this.dataSource == null) {
            if (this.dataSourceClass == null || this.dataSourceClass.trim().equals("")) {
                throw new ResourceException(bundle.datasourceClassNull());
            }
            ClassLoader tccl = SecurityActions.getThreadContextClassLoader();
            try {
                SecurityActions.setThreadContextClassLoader(this.getClassLoaderPlugin().getClassLoader());
                Class<?> clz = Class.forName(this.dataSourceClass, true, this.getClassLoaderPlugin().getClassLoader());
                this.dataSource = (DataSource)clz.newInstance();
                if (this.connectionProps != null) {
                    Injection injector = new Injection();
                    for (Map.Entry<Object, Object> entry : this.connectionProps.entrySet()) {
                        String key = (String)entry.getKey();
                        String value = (String)entry.getValue();
                        injector.inject(this.dataSource, key, value);
                    }
                }
            }
            catch (Throwable t) {
                throw new ResourceException(bundle.failedToLoadDataSource(this.dataSourceClass), t);
            }
            finally {
                SecurityActions.setThreadContextClassLoader(tccl);
            }
        }
        return this.dataSource;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("LocalManagedConnectionFactory@").append(Integer.toHexString(System.identityHashCode(this)));
        sb.append("[connectionURL=").append(this.connectionURL);
        sb.append(" driverClass=").append(this.driverClass);
        sb.append(" userName=").append(this.userName);
        sb.append(" password=****");
        sb.append(" transactionIsolation=").append(this.transactionIsolation);
        sb.append("]");
        return sb.toString();
    }
}

