/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.system.microcontainer.jmx;

import java.lang.annotation.Annotation;
import java.util.List;
import org.jboss.aop.microcontainer.aspects.jmx.JMX;
import org.jboss.beans.metadata.plugins.AbstractDependencyValueMetaData;
import org.jboss.beans.metadata.spi.MetaDataVisitorNode;
import org.jboss.beans.metadata.spi.ValueMetaData;
import org.jboss.beans.metadata.spi.builder.BeanMetaDataBuilder;
import org.jboss.dependency.spi.Controller;
import org.jboss.dependency.spi.ControllerContext;
import org.jboss.kernel.plugins.annotations.AbstractAnnotationPlugin;
import org.jboss.kernel.spi.dependency.KernelController;
import org.jboss.kernel.spi.dependency.KernelControllerContext;
import org.jboss.metadata.spi.MetaData;
import org.jboss.reflect.spi.AnnotatedInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class JMXAnnotationPlugin<T extends AnnotatedInfo>
extends AbstractAnnotationPlugin<T, JMX> {
    protected JMXAnnotationPlugin() {
        super(JMX.class);
    }

    protected List<? extends MetaDataVisitorNode> internalApplyAnnotation(T info, MetaData metaData, JMX jmx, KernelControllerContext context) throws Throwable {
        Class<?> exposedInterface = jmx.exposedInterface();
        if (exposedInterface == null || Void.TYPE.equals(exposedInterface)) {
            exposedInterface = this.getExposedInterface(info);
        }
        if (exposedInterface == null || !exposedInterface.isInterface()) {
            throw new IllegalArgumentException("Illegal exposed interface: " + exposedInterface);
        }
        String name = this.createObjectName((ControllerContext)context, info, jmx);
        String property = this.getName(info);
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("Exposing " + context.getName() + "." + property + " (" + exposedInterface.getName() + ") via objectName: " + name));
        }
        BeanMetaDataBuilder builder = BeanMetaDataBuilder.createBuilder((String)name, (String)exposedInterface.getName());
        builder.addAnnotation((Annotation)jmx);
        builder.setConstructorValue((ValueMetaData)new AbstractDependencyValueMetaData(context.getName(), property));
        KernelController controller = (KernelController)context.getController();
        controller.install(builder.getBeanMetaData());
        return null;
    }

    protected void internalCleanAnnotation(T info, MetaData metaData, JMX jmx, KernelControllerContext context) throws Throwable {
        String name = this.createObjectName((ControllerContext)context, info, jmx);
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("Removing " + context.getName() + "." + this.getName(info) + " via objectName: " + name));
        }
        Controller controller = context.getController();
        controller.uninstall((Object)name);
    }

    protected abstract Class<?> getExposedInterface(T var1);

    protected abstract String getName(T var1);

    protected String createObjectName(ControllerContext context, T info, JMX jmx) throws Exception {
        String name;
        String jmxName;
        if (jmx != null && (jmxName = jmx.name()) != null && jmxName.length() > 0) {
            return jmxName;
        }
        String objectName = name = context.getName().toString();
        if (!name.contains(":")) {
            objectName = "jboss.pojo:name='" + name + "'";
        }
        return objectName + ",attribute=" + this.getName(info);
    }
}

