/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.logging.util;

import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import javax.lang.model.util.Types;
import org.jboss.logging.LogMessage;
import org.jboss.logging.Message;
import org.jboss.logging.MessageBundle;
import org.jboss.logging.MessageLogger;
import org.jboss.logging.model.ImplementationType;

public final class ElementHelper {
    public static final Class<MessageBundle> MESSAGE_BUNDLE_ANNOTATION = MessageBundle.class;
    public static final Class<MessageLogger> MESSAGE_LOGGER_ANNOTATION = MessageLogger.class;
    public static final Class<LogMessage> LOG_MESSAGE_ANNOTATION = LogMessage.class;
    public static final Class<Message> MESSAGE_ANNOTATION = Message.class;

    private ElementHelper() {
    }

    public static boolean isAnnotatedWith(Element element, Class<? extends Annotation> clazz) {
        if (element == null) {
            throw new NullPointerException("The element parameter is null");
        }
        Annotation annotation = element.getAnnotation(clazz);
        return annotation != null;
    }

    public static String getPrimaryClassName(TypeElement element) {
        if (element == null) {
            throw new NullPointerException("The element parameter cannot be null");
        }
        if (!element.getKind().isInterface()) {
            throw new IllegalArgumentException("The element parameter is not an interface");
        }
        String prefix = ElementHelper.getPrimaryClassNamePrefix(element);
        if (element.getAnnotation(MESSAGE_BUNDLE_ANNOTATION) != null) {
            return prefix + ImplementationType.BUNDLE.toString();
        }
        if (element.getAnnotation(MESSAGE_LOGGER_ANNOTATION) != null) {
            return prefix + ImplementationType.LOGGER.toString();
        }
        return prefix;
    }

    public static String getPrimaryClassNamePrefix(TypeElement element) {
        if (element == null) {
            throw new NullPointerException("The element parameter cannot be null");
        }
        if (!element.getKind().isInterface()) {
            throw new IllegalArgumentException("The element parameter is not an interface");
        }
        String translationFileName = element.getSimpleName().toString();
        for (Element enclosingElt = element.getEnclosingElement(); enclosingElt != null && enclosingElt instanceof TypeElement; enclosingElt = enclosingElt.getEnclosingElement()) {
            translationFileName = String.format("%s$%s", enclosingElt.getSimpleName().toString(), translationFileName);
        }
        return translationFileName;
    }

    public static Collection<ExecutableElement> getInterfaceMethods(TypeElement element, Types types) {
        if (!element.getKind().isInterface()) {
            throw new IllegalArgumentException("The element parameter is not an interface");
        }
        HashSet<ExecutableElement> methods = new HashSet<ExecutableElement>();
        for (TypeMirror typeMirror : element.getInterfaces()) {
            methods.addAll(ElementHelper.getInterfaceMethods((TypeElement)types.asElement(typeMirror), types));
        }
        methods.addAll(ElementFilter.methodsIn(element.getEnclosedElements()));
        return methods;
    }

    public static Map<String, String> getAllMessageMethods(Collection<ExecutableElement> methods) {
        HashMap<String, String> messages = new HashMap<String, String>();
        for (ExecutableElement method : methods) {
            Message annotation = method.getAnnotation(MESSAGE_ANNOTATION);
            if (annotation == null) continue;
            messages.put(method.getSimpleName().toString(), annotation.value());
        }
        return messages;
    }

    public static String getProjectCode(TypeElement interfaceElement) {
        String result = null;
        MessageBundle messageBundle = interfaceElement.getAnnotation(MESSAGE_BUNDLE_ANNOTATION);
        MessageLogger messageLogger = interfaceElement.getAnnotation(MESSAGE_LOGGER_ANNOTATION);
        if (messageBundle != null) {
            result = messageBundle.projectCode();
        } else if (messageLogger != null) {
            result = messageLogger.projectCode();
        }
        return result;
    }
}

