/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.logging.model;

import com.sun.codemodel.internal.JBlock;
import com.sun.codemodel.internal.JClass;
import com.sun.codemodel.internal.JCodeModel;
import com.sun.codemodel.internal.JExpr;
import com.sun.codemodel.internal.JExpression;
import com.sun.codemodel.internal.JInvocation;
import com.sun.codemodel.internal.JMethod;
import com.sun.codemodel.internal.JType;
import com.sun.codemodel.internal.JVar;
import java.text.MessageFormat;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.VariableElement;
import org.jboss.logging.Message;
import org.jboss.logging.model.ClassModelUtil;
import org.jboss.logging.model.ImplementationClassModel;
import org.jboss.logging.model.ImplementationType;
import org.jboss.logging.model.MethodDescriptor;

public class MessageBundleImplementor
extends ImplementationClassModel {
    public MessageBundleImplementor(String interfaceName, String projectCode) {
        super(interfaceName, projectCode, ImplementationType.BUNDLE);
    }

    @Override
    public void addMethod(ExecutableElement method) {
        super.addMethod(method);
    }

    @Override
    protected JCodeModel generateModel() throws IllegalStateException {
        JCodeModel codeModel = super.generateModel();
        this.getDefinedClass().constructor(1);
        ClassModelUtil.createReadResolveMethod(this.getDefinedClass());
        for (MethodDescriptor methodDesc : this.methodDescriptor) {
            JClass returnType = codeModel.ref(methodDesc.returnTypeAsString());
            JMethod jMethod = this.getDefinedClass().method(9, (JType)returnType, methodDesc.name());
            jMethod.annotate(Override.class);
            Message message = methodDesc.message();
            JMethod msgMethod = this.addMessageMethod(methodDesc.name(), message.value());
            JVar messageIdVar = this.addIdVar(methodDesc.name(), message.id());
            JBlock body = jMethod.body();
            JClass returnField = codeModel.ref(returnType.fullName());
            JVar result = body.decl((JType)returnField, "result");
            JClass formatter = null;
            switch (message.format()) {
                case MESSAGE_FORMAT: {
                    formatter = codeModel.ref(MessageFormat.class);
                    break;
                }
                case PRINTF: {
                    formatter = codeModel.ref(String.class);
                }
            }
            JInvocation formatterMethod = formatter.staticInvoke("format");
            if (messageIdVar == null) {
                formatterMethod.arg((JExpression)JExpr.invoke((JMethod)msgMethod));
            } else {
                formatterMethod.arg(messageIdVar.plus((JExpression)JExpr.invoke((JMethod)msgMethod)));
            }
            for (VariableElement param : methodDesc.parameters()) {
                JClass paramType = codeModel.ref(((Object)param.asType()).toString());
                JVar paramVar = jMethod.param(8, (JType)paramType, param.getSimpleName().toString());
                formatterMethod.arg((JExpression)paramVar);
            }
            if (methodDesc.hasClause() && codeModel.ref(Throwable.class).isAssignableFrom(returnField)) {
                result.init((JExpression)JExpr._new((JClass)returnField));
                JInvocation inv = body.invoke((JExpression)result, "initCause");
                inv.arg((JExpression)JExpr.ref((String)methodDesc.causeVarName()));
            } else {
                result.init((JExpression)formatterMethod);
            }
            body._return((JExpression)result);
        }
        return codeModel;
    }
}

