/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.logging.model;

import com.sun.codemodel.internal.JCodeModel;
import com.sun.codemodel.internal.JDefinedClass;
import com.sun.codemodel.internal.JMethod;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.jboss.logging.model.ClassModel;
import org.jboss.logging.model.ClassModelUtil;

public class MessageBundleTranslator
extends ClassModel {
    private final Map<String, String> translations;

    public MessageBundleTranslator(String className, String superClassName, Map<String, String> translations) {
        super(className, superClassName);
        this.translations = translations != null ? translations : Collections.emptyMap();
    }

    @Override
    public JCodeModel generateModel() throws IllegalStateException {
        JCodeModel model = super.generateModel();
        JDefinedClass definedClass = this.getDefinedClass();
        JMethod constructor = definedClass.constructor(1);
        constructor.body().invoke("super");
        JMethod readResolve = ClassModelUtil.createReadResolveMethod(definedClass);
        readResolve.annotate(Override.class);
        Set<Map.Entry<String, String>> entries = this.translations.entrySet();
        for (Map.Entry<String, String> entry : entries) {
            String key = entry.getKey();
            String value = entry.getValue();
            JMethod method = this.addMessageMethod(key, value);
            method.annotate(Override.class);
        }
        return model;
    }
}

