/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.logging.model;

import com.sun.codemodel.internal.JBlock;
import com.sun.codemodel.internal.JClass;
import com.sun.codemodel.internal.JCodeModel;
import com.sun.codemodel.internal.JExpr;
import com.sun.codemodel.internal.JExpression;
import com.sun.codemodel.internal.JFieldVar;
import com.sun.codemodel.internal.JInvocation;
import com.sun.codemodel.internal.JMethod;
import com.sun.codemodel.internal.JType;
import com.sun.codemodel.internal.JVar;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.VariableElement;
import org.jboss.logging.LogMessage;
import org.jboss.logging.Logger;
import org.jboss.logging.Message;
import org.jboss.logging.model.ImplementationClassModel;
import org.jboss.logging.model.ImplementationType;
import org.jboss.logging.model.MethodDescriptor;

public final class MessageLoggerImplementor
extends ImplementationClassModel {
    private static final String LOG_FIELD_NAME = "log";
    private JFieldVar log;

    public MessageLoggerImplementor(String interfaceName, String projectCode) {
        super(interfaceName, projectCode, ImplementationType.LOGGER);
    }

    @Override
    public void addMethod(ExecutableElement method) {
        super.addMethod(method);
    }

    @Override
    protected JCodeModel generateModel() throws IllegalStateException {
        JCodeModel codeModel = super.generateModel();
        this.log = this.getDefinedClass().field(10, Logger.class, LOG_FIELD_NAME);
        JMethod constructor = this.getDefinedClass().constructor(1);
        JVar constructorParam = constructor.param(8, Logger.class, LOG_FIELD_NAME);
        JBlock body = constructor.body();
        body.directStatement("this." + this.log.name() + " = " + constructorParam.name() + ";");
        for (MethodDescriptor methodDesc : this.methodDescriptor) {
            String methodName = methodDesc.name();
            JMethod jMethod = this.getDefinedClass().method(9, (JType)codeModel.VOID, methodName);
            jMethod.annotate(Override.class);
            Message message = methodDesc.message();
            LogMessage logMessage = methodDesc.logMessage();
            Logger.Level logLevel = Logger.Level.INFO;
            if (logMessage != null) {
                logLevel = logMessage.level();
            }
            JMethod msgMethod = this.addMessageMethod(methodName, message.value());
            JVar messageIdVar = this.addIdVar(methodDesc.name(), message.id());
            StringBuilder logMethod = new StringBuilder(logLevel.name().toLowerCase());
            switch (methodDesc.message().format()) {
                case MESSAGE_FORMAT: {
                    logMethod.append("v");
                    break;
                }
                case PRINTF: {
                    logMethod.append("f");
                }
            }
            JBlock methodBody = jMethod.body();
            JInvocation logInv = methodBody.invoke((JExpression)this.log, logMethod.toString());
            if (methodDesc.hasClause()) {
                logInv.arg(JExpr.direct((String)methodDesc.causeVarName()));
            }
            if (messageIdVar == null) {
                logInv.arg((JExpression)JExpr.invoke((JMethod)msgMethod));
            } else {
                logInv.arg(messageIdVar.plus((JExpression)JExpr.invoke((JMethod)msgMethod)));
            }
            for (VariableElement param : methodDesc.parameters()) {
                JClass paramType = codeModel.ref(((Object)param.asType()).toString());
                JVar var = jMethod.param(8, (JType)paramType, param.getSimpleName().toString());
                if (param.equals(methodDesc.cause())) continue;
                logInv.arg((JExpression)var);
            }
        }
        return codeModel;
    }
}

