/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jdocbook;

import java.util.Properties;
import org.jboss.jdocbook.util.TransformerType;

public class Options {
    public static final String DEFAULT_STANDARD_DATE_INJECTION_FORMAT = "MMMM d, yyyy";
    private boolean xincludeSupported;
    private String[] catalogs;
    private String xmlTransformerType;
    private Properties transformerParameters;
    private boolean useRelativeImageUris = true;
    private String docbookVersion;
    private char localeSeparator = (char)45;
    private boolean autoDetectFonts;
    private boolean useFopFontCache = true;
    private boolean applyStandardInjectionValues = true;
    private String injectionDateFormat;

    protected Options() {
    }

    public Options(char localeSeparator) {
        this.localeSeparator = localeSeparator;
    }

    public Options(boolean xincludeSupported, String[] catalogs, String xmlTransformerType, Properties transformerParameters, boolean useRelativeImageUris, String docBookVersion, char localeSeparator, boolean autoDetectFonts) {
        this.xincludeSupported = xincludeSupported;
        this.catalogs = catalogs;
        this.xmlTransformerType = xmlTransformerType;
        this.transformerParameters = transformerParameters;
        this.useRelativeImageUris = useRelativeImageUris;
        this.docbookVersion = docBookVersion;
        this.localeSeparator = localeSeparator;
        this.autoDetectFonts = autoDetectFonts;
    }

    public boolean isXincludeSupported() {
        return this.xincludeSupported;
    }

    public String[] getCatalogs() {
        return this.catalogs;
    }

    public String getXmlTransformerType() {
        return this.xmlTransformerType;
    }

    public TransformerType resolveXmlTransformerType() {
        return TransformerType.parse(this.getXmlTransformerType());
    }

    public Properties getTransformerParameters() {
        if (this.transformerParameters == null) {
            this.transformerParameters = new Properties();
        }
        return this.transformerParameters;
    }

    public boolean isUseRelativeImageUris() {
        return this.useRelativeImageUris;
    }

    public String getDocbookVersion() {
        return this.docbookVersion;
    }

    public void setDocbookVersion(String docbookVersion) {
        this.docbookVersion = docbookVersion;
    }

    public char getLocaleSeparator() {
        return this.localeSeparator;
    }

    public boolean isAutoDetectFontsEnabled() {
        return this.autoDetectFonts;
    }

    public void setAutoDetectFonts(boolean autoDetectFonts) {
        this.autoDetectFonts = autoDetectFonts;
    }

    public boolean isUseFopFontCache() {
        return this.useFopFontCache;
    }

    public void setUseFopFontCache(boolean useFopFontCache) {
        this.useFopFontCache = useFopFontCache;
    }

    public boolean isApplyStandardInjectionValues() {
        return this.applyStandardInjectionValues;
    }

    public void setApplyStandardInjectionValues(boolean applyStandardInjectionValues) {
        this.applyStandardInjectionValues = applyStandardInjectionValues;
    }

    public String getInjectionDateFormat() {
        return this.injectionDateFormat == null ? DEFAULT_STANDARD_DATE_INJECTION_FORMAT : this.injectionDateFormat;
    }

    public void setInjectionDateFormat(String injectionDateFormat) {
        this.injectionDateFormat = injectionDateFormat;
    }
}

