/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jdocbook.i18n.gettext;

import java.io.File;
import java.util.HashSet;
import java.util.Set;
import org.jboss.jdocbook.JDocBookProcessException;
import org.jboss.jdocbook.util.FileUtils;
import org.jboss.jdocbook.util.I18nUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TranslatedItemFactory {
    public static Set<TranslatedItem> createTranslatedItem(File masterFile, File basePoDirectory, File baseTargetDirectory, Set<File> inclusionFileSet) {
        HashSet<TranslatedItem> translatedItemSet = new HashSet<TranslatedItem>();
        File baseDir = masterFile.getParentFile();
        translatedItemSet.add(TranslatedItemFactory.createTranslatedItem(masterFile, baseDir, basePoDirectory, baseTargetDirectory));
        for (File file : inclusionFileSet) {
            translatedItemSet.add(TranslatedItemFactory.createTranslatedItem(file, baseDir, basePoDirectory, baseTargetDirectory));
        }
        return translatedItemSet;
    }

    private static TranslatedItem createTranslatedItem(File file, File baseDir, File basePoDirectory, File baseTargetDirectory) {
        String poFileName;
        String relativity = FileUtils.determineRelativity(file, baseDir);
        File relativeTranslationDir = relativity == null ? basePoDirectory : new File(basePoDirectory, relativity);
        File relativeWorkDir = relativity == null ? baseTargetDirectory : new File(baseTargetDirectory, relativity);
        File poFile = null;
        if (TranslatedItemFactory.isXMLFile(file) && !(poFile = new File(relativeTranslationDir, poFileName = I18nUtils.determinePoFileName(file))).exists()) {
            throw new JDocBookProcessException("Unable to locate PO file for [" + file + "] in [" + basePoDirectory + "]");
        }
        File translatedFile = new File(relativeWorkDir, file.getName());
        return new TranslatedItem(file, poFile, translatedFile);
    }

    private static boolean isXMLFile(File file) {
        return file != null && file.exists() && file.getName().endsWith("xml");
    }

    public static class TranslatedItem {
        private File sourceFile;
        private File poFile;
        private File targetFile;

        private TranslatedItem(File sourceFile, File poFile, File targetFile) {
            this.sourceFile = sourceFile;
            this.poFile = poFile;
            this.targetFile = targetFile;
        }

        public File getSourceFile() {
            return this.sourceFile;
        }

        public File getPoFile() {
            return this.poFile;
        }

        public File getTargetFile() {
            return this.targetFile;
        }
    }
}

