/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jdocbook.i18n.gettext;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.exec.CommandLine;
import org.apache.commons.exec.DefaultExecutor;
import org.apache.commons.exec.ExecuteStreamHandler;
import org.apache.commons.exec.PumpStreamHandler;
import org.jboss.jdocbook.JDocBookProcessException;
import org.jboss.jdocbook.Log;
import org.jboss.jdocbook.i18n.I18nEnvironment;
import org.jboss.jdocbook.i18n.I18nSource;
import org.jboss.jdocbook.i18n.MasterTranslationDescriptor;
import org.jboss.jdocbook.i18n.TranslationBuilder;
import org.jboss.jdocbook.i18n.gettext.TranslatedItemFactory;
import org.jboss.jdocbook.util.FileUtils;
import org.jboss.jdocbook.util.XIncludeHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TranslationBuilderImpl
implements TranslationBuilder {
    private final I18nEnvironment environment;

    public TranslationBuilderImpl(I18nEnvironment environment) {
        this.environment = environment;
    }

    private Log getLog() {
        return this.environment.log();
    }

    @Override
    public void buildTranslations() throws JDocBookProcessException {
        MasterTranslationDescriptor master = this.environment.getMasterTranslationDescriptor();
        for (I18nSource source : this.environment.getI18nSources(true)) {
            this.buildTranslation(master.resolveMasterDocument(), source.resolvePoDirectory(), source.resolveTranslatedXmlDirectory());
        }
    }

    public void buildTranslation(File masterFile, File basePoDirectory, File targetDirectory) throws JDocBookProcessException {
        this.getLog().trace("starting translation [" + masterFile + "]");
        if (!masterFile.exists()) {
            this.getLog().info("skipping translation; master file did not exist : {}", masterFile);
            return;
        }
        HashSet<File> files = new HashSet<File>();
        this.findAllInclusionFiles(masterFile, files);
        files.add(masterFile);
        Set<TranslatedItemFactory.TranslatedItem> translatedItems = TranslatedItemFactory.createTranslatedItem(masterFile, basePoDirectory, targetDirectory, files);
        for (TranslatedItemFactory.TranslatedItem item : translatedItems) {
            if (item.getSourceFile().getName().endsWith("xml")) {
                this.generateTranslatedXML(item.getSourceFile(), item.getPoFile(), item.getTargetFile());
                continue;
            }
            this.copyNonXMLFileToWorkDir(item);
        }
    }

    private void copyNonXMLFileToWorkDir(TranslatedItemFactory.TranslatedItem item) {
        try {
            FileUtils.copyFileToDirectoryIfModified((File)item.getSourceFile(), (File)item.getTargetFile().getParentFile());
        }
        catch (IOException e) {
            throw new JDocBookProcessException("unable to copy file [ " + item.getSourceFile() + " ] to directory [ " + item.getTargetFile().getParentFile() + " ]");
        }
    }

    private void findAllInclusionFiles(File masterFile, Set<File> files) {
        if (masterFile == null || !masterFile.exists() || !masterFile.getName().endsWith("xml")) {
            return;
        }
        Set<File> inclusions = XIncludeHelper.locateInclusions(masterFile);
        if (inclusions == null || inclusions.isEmpty()) {
            return;
        }
        for (File inclusion : inclusions) {
            if (!inclusion.exists()) {
                this.getLog().info("skipping translation; inclusion file did not exist : [ " + inclusion + " ]");
                continue;
            }
            files.add(inclusion);
            this.findAllInclusionFiles(inclusion, files);
        }
    }

    private void generateTranslatedXML(File masterFile, File poFile, File translatedFile) {
        boolean created;
        if (!masterFile.exists()) {
            this.getLog().trace("skipping translation; source file did not exist : {0}", masterFile);
            return;
        }
        if (!poFile.exists()) {
            this.getLog().trace("skipping translation; PO file did not exist : {0}", poFile);
            return;
        }
        if (translatedFile.exists() && translatedFile.lastModified() >= masterFile.lastModified() && translatedFile.lastModified() >= poFile.lastModified()) {
            this.getLog().trace("skipping translation; up-to-date : {0}", translatedFile);
            return;
        }
        if (!translatedFile.getParentFile().exists() && !(created = translatedFile.getParentFile().mkdirs())) {
            this.getLog().info("Unable to create directories for translation");
        }
        CommandLine commandLine = CommandLine.parse((String)"po2xml");
        commandLine.addArgument(FileUtils.resolveFullPathName(masterFile));
        commandLine.addArgument(FileUtils.resolveFullPathName(poFile));
        try {
            FileOutputStream xmlStream = new FileOutputStream(translatedFile);
            DefaultExecutor executor = new DefaultExecutor();
            try {
                PumpStreamHandler streamDirector = new PumpStreamHandler((OutputStream)xmlStream, (OutputStream)System.err);
                executor.setStreamHandler((ExecuteStreamHandler)streamDirector);
                executor.execute(commandLine);
            }
            catch (IOException ioe) {
                throw new JDocBookProcessException("unable to execute po2xml : " + ioe.getMessage());
            }
            finally {
                try {
                    xmlStream.flush();
                    xmlStream.close();
                }
                catch (IOException ignore) {}
            }
        }
        catch (IOException e) {
            throw new JDocBookProcessException("unable to open output stream for translated XML file [" + translatedFile + "]");
        }
    }
}

