/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jdocbook.render.impl.fop;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationUtil;
import org.apache.avalon.framework.configuration.DefaultConfiguration;
import org.apache.fop.fonts.EmbedFontInfo;
import org.apache.fop.fonts.FontCache;
import org.apache.fop.fonts.FontEventListener;
import org.apache.fop.fonts.FontResolver;
import org.apache.fop.fonts.FontSetup;
import org.apache.fop.fonts.FontTriplet;
import org.apache.fop.fonts.autodetect.FontInfoFinder;
import org.jboss.jdocbook.JDocBookProcessException;
import org.jboss.jdocbook.render.RenderingEnvironment;
import org.jdom.input.DOMBuilder;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FopConfigHelper {
    public static final String FONT_CACHE_FILE = "fop/fop-fonts.cache";
    private static FopConfigHelper INSTANCE;
    private RenderingEnvironment environment;
    private DefaultConfiguration fopConfiguration;
    private File fopWorkDirectory;

    public static DefaultConfiguration getFopConfiguration(RenderingEnvironment environment) {
        if (INSTANCE == null) {
            environment.log().info("creating FOP user-config DOM");
            INSTANCE = new FopConfigHelper(environment);
        }
        return FopConfigHelper.INSTANCE.fopConfiguration;
    }

    public FopConfigHelper(RenderingEnvironment environment) {
        this.environment = environment;
        this.fopConfiguration = this.buildFopConfiguration();
    }

    private DefaultConfiguration buildFopConfiguration() {
        DefaultConfiguration fopUserConfiguration = new DefaultConfiguration("fop");
        fopUserConfiguration.setAttribute("version", "1.0");
        DefaultConfiguration strictConfig = new DefaultConfiguration("strict-configuration");
        strictConfig.setValue(true);
        fopUserConfiguration.addChild((Configuration)strictConfig);
        DefaultConfiguration renderersConfig = new DefaultConfiguration("renderers");
        fopUserConfiguration.addChild((Configuration)renderersConfig);
        DefaultConfiguration pdfRendererConfig = new DefaultConfiguration("renderer");
        pdfRendererConfig.setAttribute("mime", "application/pdf");
        renderersConfig.addChild((Configuration)pdfRendererConfig);
        pdfRendererConfig.addChild((Configuration)this.buildFontsConfig());
        this.dumpUserConfigToFile(fopUserConfiguration);
        return fopUserConfiguration;
    }

    private DefaultConfiguration buildFontsConfig() {
        DefaultConfiguration fontsConfig = new DefaultConfiguration("fonts");
        for (EmbedFontInfo embedFontInfo : this.locateEmbedFontInfos()) {
            DefaultConfiguration fontConfig = new DefaultConfiguration("font");
            fontsConfig.addChild((Configuration)fontConfig);
            fontConfig.setAttribute("embed-url", embedFontInfo.getEmbedFile());
            if (embedFontInfo.getSubFontName() != null) {
                fontConfig.setAttribute("sub-font", embedFontInfo.getSubFontName());
            }
            FontTriplet triplet = (FontTriplet)embedFontInfo.getFontTriplets().get(0);
            fontConfig.addChild((Configuration)this.generateFontTripletConfig(triplet.getName(), triplet.getStyle(), triplet.getWeight()));
            fontConfig.addChild((Configuration)this.generateFontTripletConfig(triplet.getName(), "normal", "bold"));
            fontConfig.addChild((Configuration)this.generateFontTripletConfig(triplet.getName(), "italic", "bold"));
            fontConfig.addChild((Configuration)this.generateFontTripletConfig(triplet.getName(), "italic", "normal"));
        }
        if (this.environment.getOptions().isAutoDetectFontsEnabled()) {
            DefaultConfiguration autoDetect = new DefaultConfiguration("auto-detect");
            fontsConfig.addChild((Configuration)autoDetect);
        }
        return fontsConfig;
    }

    private List<EmbedFontInfo> locateEmbedFontInfos() {
        ArrayList<EmbedFontInfo> infoList = new ArrayList<EmbedFontInfo>();
        if (this.environment.getFontDirectories() != null) {
            FontCache fontCache = this.environment.getOptions().isUseFopFontCache() ? FontCache.loadFrom((File)new File(this.getFopWorkDirectory(), "fop-font.cache")) : new FontCache();
            FontResolver fontResolver = FontSetup.createMinimalFontResolver();
            FontInfoFinder fontInfoFinder = new FontInfoFinder();
            fontInfoFinder.setEventListener(new FontEventListener(){

                public void fontSubstituted(Object source, FontTriplet requested, FontTriplet effective) {
                    FopConfigHelper.this.environment.log().info("FOP font substitution : " + requested + " -> " + effective + "; source=" + source);
                }

                public void fontLoadingErrorAtAutoDetection(Object source, String fontURL, Exception e) {
                    FopConfigHelper.this.environment.log().info("FOP autodetect font loading error : " + fontURL + "; source=" + source, e);
                }

                public void glyphNotAvailable(Object source, char ch, String fontName) {
                    FopConfigHelper.this.environment.log().trace("Glyph not available for character [" + ch + "] in font " + fontName + "; source=" + source);
                }
            });
            for (File fontDirectory : this.environment.getFontDirectories()) {
                for (File fontFile : fontDirectory.listFiles()) {
                    EmbedFontInfo[] infos = fontInfoFinder.find(this.toURL(fontFile), fontResolver, fontCache);
                    if (infos == null || infos.length == 0) continue;
                    for (EmbedFontInfo info : infos) {
                        if (info.getEmbedFile() == null) continue;
                        infoList.add(info);
                    }
                }
            }
        }
        return infoList;
    }

    private URL toURL(File file) {
        try {
            return file.toURI().toURL();
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
    }

    private DefaultConfiguration generateFontTripletConfig(String name, String style, int weight) {
        return this.generateFontTripletConfig(name, style, weight >= 700 ? "bold" : "normal");
    }

    private DefaultConfiguration generateFontTripletConfig(String name, String style, String weight) {
        DefaultConfiguration tripletConfig = new DefaultConfiguration("font-triplet");
        tripletConfig.setAttribute("name", name);
        tripletConfig.setAttribute("style", style);
        tripletConfig.setAttribute("weight", weight);
        return tripletConfig;
    }

    private File getFopWorkDirectory() {
        if (this.fopWorkDirectory == null) {
            File dir = new File(this.environment.getWorkDirectory(), "fop");
            if (dir.exists()) {
                this.fopWorkDirectory = dir;
            } else {
                boolean created = dir.mkdirs();
                if (created) {
                    this.fopWorkDirectory = dir;
                } else {
                    this.environment.log().info("Problem creating fop work directory");
                }
            }
        }
        return this.fopWorkDirectory;
    }

    private void dumpUserConfigToFile(DefaultConfiguration fopUserConfiguration) {
        File dumpFile = new File(this.getFopWorkDirectory(), "generated-user-config.xml");
        if (!dumpFile.exists()) {
            try {
                dumpFile.createNewFile();
            }
            catch (IOException e) {
                this.environment.log().error("Unable to dump generated FOP user config", e);
            }
        }
        try {
            BufferedOutputStream outputStream = new BufferedOutputStream(new FileOutputStream(dumpFile));
            XMLOutputter outputter = new XMLOutputter(Format.getCompactFormat().setIndent("  "));
            outputter.output(new DOMBuilder().build(ConfigurationUtil.toElement((Configuration)fopUserConfiguration)), (OutputStream)outputStream);
        }
        catch (FileNotFoundException e) {
            throw new JDocBookProcessException("unable to open file for writing generated FOP user-config", e);
        }
        catch (IOException e) {
            this.environment.log().info("Unable to write generated FOP user-config to file", e);
        }
    }
}

