/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jdocbook.i18n.gettext;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashSet;
import org.apache.commons.exec.CommandLine;
import org.apache.commons.exec.DefaultExecutor;
import org.apache.commons.exec.ExecuteStreamHandler;
import org.apache.commons.exec.PumpStreamHandler;
import org.jboss.jdocbook.JDocBookProcessException;
import org.jboss.jdocbook.Log;
import org.jboss.jdocbook.i18n.I18nEnvironment;
import org.jboss.jdocbook.i18n.I18nSource;
import org.jboss.jdocbook.i18n.MasterTranslationDescriptor;
import org.jboss.jdocbook.i18n.TranslationBuilder;
import org.jboss.jdocbook.util.FileUtils;
import org.jboss.jdocbook.util.I18nUtils;
import org.jboss.jdocbook.util.XIncludeHelper;

public class TranslationBuilderImpl
implements TranslationBuilder {
    private final I18nEnvironment environment;

    public TranslationBuilderImpl(I18nEnvironment environment) {
        this.environment = environment;
    }

    private Log getLog() {
        return this.environment.log();
    }

    public void buildTranslations() throws JDocBookProcessException {
        MasterTranslationDescriptor master = this.environment.getMasterTranslationDescriptor();
        for (I18nSource source : this.environment.getI18nSources(true)) {
            this.buildTranslation(master.resolveMasterDocument(), source.resolvePoDirectory(), source.resolveTranslatedXmlDirectory());
        }
    }

    public void buildTranslation(File masterFile, File basePoDirectory, File targetDirectory) throws JDocBookProcessException {
        this.getLog().trace("starting translation [" + masterFile + "]");
        if (!masterFile.exists()) {
            this.getLog().info("skipping translation; master file did not exist : {}", masterFile);
            return;
        }
        HashSet<File> files = new HashSet<File>();
        XIncludeHelper.findAllInclusionFiles(masterFile, files);
        files.add(masterFile);
        File baseDir = masterFile.getParentFile();
        for (File file : files) {
            String relativity = FileUtils.determineRelativity(file, baseDir);
            File relativeWorkDir = relativity == null ? targetDirectory : new File(targetDirectory, relativity);
            File translatedFile = new File(relativeWorkDir, file.getName());
            if (FileUtils.isXMLFile(file)) {
                String poFileName;
                File relativeTranslationDir = relativity == null ? basePoDirectory : new File(basePoDirectory, relativity);
                File poFile = new File(relativeTranslationDir, poFileName = I18nUtils.determinePoFileName(file));
                if (!poFile.exists()) {
                    throw new JDocBookProcessException("Unable to locate PO file for [" + file + "] in [" + basePoDirectory + "]");
                }
                this.generateTranslatedXML(file, poFile, translatedFile);
                continue;
            }
            try {
                FileUtils.copyFileToDirectoryIfModified((File)file, (File)translatedFile.getParentFile());
            }
            catch (IOException e) {
                throw new JDocBookProcessException("unable to copy file [ " + file + " ] to directory [ " + translatedFile.getParentFile() + " ]");
            }
        }
    }

    private void generateTranslatedXML(File masterFile, File poFile, File translatedFile) {
        boolean created;
        if (!masterFile.exists()) {
            this.getLog().trace("skipping translation; source file did not exist : {0}", masterFile);
            return;
        }
        if (!poFile.exists()) {
            this.getLog().trace("skipping translation; PO file did not exist : {0}", poFile);
            return;
        }
        if (translatedFile.exists() && translatedFile.lastModified() >= masterFile.lastModified() && translatedFile.lastModified() >= poFile.lastModified()) {
            this.getLog().trace("skipping translation; up-to-date : {0}", translatedFile);
            return;
        }
        if (!translatedFile.getParentFile().exists() && !(created = translatedFile.getParentFile().mkdirs())) {
            this.getLog().info("Unable to create directories for translation");
        }
        CommandLine commandLine = CommandLine.parse((String)"po2xml");
        commandLine.addArgument(FileUtils.resolveFullPathName(masterFile));
        commandLine.addArgument(FileUtils.resolveFullPathName(poFile));
        try {
            FileOutputStream xmlStream = new FileOutputStream(translatedFile);
            DefaultExecutor executor = new DefaultExecutor();
            try {
                PumpStreamHandler streamDirector = new PumpStreamHandler((OutputStream)xmlStream, (OutputStream)System.err);
                executor.setStreamHandler((ExecuteStreamHandler)streamDirector);
                executor.execute(commandLine);
            }
            catch (IOException ioe) {
                throw new JDocBookProcessException("unable to execute po2xml : " + ioe.getMessage());
            }
            finally {
                try {
                    xmlStream.flush();
                    xmlStream.close();
                }
                catch (IOException ignore) {}
            }
        }
        catch (IOException e) {
            throw new JDocBookProcessException("unable to open output stream for translated XML file [" + translatedFile + "]");
        }
    }
}

