/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jdocbook.xslt;

import com.icl.saxon.Controller;
import java.io.IOException;
import java.io.Writer;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.URIResolver;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.stream.StreamSource;
import org.jboss.jdocbook.Environment;
import org.jboss.jdocbook.Options;
import org.jboss.jdocbook.render.format.FormatPlan;
import org.jboss.jdocbook.util.NoOpWriter;
import org.jboss.jdocbook.util.ResourceHelper;
import org.jboss.jdocbook.xslt.XSLTException;
import org.jboss.jdocbook.xslt.resolve.ClasspathResolver;
import org.jboss.jdocbook.xslt.resolve.CurrentVersionResolver;
import org.jboss.jdocbook.xslt.resolve.ExplicitUrnResolver;
import org.jboss.jdocbook.xslt.resolve.RelativeJarUriResolver;
import org.jboss.jdocbook.xslt.resolve.ResolverChain;
import org.jboss.jdocbook.xslt.resolve.VersionResolver;

public class TransformerBuilder {
    private final Environment environment;
    private HashMap<String, Templates> transformerTemplatesCache = new HashMap();

    public TransformerBuilder(Environment environment) {
        this.environment = environment;
    }

    private Options options() {
        return this.environment.getOptions();
    }

    private ResourceHelper resourceHelper() {
        return this.environment.getResourceHelper();
    }

    public Transformer buildStandardTransformer(URL xslt) {
        ResolverChain uriResolver = this.buildStandardUriResolver();
        return this.buildTransformer(xslt, uriResolver);
    }

    public Transformer buildStandardTransformer(String xsltResource) {
        ResolverChain uriResolver = this.buildStandardUriResolver();
        return this.buildTransformer(this.resourceHelper().requireResource(xsltResource), uriResolver);
    }

    public Transformer buildTransformer(FormatPlan formatPlan, URL customStylesheet) throws XSLTException {
        ResolverChain uriResolver = this.buildUriResolver(formatPlan);
        URL xsltStylesheet = customStylesheet == null ? this.resourceHelper().requireResource(formatPlan.getStylesheetResource()) : customStylesheet;
        return this.buildTransformer(xsltStylesheet, uriResolver);
    }

    protected Transformer buildTransformer(URL xslt, URIResolver uriResolver) throws XSLTException {
        Transformer transformer;
        SAXTransformerFactory transformerFactory = this.options().resolveXmlTransformerType().getSAXTransformerFactory();
        transformerFactory.setURIResolver(uriResolver);
        String xsltUrlStr = xslt.toExternalForm();
        try {
            Templates transformerTemplates = this.transformerTemplatesCache.get(xsltUrlStr);
            if (transformerTemplates == null) {
                StreamSource source = new StreamSource(xslt.openStream(), xsltUrlStr);
                transformerTemplates = transformerFactory.newTemplates(source);
                this.transformerTemplatesCache.put(xsltUrlStr, transformerTemplates);
            }
            transformer = transformerTemplates.newTransformer();
        }
        catch (IOException e) {
            throw new XSLTException("problem opening stylesheet [" + xsltUrlStr + "]", e);
        }
        catch (TransformerConfigurationException e) {
            throw new XSLTException("unable to build transformer [" + e.getLocationAsString() + "] : " + e.getMessage(), e);
        }
        TransformerBuilder.configureTransformer(transformer, uriResolver, this.options().getTransformerParameters());
        return transformer;
    }

    public void configureTransformer(Transformer transformer, FormatPlan formatPlan) {
        TransformerBuilder.configureTransformer(transformer, this.buildUriResolver(formatPlan), this.options().getTransformerParameters());
    }

    public static void configureTransformer(Transformer transformer, URIResolver uriResolver, Properties transformerParameters) {
        if (transformer instanceof Controller) {
            Controller controller = (Controller)transformer;
            try {
                controller.makeMessageEmitter();
                controller.getMessageEmitter().setWriter((Writer)new NoOpWriter());
            }
            catch (TransformerException te) {
                // empty catch block
            }
        }
        transformer.setURIResolver(uriResolver);
        transformer.setParameter("fop.extensions", "0");
        transformer.setParameter("fop1.extensions", "1");
        if (transformerParameters == null) {
            return;
        }
        for (Map.Entry<Object, Object> entry : transformerParameters.entrySet()) {
            transformer.setParameter((String)entry.getKey(), entry.getValue());
        }
    }

    public ResolverChain buildStandardUriResolver() {
        ResolverChain resolverChain = new ResolverChain();
        this.applyStandardResolvers(resolverChain);
        return resolverChain;
    }

    public ResolverChain buildUriResolver(FormatPlan formatPlan) throws XSLTException {
        return this.buildUriResolver(formatPlan.getName(), formatPlan.getCorrespondingDocBookStylesheetResource());
    }

    public ResolverChain buildUriResolver(String formatName, String docBookstyleSheet) throws XSLTException {
        ResolverChain resolverChain = new ResolverChain(new ExplicitUrnResolver(this.environment, formatName, docBookstyleSheet));
        this.applyStandardResolvers(resolverChain);
        return resolverChain;
    }

    private void applyStandardResolvers(ResolverChain resolverChain) {
        resolverChain.addResolver(new CurrentVersionResolver(this.environment));
        if (this.options().getDocbookVersion() != null) {
            resolverChain.addResolver(new VersionResolver(this.environment, this.options().getDocbookVersion()));
        }
        resolverChain.addResolver(new RelativeJarUriResolver());
        resolverChain.addResolver(new ClasspathResolver(this.resourceHelper().getCombinedClassLoader()));
        resolverChain.addResolver((URIResolver)this.environment.getCatalogResolver());
    }
}

