/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.maven.plugins.jdocbook;

import java.io.File;
import java.io.IOException;
import org.codehaus.plexus.archiver.ArchiverException;
import org.codehaus.plexus.archiver.jar.JarArchiver;
import org.jboss.jdocbook.render.RenderingException;
import org.jboss.jdocbook.xslt.XSLTException;
import org.jboss.maven.plugins.jdocbook.AbstractDocBookMojo;
import org.jboss.maven.plugins.jdocbook.Format;
import org.jboss.maven.plugins.jdocbook.Matcher;

public class PackageMojo
extends AbstractDocBookMojo {
    @Override
    protected void process() throws RenderingException, XSLTException {
        File projectArtifactFile = new File(this.project.getBuild().getOutputDirectory(), this.project.getBuild().getFinalName() + ".war");
        JarArchiver warBuilder = new JarArchiver();
        warBuilder.setDestFile(projectArtifactFile);
        Matcher<String> formatMatcher = new Matcher<String>(this.getRequestedFormat());
        try {
            for (AbstractDocBookMojo.PublishingSource source : this.resolvePublishingSources()) {
                for (Format format : this.getFormatOptionsList()) {
                    if (!formatMatcher.matches(format.getName())) continue;
                    warBuilder.addDirectory(new File(source.resolvePublishingBaseDirectory(), format.getName()), format.getName() + "/");
                }
            }
            warBuilder.createArchive();
        }
        catch (IOException e) {
            throw new RenderingException("Unable to create archive [" + projectArtifactFile.getAbsolutePath() + "]", (Throwable)e);
        }
        catch (ArchiverException e) {
            throw new RenderingException("Unable to populate archive [" + projectArtifactFile.getAbsolutePath() + "]", (Throwable)e);
        }
        this.project.getArtifact().setFile(projectArtifactFile);
    }
}

