/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aop.microcontainer.beans;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import org.jboss.aop.AspectManager;
import org.jboss.aop.advice.AspectDefinition;
import org.jboss.aop.advice.AspectFactory;
import org.jboss.aop.advice.Scope;
import org.jboss.aop.advice.ScopeUtil;
import org.jboss.aop.instrument.Untransformable;
import org.jboss.aop.microcontainer.beans.Binding;
import org.jboss.aop.microcontainer.beans.DelegatingBeanAspectFactory;
import org.jboss.aop.microcontainer.beans.GenericBeanAspectFactory;
import org.jboss.aop.microcontainer.beans.ManagedAspectDefinition;
import org.jboss.beans.metadata.plugins.factory.GenericBeanFactory;
import org.jboss.beans.metadata.spi.factory.BeanFactory;
import org.jboss.logging.Logger;
import org.w3c.dom.Element;

public class Aspect
implements Untransformable {
    private static final Logger log = Logger.getLogger(Aspect.class);
    protected AspectManager manager;
    protected boolean factory;
    protected Scope scope;
    protected ManagedAspectDefinition definition;
    protected GenericBeanFactory advice;
    protected String adviceBean;
    protected String name;
    protected Map<String, Binding> bindings = new LinkedHashMap<String, Binding>();
    private Element element;

    public String getName() {
        return this.name;
    }

    public void setFactory(boolean factory) {
        this.factory = factory;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getAdviceBean() {
        return this.adviceBean;
    }

    public void setAdviceBean(String adviceBean) {
        this.adviceBean = adviceBean;
    }

    public AspectDefinition getDefinition() {
        return this.definition;
    }

    public AspectManager getManager() {
        return this.manager;
    }

    public void setManager(AspectManager manager) {
        this.manager = manager;
    }

    public GenericBeanFactory getAdvice() {
        return this.advice;
    }

    public void setAdvice(GenericBeanFactory advice) {
        this.advice = advice;
    }

    public String getScope() {
        return this.scope.toString();
    }

    public void setScope(String scope) {
        this.scope = ScopeUtil.parse((String)scope);
    }

    public void setElement(Element element) {
        this.element = element;
    }

    public void install(GenericBeanFactory factory) throws Exception {
        this.advice = factory;
        this.start();
    }

    public void start() throws Exception {
        if (this.definition == null) {
            if (this.manager == null) {
                throw new IllegalArgumentException("Null manager");
            }
            if (this.name == null) {
                throw new IllegalArgumentException("Null name");
            }
            if (this.advice != null) {
                this.definition = this.getAspectDefinitionNoDependencies();
            } else if (this.adviceBean != null) {
                this.definition = this.getAspectDefintionDependencies();
            } else {
                throw new IllegalStateException("Unknown type of managed aspects");
            }
            this.addDefinitionToManager();
        }
        if (this.adviceBean != null && this.advice != null) {
            this.definition.setDeployed(true);
            GenericBeanAspectFactory factory = (GenericBeanAspectFactory)this.definition.getFactory();
            factory.setBeanFactory(this.advice);
        }
        ArrayList<Binding> clonedBindings = new ArrayList<Binding>();
        for (Binding aspectBinding : this.bindings.values()) {
            clonedBindings.add(aspectBinding);
        }
        for (Binding binding : clonedBindings) {
            binding.rebind();
        }
        log.debug((Object)("Bound aspect " + this.name + "; deployed:" + this.definition.isDeployed()));
    }

    protected ManagedAspectDefinition getAspectDefinitionNoDependencies() {
        Object factory = this.factory ? new DelegatingBeanAspectFactory(this.name, (BeanFactory)this.advice, this.element) : new GenericBeanAspectFactory(this.name, this.advice, this.element);
        return new ManagedAspectDefinition(this.name, this.scope, (AspectFactory)factory);
    }

    protected ManagedAspectDefinition getAspectDefintionDependencies() {
        Object factory = this.factory ? new DelegatingBeanAspectFactory(this.name, (BeanFactory)this.advice, this.element) : new GenericBeanAspectFactory(this.name, this.advice, this.element);
        return new ManagedAspectDefinition(this.name, this.scope, (AspectFactory)factory, this.adviceBean, false);
    }

    protected void addDefinitionToManager() {
        this.manager.addAspectDefinition((AspectDefinition)this.definition);
    }

    public void uninstall() throws Exception {
        this.stop();
    }

    public void stop() {
        log.debug((Object)("Unbinding aspect " + this.name));
        this.manager.removeAspectDefinition(this.name);
        if (this.definition != null) {
            this.definition.undeploy();
            this.definition = null;
        }
    }

    void addBinding(Binding binding) {
        this.bindings.put(binding.getName(), binding);
    }

    void removeBinding(Binding binding) {
        this.bindings.remove(binding.getName());
    }
}

