/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dependency.plugins;

import java.util.concurrent.Executor;
import org.jboss.dependency.plugins.AbstractController;
import org.jboss.dependency.spi.ControllerContext;
import org.jboss.dependency.spi.ControllerState;
import org.jboss.dependency.spi.ScopeInfo;
import org.jboss.metadata.spi.scope.ScopeKey;
import org.jboss.util.JBossStringBuilder;

public abstract class ScopedController
extends AbstractController {
    private ScopeKey scopeKey;
    private AbstractController underlyingController;

    protected Executor getExecutionEnvironment() {
        Executor executor = super.getExecutionEnvironment();
        if (executor == null) {
            executor = this.getParentController().getExecutionEnvironment();
        }
        return executor;
    }

    public ScopeKey getScopeKey() {
        return this.scopeKey;
    }

    protected void setScopeKey(ScopeKey scopeKey) {
        this.scopeKey = scopeKey.clone();
        this.scopeKey.freeze();
    }

    protected void setUnderlyingController(AbstractController underlyingController) {
        this.underlyingController = underlyingController;
    }

    protected void preAliasInstall(ControllerContext aliasContext) {
        ScopeInfo scopeInfo = aliasContext.getScopeInfo();
        scopeInfo.setInstallScope(this.scopeKey);
    }

    public ControllerContext getContextLocally(Object name, ControllerState state) {
        return super.getContext(name, state);
    }

    protected boolean isScoped() {
        return this.underlyingController != null;
    }

    protected void addControllerContext(ControllerContext context) {
        if (this.isScoped()) {
            this.lockWrite();
            try {
                this.underlyingController.removeControllerContext(context);
                context.setController(this);
                this.registerControllerContext(context);
            }
            catch (Throwable t) {
                context.setController(this.underlyingController);
                this.underlyingController.addControllerContext(context);
                if (t instanceof RuntimeException) {
                    throw (RuntimeException)t;
                }
                throw new RuntimeException(t);
            }
            finally {
                this.unlockWrite();
            }
        } else {
            super.addControllerContext(context);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeControllerContext(ControllerContext context) {
        if (this.isScoped()) {
            this.lockWrite();
            try {
                this.unregisterControllerContext(context);
                context.setController(this.underlyingController);
                this.underlyingController.addControllerContext(context);
            }
            finally {
                this.unlockWrite();
            }
        } else {
            super.removeControllerContext(context);
        }
    }

    protected void toString(JBossStringBuilder buffer) {
        super.toString(buffer);
        buffer.append((Object)this.getScopeKey());
    }
}

