/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.kernel.plugins.annotations;

import java.lang.annotation.Annotation;
import java.lang.annotation.ElementType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jboss.beans.metadata.plugins.AbstractParameterMetaData;
import org.jboss.beans.metadata.plugins.builder.MutableParameterizedMetaData;
import org.jboss.beans.metadata.spi.BeanMetaData;
import org.jboss.beans.metadata.spi.MetaDataVisitorNode;
import org.jboss.beans.metadata.spi.ParameterMetaData;
import org.jboss.beans.metadata.spi.ValueMetaData;
import org.jboss.kernel.plugins.annotations.AbstractAdaptersAnnotationPlugin;
import org.jboss.kernel.plugins.annotations.Annotation2ValueMetaDataAdapter;
import org.jboss.kernel.plugins.config.Configurator;
import org.jboss.metadata.spi.MetaData;
import org.jboss.metadata.spi.signature.Signature;
import org.jboss.reflect.spi.AnnotatedInfo;
import org.jboss.reflect.spi.ParameterInfo;
import org.jboss.reflect.spi.TypeInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractParameterAnnotationPlugin<T extends AnnotatedInfo, C extends Annotation, P extends MutableParameterizedMetaData>
extends AbstractAdaptersAnnotationPlugin<T, C> {
    protected AbstractParameterAnnotationPlugin(Class<C> annotation, Set<Annotation2ValueMetaDataAdapter<? extends Annotation>> adapters) {
        super(annotation, adapters);
    }

    protected abstract boolean checkAnnotatedInfo(ElementType var1);

    @Override
    protected boolean isElementTypeSupported(ElementType type) {
        return ElementType.PARAMETER == type || this.checkAnnotatedInfo(type);
    }

    protected abstract ParameterInfo[] getParameters(T var1);

    protected abstract List<? extends MetaDataVisitorNode> handleParameterlessInfo(T var1, C var2, BeanMetaData var3);

    protected P createParametrizedMetaData(T info, C annotation, BeanMetaData beanMetaData) {
        return this.createParametrizedMetaData(info, annotation);
    }

    protected P createParametrizedMetaData(T info, C annotation) {
        return this.createParametrizedMetaData(info);
    }

    protected P createParametrizedMetaData(T info) {
        throw new IllegalArgumentException("Should implement one of createParameterizedMetaData methods!");
    }

    protected abstract void setParameterizedMetaData(P var1, BeanMetaData var2);

    @Override
    protected List<? extends MetaDataVisitorNode> internalApplyAnnotation(T info, MetaData retrieval, C annotation, BeanMetaData beanMetaData) throws Throwable {
        boolean trace = this.log.isTraceEnabled();
        ParameterInfo[] parameters = this.getParameters(info);
        if (parameters == null || parameters.length == 0) {
            if (trace) {
                this.log.trace((Object)("Info " + info + " has zero parameters."));
            }
            return this.handleParameterlessInfo(info, annotation, beanMetaData);
        }
        TypeInfo[] typeInfos = new TypeInfo[parameters.length];
        for (int i = 0; i < parameters.length; ++i) {
            typeInfos[i] = parameters[i].getParameterType();
        }
        ArrayList<ParameterMetaData> pmds = new ArrayList<ParameterMetaData>();
        for (int i = 0; i < parameters.length; ++i) {
            ValueMetaData value;
            ParameterInfo pi = parameters[i];
            Signature pis = this.createParametersSignature(pi.getName(), Configurator.getParameterTypes(this.log.isTraceEnabled(), typeInfos), i);
            MetaData mdr = retrieval.getComponentMetaData(pis);
            if (mdr != null) {
                value = null;
                for (Annotation2ValueMetaDataAdapter adapter : this.adapters) {
                    Annotation adapterAnnotation = mdr.getAnnotation(adapter.getAnnotation());
                    if (adapterAnnotation == null) continue;
                    value = adapter.createValueMetaData(adapterAnnotation, value);
                }
                if (value == null) {
                    throw new IllegalArgumentException("No such Annotation2ValueMetaData adapter or no annotation on ParameterInfo: " + pi);
                }
                if (trace) {
                    this.log.trace((Object)("Adding new ParameterMetaData for annotation: " + value));
                }
            } else {
                throw new IllegalArgumentException("MetaData for parameter must exist: " + pi);
            }
            pmds.add(new AbstractParameterMetaData(pi.getParameterType().getName(), value));
        }
        P parameterizedMetaData = this.createParametrizedMetaData(info, annotation, beanMetaData);
        this.setParameterizedMetaData(parameterizedMetaData, beanMetaData);
        parameterizedMetaData.setParameters(pmds);
        if (!(parameterizedMetaData instanceof MetaDataVisitorNode)) {
            throw new IllegalArgumentException("ParameterizedMetaData not MetaDataVisitor: " + parameterizedMetaData);
        }
        return Collections.singletonList((MetaDataVisitorNode)parameterizedMetaData);
    }

    protected abstract Signature createParametersSignature(String var1, String[] var2, int var3);
}

