/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.beans.metadata.spi.factory;

import java.util.List;
import java.util.Map;
import org.jboss.beans.info.spi.BeanAccessMode;
import org.jboss.beans.info.spi.BeanInfo;
import org.jboss.beans.metadata.spi.ClassLoaderMetaData;
import org.jboss.beans.metadata.spi.ConstructorMetaData;
import org.jboss.beans.metadata.spi.LifecycleMetaData;
import org.jboss.beans.metadata.spi.ParameterMetaData;
import org.jboss.beans.metadata.spi.ValueMetaData;
import org.jboss.beans.metadata.spi.factory.BeanFactory;
import org.jboss.joinpoint.spi.JoinpointException;
import org.jboss.joinpoint.spi.MethodJoinpoint;
import org.jboss.kernel.spi.config.KernelConfigurator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractBeanFactory
implements BeanFactory {
    protected KernelConfigurator configurator;
    protected String bean;
    protected BeanAccessMode accessMode;
    protected ClassLoaderMetaData classLoader;
    protected ConstructorMetaData constructor;
    protected Map<String, ValueMetaData> properties;
    protected LifecycleMetaData create;
    protected LifecycleMetaData start;

    protected AbstractBeanFactory(KernelConfigurator configurator) {
        if (configurator == null) {
            throw new IllegalArgumentException("Null configurator");
        }
        this.configurator = configurator;
    }

    protected KernelConfigurator getConfigurator() {
        return this.configurator;
    }

    public String getBean() {
        return this.bean;
    }

    public void setBean(String bean) {
        this.bean = bean;
    }

    public BeanAccessMode getAccessMode() {
        return this.accessMode;
    }

    public void setAccessMode(BeanAccessMode accessMode) {
        this.accessMode = accessMode;
    }

    public ClassLoaderMetaData getClassLoader() {
        return this.classLoader;
    }

    public void setClassLoader(ClassLoaderMetaData classLoader) {
        this.classLoader = classLoader;
    }

    public ConstructorMetaData getConstructor() {
        return this.constructor;
    }

    public void setConstructor(ConstructorMetaData constructor) {
        this.constructor = constructor;
    }

    public Map<String, ValueMetaData> getProperties() {
        return this.properties;
    }

    public void setProperties(Map<String, ValueMetaData> properties) {
        this.properties = properties;
    }

    public LifecycleMetaData getCreate() {
        return this.create;
    }

    public void setCreate(LifecycleMetaData create) {
        this.create = create;
    }

    public LifecycleMetaData getStart() {
        return this.start;
    }

    public void setStart(LifecycleMetaData start) {
        this.start = start;
    }

    protected void invokeLifecycle(String methodName, LifecycleMetaData lifecycle, BeanInfo info, ClassLoader cl, Object target) throws Throwable {
        if (lifecycle == null || !lifecycle.isIgnored()) {
            MethodJoinpoint joinpoint;
            String method = methodName;
            if (lifecycle != null && lifecycle.getMethodName() != null) {
                method = lifecycle.getMethodName();
            }
            List<ParameterMetaData> parameters = null;
            if (lifecycle != null) {
                parameters = lifecycle.getParameters();
            }
            try {
                joinpoint = this.configurator.getMethodJoinPoint(info, cl, method, parameters, false, true);
            }
            catch (JoinpointException ignored) {
                return;
            }
            joinpoint.setTarget(target);
            joinpoint.dispatch();
        }
    }
}

