/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.kernel.plugins.dependency;

import org.jboss.dependency.spi.ControllerState;
import org.jboss.dependency.spi.DependencyInfo;
import org.jboss.kernel.plugins.dependency.InstallsAwareAction;
import org.jboss.kernel.spi.dependency.InstantiateKernelControllerContextAware;
import org.jboss.kernel.spi.dependency.KernelController;
import org.jboss.kernel.spi.dependency.KernelControllerContext;
import org.jboss.kernel.spi.dependency.KernelControllerContextAware;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AutowireAction
extends InstallsAwareAction {
    @Override
    protected void installActionInternal(KernelControllerContext context) throws Throwable {
        KernelController controller = (KernelController)context.getController();
        DependencyInfo dependencyInfo = context.getDependencyInfo();
        if (dependencyInfo != null && dependencyInfo.isAutowireCandidate()) {
            controller.addInstantiatedContext(context);
        }
    }

    @Override
    protected void uninstallActionInternal(KernelControllerContext context) {
        try {
            KernelController controller = (KernelController)context.getController();
            DependencyInfo dependencyInfo = context.getDependencyInfo();
            if (dependencyInfo != null && dependencyInfo.isAutowireCandidate()) {
                controller.removeInstantiatedContext(context);
            }
        }
        catch (Throwable ignored) {
            this.log.debug((Object)"Ignored error unsetting context ", ignored);
        }
    }

    @Override
    protected ControllerState getState() {
        return ControllerState.INSTANTIATED;
    }

    @Override
    protected Class<? extends KernelControllerContextAware> getActionAwareInterface() {
        return InstantiateKernelControllerContextAware.class;
    }
}

